



<?php
global $wpdb;

// Fetch license key
$license = $wpdb->get_row(
    "SELECT licence_key FROM {$wpdb->prefix}bca_licence_detail"
);


// Default to non-premium
$is_premium = false;
$is_standard = false;
$is_free = false;


if ($license && !empty($license->licence_key)) {
    $response = wp_remote_post('https://store.baar.ai/api/validate-license-features', [
        'method'    => 'POST',
        'headers'   => ['Content-Type' => 'application/json'],
        'body'      => json_encode([
            'license_key' => $license->licence_key
        ]),
        'timeout'   => 15,
    ]);



    if (!is_wp_error($response)) {
        $body = json_decode(wp_remote_retrieve_body($response), true);

       
        if (isset($body['status']) && $body['status'] === 1) {
            $plan = strtolower($body['data']['plan']);
            $is_premium = ($plan === 'premium');
            $is_standard = ($plan === 'standard');
            $is_free = ($plan === 'free');
        }
    }
}
?>


<style>
    .blur-content {
    filter: blur(1px);
    pointer-events: none;
    user-select: none;
    position: relative;
}



    .form-row.align-items-center.role-field {
        display: flex;
    }
    div#roleRedirectLinks .form-row.align-items-center.role-field input.form-control.link-input {
        width: 100% !important;
    }
    div#roleRedirectLinks .form-row.align-items-center.role-field .role-field {
        padding: 1px;
    }
    .form-check-label.disabled {
        opacity: unset !important; 
    }

</style>
<form method="POST" action="" class="mt-4">
    <?php wp_nonce_field('bca_save_settings', 'bca_settings_nonce'); ?>
    
    <!-- Enforce Set up Section -->
    <div class="form-section">
        <div class="form-section-title">Require MFA Setup <span class="info-icon" data-toggle="tooltip" title="Admin can use this option to Enforce the MFA set up for users at the time of login or give an option to configure the set up later in their dashboard or profile. ">ℹ️</span></div>
        <div class="form-section-content">
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[enforceSetup]" id="mustComplete" value="mustComplete" <?php checked( isset($settings['enforceSetup']) && $settings['enforceSetup'] === 'mustComplete', true); ?>>
                <label class="form-check-label" for="mustComplete">
                    Force users to set up MFA when they login.
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[enforceSetup]" id="canComplete" value="canComplete" <?php checked( isset($settings['enforceSetup']) && $settings['enforceSetup'] === 'canComplete', true); ?>>
                <label class="form-check-label" for="canComplete">
                    Allow users to skip and set it up later from their Profile or Dashboard.
                </label>
            </div>
            <label class="form-check-label" for="gracePeriodDays" style="display: flex;font-weight: 400;align-items: center;">Grace Period<span class="info-icon" data-toggle="tooltip" title="Allows user to skip the MFA configuration for a certain period. If the grace period is defined, the users must configure the selected MFA method within the grace period to avoid access being blocked.">ℹ️</span><input type="text" class="form-control days" name="bca_settings[gracePeriodDays]" value="<?php echo esc_attr( isset($settings['gracePeriodDays']) ? $settings['gracePeriodDays'] : '' ); ?>" placeholder="Days" maxlength="2" style="width: 10%;margin-left: 10px;" disabled></label>
        </div>
    </div>

    <!-- Enforce Set up on Section -->
    <div class="form-section">
        <div class="form-section-title"> Who Needs to Set Up MFA? <span class="info-icon" data-toggle="tooltip" title="This option determines if the MFA is enforced on all the users or no users. Admin can also choose enforcement on specific roles and users using the dropdown option respectively.">ℹ️</span></div>
        <div class="form-section-content">
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[enforceOn]" id="allUsers" value="allUsers" 
                    <?php checked( isset($settings['enforceOn']) && $settings['enforceOn'] === 'allUsers', true); ?>>
                <label class="form-check-label" for="allUsers">
                    All Users 
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[enforceOn]" id="noEnforce" value="noEnforce" 
                    <?php checked( isset($settings['enforceOn']) && $settings['enforceOn'] === 'noEnforce', true); ?>>
                <label class="form-check-label" for="noEnforce">
                    No One 
                </label>
            </div>
            <div class="form-check <?php echo !$is_premium && !$is_standard ? 'blur-content' : ''; ?>">
                <input class="form-check-input" type="radio" name="bca_settings[enforceOn]" id="selectedUsers" value="selectedUsers" 
                    <?php checked( isset($settings['enforceOn']) && $settings['enforceOn'] === 'selectedUsers', true); ?>>
                <label class="form-check-label" for="selectedUsers">
                    Specific Users & Roles 
                </label>
            </div>

            <div class="role-inputs row  <?php echo !$is_premium && !$is_standard ? 'blur-content' : ''; ?>">
                <!-- Roles Section for selectedRoles -->
                <div class="col-sm-3">
                    <div class="multiselect" id="multiselect-selectedRoles" style="pointer-events: none;">
                        <?php
                        // Fetch the editable roles dynamically
                        $roles = get_editable_roles(); // Fetch WordPress roles dynamically

                        // Retrieve the saved selected roles from the database
                        $saved_roles = isset($settings['selectedRoles']) ? $settings['selectedRoles'] : [];

                        // Count how many roles have been selected
                        $selected_roles_count = count($saved_roles);
                        ?>

                        <div class="multiselect-btn" id="multiselect-btn-selectedRoles">
                            Select Roles (<?php echo $selected_roles_count; ?>)
                        </div>

                        <div class="multiselect-options" id="multiselect-options-selectedRoles">
                            <!-- Search Box for Roles -->
                            <input type="text" id="searchRoles" placeholder="Search roles..." class="search-box w-100">   
                            <?php
                            // Loop through each role and create the checkbox
                            foreach ($roles as $role_key => $role_name) {
                                $is_checked = in_array($role_key, $saved_roles) ? 'checked' : ''; // Check if this role is selected

                                echo '<div class="multiselect-option" data-role-name="' . strtolower($role_name['name']) . '">
                                        <input type="checkbox" value="' . $role_key . '" id="role_' . $role_key . '" name="bca_settings[selectedRoles][]" ' . $is_checked . ' disabled> ' . $role_name['name'] . '
                                    </div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <!-- Users Section -->
                <div class="col-sm-3">
                    <div class="multiselect multiselect-users" style="pointer-events: none;">
                        <?php
                        // Fetch users dynamically
                        $users = get_users(); // Fetch WordPress users dynamically

                        // Retrieve the saved selected users from the database
                        $saved_users = isset($settings['selectedUsers']) ? $settings['selectedUsers'] : [];

                        // Count how many users have been selected
                        $selected_users_count = count($saved_users);
                        ?>

                        <div class="multiselect-btn-users" id="multiselect-btn-users">
                            Select Users (<?php echo $selected_users_count; ?>)
                        </div>

                        <div class="multiselect-options-users" id="multiselect-options-users">
                        <!-- Search Box for Users -->
                        <input type="text" id="searchUsers" placeholder="Search users..." class="search-box w-100">
                            <?php
                            // Loop through each user and create the checkbox
                            foreach ($users as $user) {
                                $user_id = $user->ID;
                                $user_name = $user->user_login;
                                $is_checked = in_array($user_id, $saved_users) ? 'checked' : ''; // Check if this user is selected

                                echo '<div class="multiselect-option-users" data-user-name="' . strtolower($user_name) . '">
                                        <input type="checkbox" value="' . $user_id . '" id="user_' . $user_id . '" name="bca_settings[selectedUsers][]" ' . $is_checked . ' disabled> ' . $user_name . '
                                    </div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </div>

   <!-- User Selection Section -->
    <div class="form-section">
        <div class="form-section-title">Who Should Be Prompted for MFA Setup?<span class="info-icon" data-toggle="tooltip" title="This option determines whether MFA setup is prompted for all users or only for selected roles. The admin can choose to enforce MFA globally or limit it to specific roles using the dropdown selection.">ℹ️</span></div>
        <div class="form-section-content">
            <!-- Radio for All Users Prompt -->
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[userSelection]" id="allUsersPrompt" value="allUsersPrompt" 
                    <?php checked($userSelection, 'allUsersPrompt'); ?>>
                <label class="form-check-label" for="allUsersPrompt">
                    Prompt all users to set up MFA.
                </label>
            </div>

            <!-- Radio for Specific User Prompt -->
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[userSelection]" id="specificUser" value="specificUser" 
                    <?php checked($userSelection, 'specificUser'); ?>>
                <label class="form-check-label" for="specificUser">
                    Prompt only specific roles to set up MFA.
                </label>
            </div>

            <!-- Roles Section for promptusersetuproles -->
            <div class="col-sm-3">
                <div class="multiselect" id="multiselect-promptusersetuproles" style="pointer-events: none;">
                    <?php
                    // Fetch the editable roles dynamically
                    $roles = get_editable_roles(); // Fetch WordPress roles dynamically

                    // Retrieve the saved selected roles from the database
                    $saved_roles = isset($settings['promptusersetuproles']) ? $settings['promptusersetuproles'] : [];

                    // Count how many roles have been selected
                    $selected_roles_count = count($saved_roles);
                    ?>

                    <div class="multiselect-btn" id="multiselect-btn-promptusersetuproles">
                        Select Roles (<?php echo $selected_roles_count; ?>)
                    </div>

                    <div class="multiselect-options" id="multiselect-options-promptusersetuproles">
                        <?php
                        // Loop through each role and create the checkbox
                        foreach ($roles as $role_key => $role_name) {
                            // Check if the role is in the saved roles list
                            $is_checked = in_array($role_name['name'], $saved_roles) ? 'checked' : ''; // Check if this role is selected

                            // Render the checkbox with the checked attribute if necessary
                            echo '<div class="multiselect-option">
                                    <input type="checkbox" value="' . $role_key . '" id="role_' . $role_key . '" name="bca_settings[promptusersetuproles][]" ' . $is_checked . ' disabled> ' . $role_name['name'] . '
                                </div>';
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- MFA Setup Section -->
    <div class="form-section">
        <div class="form-section-title">Assign MFA Method</div>
        <div class="form-section-content">
            <!-- Default MFA method for all users -->
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[mfaMethod]" id="defaultMFA" value="default" <?php checked( isset($settings['mfaMethod']) && $settings['mfaMethod'] === 'default', true); ?>>
                <label class="form-check-label" for="defaultMFA">Default MFA method for all roles <span class="info-icon" data-toggle="tooltip" title="Choosing this option will enforce the selected MFA method for all users, regardless of their role">ℹ️</span></label>
            </div>

            <!-- Display the default MFA method options if 'default' is selected -->
            <div id="defaultMfaOptions" style="margin-left:30px;display: <?php echo (isset($settings['mfaMethod']) && $settings['mfaMethod'] === 'default') ? 'block' : 'none'; ?>;">
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="bca_settings[defaultMfa]" id="mfaTotp" value="totp" <?php checked( isset($settings['defaultMfa']) && $settings['defaultMfa'] === 'totp', true); ?>>
                    <label class="form-check-label" for="mfaTotp">TOTP via BAAR Auth App</label>
                </div>
                <div class="form-check <?php echo !$is_premium && !$is_standard ? 'blur-content' : ''; ?>">
                    <input class="form-check-input" type="radio" name="bca_settings[defaultMfa]" id="mfaPush" value="pushNotification" <?php checked( isset($settings['defaultMfa']) && $settings['defaultMfa'] === 'pushNotification', true); ?>>
                    <label class="form-check-label" for="mfaPush">Push Notification via BAAR Auth App</label>
                </div>
                <div class="form-check <?php echo !$is_premium && !$is_standard ? 'blur-content' : ''; ?>">
                    <input class="form-check-input" type="radio" name="bca_settings[defaultMfa]" id="mfaOtpEmail" value="otpEmail" <?php checked( isset($settings['defaultMfa']) && $settings['defaultMfa'] === 'otpEmail', true); ?>>
                    <label class="form-check-label " for="mfaOtpEmail">OTP via Email</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="bca_settings[defaultMfa]" id="mfaOtpPhone" value="otpPhone" <?php checked( isset($settings['defaultMfa']) && $settings['defaultMfa'] === 'otpPhone', true); ?> disabled="disabled">
                    <label for="mfaOtpPhone" class="form-check-label disabled">OTP via SMS (Coming Soon) </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="bca_settings[defaultMfa]" id="mfaSecurityQuestions" value="securityquestions" <?php checked( isset($settings['defaultMfa']) && $settings['defaultMfa'] === 'securityquestions', true); ?>>
                    <label class="form-check-label" for="mfaSecurityQuestions">Security Questions (KBA)</label>
                </div>
            </div>

            <!-- Assign different MFA methods based on role -->
            <div class="form-check <?php echo !$is_premium && !$is_standard ? 'blur-content' : ''; ?>">
                <input class="form-check-input" type="radio" name="bca_settings[mfaMethod]" id="roleMFA" value="role" <?php checked( isset($settings['mfaMethod']) && $settings['mfaMethod'] === 'role', true); ?>>
                <label class="form-check-label" for="roleMFA">Role-based MFA Methods <span class="info-icon" data-toggle="tooltip" title="This option allows the admin to enforce different MFA methods based on user roles.">ℹ️</span></label>
            </div>

            <!-- Section for Role-Based MFA Method Assignment -->
            <div id="roleMfaMethods" class="role-mfa-methods" style="display: none;">
                <!-- <div class="form-section-title">Role-based MFA Methods</div> -->
                <div class="role-fields-container" id="roleMfaFieldsContainer">
                    <?php 
                    // Get the list of WordPress roles
                    global $wp_roles;
                    $roles = $wp_roles->get_names();
                    
                    // Check if there are any role-specific MFA methods to display
                    if (!empty($settings['roleMfaMethods'])) {
                        foreach ($settings['roleMfaMethods'] as $role => $mfaType) {
                            echo '<div class="form-row align-items-center role-field" data-id="' . esc_attr($role) . '">';
                            echo '<div class="col-md-2">';
                            echo '<select name="bca_settings[roleMfaMethods][' . esc_attr($role) . '][role]" class="form-control role-select" >';
                            foreach ($roles as $role_key => $role_name) {
                                $selected = ($role_key === $role) ? 'selected' : '';
                                echo '<option value="' . esc_attr($role_key) . '" ' . $selected . '>' . esc_html($role_name) . '</option>';
                            }
                            echo '</select>';
                            echo '</div>';
                            echo '<div class="col-md-4">';
                            echo '<select name="bca_settings[roleMfaMethods][' . esc_attr($role) . '][mfaType]" class="form-control mfa-type-select">';

                            $mfaTypes = [
                                'totp' => 'TOTP via BAAR Auth App',
                                'pushNotification' => 'Push Notification via BAAR Auth App',
                                'otpEmail' => 'OTP via Email',
                                // 'otpPhone' => 'OTP via SMS',
                                'securityquestions' => 'Security Questions (KBA)'
                            ];

                            foreach ($mfaTypes as $mfaKey => $mfaLabel) {
                                $selected = ($mfaKey === $mfaType) ? 'selected' : '';
                                echo '<option value="' . esc_attr($mfaKey) . '" ' . $selected . '>' . esc_html($mfaLabel) . '</option>';
                            }
                            echo '</select>';
                            echo '</div>';
                            echo '<div class="col-md-1">';
                            echo '<button type="button" class="btn btn-danger remove-field-btn">-</button>';
                            echo '</div>';
                            echo '</div>';
                        }
                    }
                    ?>
                </div>
                <button type="button" id="addRoleMfaField" class="btn btn-primary add-field-btn">+</button>
                <p style="font-size: 14px; color: #555; margin-top: 10px;">
                    Note: If MFA is enforced for all users, and only specific roles are selected for role-based MFA, 
                    then all other roles will default to TOTP-based MFA using the BAAR Authenticator.
                </p>

            </div>
        </div>
    </div>


    <!-- Enable Recovery Codes Section -->
    <div class="form-section">
        <div class="form-section-title">Enable Recovery Codes?<span class="info-icon" data-toggle="tooltip" title="Enabling this option would allow the user to download 5 Distinct Recovery codes which they can use as a backup method to login in Wordpress when there is an issue with the configured method. Each code can be used only once.">ℹ️</span></div>
        <div class="form-section-content">
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[recoveryCodes]" id="enableRecoveryCodes" value="enableRecoveryCodes" 
                    <?php checked( isset($settings['recoveryCodes']) && $settings['recoveryCodes'] === 'enableRecoveryCodes', true); ?>>
                <label class="form-check-label" for="enableRecoveryCodes">
                    Yes
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[recoveryCodes]" id="disableRecoveryCodes" value="disableRecoveryCodes" 
                    <?php checked( isset($settings['recoveryCodes']) && $settings['recoveryCodes'] === 'disableRecoveryCodes', true); ?>>
                <label class="form-check-label" for="disableRecoveryCodes">
                    No
                </label>
            </div>
            <div class="ms-4" id="recoveryOptions" style="display: none;">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="bca_settings[recoveryOptions][]" value="useOnce" 
                        <?php checked( in_array('useOnce', isset($settings['recoveryOptions']) ? $settings['recoveryOptions'] : []), true); ?>>
                    <label class="form-check-label" for="useOnce">Use only once</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="bca_settings[recoveryOptions][]" value="regenerateCodes" 
                        <?php checked( in_array('regenerateCodes', isset($settings['recoveryOptions']) ? $settings['recoveryOptions'] : []), true); ?>>
                    <label class="form-check-label" for="regenerateCodes">Regenerate Codes</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="bca_settings[recoveryOptions][]" value="availableForUsers" 
                        <?php checked( in_array('availableForUsers', isset($settings['recoveryOptions']) ? $settings['recoveryOptions'] : []), true); ?>>
                    <label class="form-check-label" for="availableForUsers">Available for users</label>
                </div>
            </div>
        </div>
    </div>

    <!-- Grace Period for 2FA Section -->
    <div class="form-section">
        <div class="form-section-title">What Happens If Users Don’t Set Up MFA Within the Grace Period?</div>
        <div class="form-section-content">
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[gracePeriodAction]" id="noAccess" value="noAccess" 
                    <?php checked( isset($settings['gracePeriodAction']) && $settings['gracePeriodAction'] === 'noAccess', true); ?>>
                <label class="form-check-label" for="noAccess">
                    Restrict access to the dashboard/user page until MFA is configured.
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[gracePeriodAction]" id="blockUser" value="blockUser" 
                    <?php checked( isset($settings['gracePeriodAction']) && $settings['gracePeriodAction'] === 'blockUser', true); ?>>
                <label class="form-check-label" for="blockUser">
                    Block the user entirely (administrators must manually unblock them).
                </label>
            </div>
        </div>
    </div>


    <!-- User Notification on 2FA Enforcement Section -->
    <div class="form-section">
        <div class="form-section-title">How Should Users Be Notified About MFA Setup?</div>
        <div class="form-section-content">
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[notificationMethod]" id="userPageNotification" value="userPageNotification" 
                    <?php checked( isset($settings['notificationMethod']) && $settings['notificationMethod'] === 'userPageNotification', true); ?>>
                <label class="form-check-label" for="userPageNotification">
                    Show a full-page notification after login, before accessing the dashboard.
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[notificationMethod]" id="adminNotice" value="adminNotice" 
                    <?php checked( isset($settings['notificationMethod']) && $settings['notificationMethod'] === 'adminNotice', true); ?>>
                <label class="form-check-label" for="adminNotice">
                    Show an admin notice in the dashboard.
                </label>
            </div>
        </div>
    </div>

    <!-- Redirect After 2FA Setup Section -->
    <div class="form-section <?php echo !$is_premium && !$is_standard ? 'blur-content' : ''; ?>">
        <div class="form-section-title">Redirect Users After MFA Setup? <span class="info-icon" data-toggle="tooltip" title="Choose whether users should be redirected to a specific page after login using MFA.">ℹ️</span></div>
        <div class="form-section-content">
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[redirectUser]" id="redirectYes" value="redirectYes" <?php checked( isset($settings['redirectUser']) && $settings['redirectUser'] === 'redirectYes', true); ?>>
                <label class="form-check-label" for="redirectYes">Yes</label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="bca_settings[redirectUser]" id="redirectNo" value="redirectNo" <?php checked( isset($settings['redirectUser']) && $settings['redirectUser'] === 'redirectNo', true); ?>>
                <label class="form-check-label" for="redirectNo">No</label>
            </div>

            <!-- Section for Role-Based Redirect Links -->
            <div id="roleRedirectLinks" class="role-redirect-links" style="display: none;">
                <div class="form-section-title">Role-based Redirect Links</div>
                <div class="role-fields-container" id="roleRedirectFieldsContainer">
                    <?php 
                    // Get the list of WordPress roles
                    global $wp_roles;
                    $roles = $wp_roles->get_names();
                    
                    // Check if there are any role redirect settings to display
                    if (!empty($settings['roleRedirects'])) {
                        foreach ($settings['roleRedirects'] as $role => $link) {
                            echo '<div class="form-row align-items-center role-field" data-id="' . esc_attr($role) . '">';
                            echo '<div class="col-md-2">';
                            echo '<select name="bca_settings[roleRedirects][' . esc_attr($role) . '][role]" class="form-control role-select">';
                            foreach ($roles as $role_key => $role_name) {
                                $selected = ($role_key === $role) ? 'selected' : '';
                                echo '<option value="' . esc_attr($role_key) . '" ' . $selected . '>' . esc_html($role_name) . '</option>';
                            }
                            echo '</select>';
                            echo '</div>';
                            echo '<div class="col-md-4">';
                            echo '<input type="text" class="form-control link-input" name="bca_settings[roleRedirects][' . esc_attr($role) . '][link]" value="' . esc_attr($link) . '" placeholder="Enter URL for ' . esc_html($roles[$role]) . '">';
                            echo '</div>';
                            echo '<div class="col-md-1">';
                            echo '<button type="button" class="btn btn-danger remove-field-btn">-</button>';
                            echo '</div>';
                            echo '</div>';
                        }
                    }
                    ?>
                </div>
                <button type="button" id="addRoleField" class="btn btn-primary add-field-btn">+</button>
            </div>
        </div>
    </div>



<!--  Preferred MFA -->
<div class="form-section <?php echo !$is_premium ? 'blur-content' : ''; ?>">
    <div class="form-section-title">
        Can Users Choose Their Preferred MFA Method? 
        <span class="info-icon" data-toggle="tooltip" title="This allows the users to choose their preferred MFA method for their account. They can select Push, TOTP, OTP via email or OTP to mobile number.">ℹ️</span>
    </div>
    <div class="form-section-content">
        <div class="form-check">
            <input class="form-check-input" type="radio" name="bca_settings[allowPreferredMFA]" id="allowPreferredYes" value="allowPreferredYes" 
                <?php checked( isset($settings['allowPreferredMFA']) && $settings['allowPreferredMFA'] === 'allowPreferredYes', true); ?>>
            <label class="form-check-label" for="allowPreferredYes">Yes</label>
        </div>
        <div class="form-check">
            <input class="form-check-input" type="radio" name="bca_settings[allowPreferredMFA]" id="allowPreferredNo" value="allowPreferredNo" 
                <?php checked( isset($settings['allowPreferredMFA']) && $settings['allowPreferredMFA'] === 'allowPreferredNo', true); ?>>
            <label class="form-check-label" for="allowPreferredNo">No</label>
        </div>
    </div>
</div>

<!--  Disable MFA -->
<div class="form-section <?php echo !$is_premium ? 'blur-content' : ''; ?>">
    <div class="form-section-title">
        Can Users Disable MFA from Their Profile?
        <span class="info-icon" data-toggle="tooltip" title="This option will allow the users to enable or disable MFA authentication for their account">ℹ️</span>
    </div>
    <div class="form-section-content">
        <div class="form-check">
            <input class="form-check-input" type="radio" name="bca_settings[allowDisableMFA]" id="allowDisableYes" value="allowDisableYes" 
                <?php checked( isset($settings['allowDisableMFA']) && $settings['allowDisableMFA'] === 'allowDisableYes', true); ?>>
            <label class="form-check-label" for="allowDisableYes">Yes</label>
        </div>
        <div class="form-check">
            <input class="form-check-input" type="radio" name="bca_settings[allowDisableMFA]" id="allowDisableNo" value="allowDisableNo" 
                <?php checked( isset($settings['allowDisableMFA']) && $settings['allowDisableMFA'] === 'allowDisableNo', true); ?>>
            <label class="form-check-label" for="allowDisableNo">No</label>
        </div>
    </div>
</div>

<?php if (!$is_premium): ?>
    <div class="premium-overlay-alert mt-2">
        Please upgrade your plan to <strong>Premium</strong> to access all the settings.
    </div>
<?php endif; ?>


    <?php 
    // $user_ip = file_get_contents('https://api.ipify.org');
    // $allowed_ips = isset($settings['allowedIps']) ? $settings['allowedIps'] : '';

    // $allowed_ips_array = array_map('trim', explode(',', $allowed_ips));

    // $ipallow = in_array($user_ip, $allowed_ips_array);

    // if ($ipallow) {
    //     $message = "Your IP is matched!";
    // } else {
    //     $message = "Your IP is not matched!";
    // }
    ?>
    <!-- IP allow  -->
    <!-- <div class="form-section">
        <div class="form-section-title">Allow IP's
            <span class="info-icon" data-toggle="tooltip" title="Allow the users to add their IP address for their account">ℹ️</span>
        </div>
        <div class="form-section-content">
            <textarea class="form-control w-50 h-50" id="allowedIps" name="bca_settings[allowedIps]" rows="4" placeholder="Enter comma-separated IPs"><?php //echo isset($settings['allowedIps']) ? esc_textarea($settings['allowedIps']) : ''; ?></textarea>
        </div>
        <div class="result-message">
            <?php //echo $message; ?>
        </div>
    </div> -->


    <!-- Submit Button -->
    <div class="form-section">
        <div class="form-section-content">
          <button type="submit" class="btn btn-primary mt-3">Save Settings</button>

        </div>
    </div>
</form>


<script>
   document.addEventListener('DOMContentLoaded', function () {
    // Function to toggle visibility of dropdown options
    function toggleDropdown(dropdownId) {
        const dropdown = document.getElementById(dropdownId);
        if (dropdown) {
            dropdown.style.display = dropdown.style.display === 'block' ? 'none' : 'block';
        }
    }

    // Event listeners for the buttons (selectedRoles and promptusersetuproles)
    const selectedRolesBtn = document.getElementById('multiselect-btn-selectedRoles');
    const promptusersetuprolesBtn = document.getElementById('multiselect-btn-promptusersetuproles');

    if (selectedRolesBtn) {
        selectedRolesBtn.addEventListener('click', function (event) {
            event.stopPropagation(); // Prevent click from closing the dropdown immediately
            toggleDropdown('multiselect-options-selectedRoles');
        });
    }

    if (promptusersetuprolesBtn) {
        promptusersetuprolesBtn.addEventListener('click', function (event) {
            event.stopPropagation(); // Prevent click from closing the dropdown immediately
            toggleDropdown('multiselect-options-promptusersetuproles');
        });
    }

    // Close dropdowns when clicking outside of them
    window.addEventListener('click', function (event) {
        const selectedRolesDropdown = document.getElementById('multiselect-options-selectedRoles');
        const promptusersetuprolesDropdown = document.getElementById('multiselect-options-promptusersetuproles');
        
        if (selectedRolesDropdown && !selectedRolesDropdown.contains(event.target) && !selectedRolesBtn.contains(event.target)) {
            selectedRolesDropdown.style.display = 'none';
        }

        if (promptusersetuprolesDropdown && !promptusersetuprolesDropdown.contains(event.target) && !promptusersetuprolesBtn.contains(event.target)) {
            promptusersetuprolesDropdown.style.display = 'none';
        }
    });

    // Update button text based on selected options for selectedRoles
    function updateButtonCountForSelectedRoles() {
        const selectedCheckboxes = document.querySelectorAll('#multiselect-options-selectedRoles input[type="checkbox"]:checked');
        const count = selectedCheckboxes.length;
        const button = document.getElementById('multiselect-btn-selectedRoles');
        button.textContent = `Select Roles (${count})`;
    }

    // Update button text based on selected options for promptusersetuproles
    function updateButtonCountForPromptUserSetupRoles() {
        const selectedCheckboxes = document.querySelectorAll('#multiselect-options-promptusersetuproles input[type="checkbox"]:checked');
        const count = selectedCheckboxes.length;
        const button = document.getElementById('multiselect-btn-promptusersetuproles');
        button.textContent = `Select Roles (${count})`;
    }

    // Event listeners for checkbox changes for selectedRoles and promptusersetuproles
    const selectedRolesCheckboxes = document.querySelectorAll('#multiselect-options-selectedRoles input[type="checkbox"]');
    const promptusersetuprolesCheckboxes = document.querySelectorAll('#multiselect-options-promptusersetuproles input[type="checkbox"]');

    selectedRolesCheckboxes.forEach(function (checkbox) {
        checkbox.addEventListener('change', updateButtonCountForSelectedRoles);
    });

    promptusersetuprolesCheckboxes.forEach(function (checkbox) {
        checkbox.addEventListener('change', updateButtonCountForPromptUserSetupRoles);
    });

    // Initialize the button counts when the page loads
    updateButtonCountForSelectedRoles();
    updateButtonCountForPromptUserSetupRoles();
});


</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
    // Function to toggle visibility of dropdown options
    function toggleDropdown(dropdownId) {
        const dropdown = document.getElementById(dropdownId);
        if (dropdown) {
            dropdown.style.display = dropdown.style.display === 'block' ? 'none' : 'block';
        }
    }

    // Event listener for the button (user selection)
    const userBtn = document.getElementById('multiselect-btn-users');
    const userOptions = document.getElementById('multiselect-options-users');

    if (userBtn) {
        userBtn.addEventListener('click', function (event) {
            event.stopPropagation(); // Prevent click from closing the dropdown immediately
            toggleDropdown('multiselect-options-users');
        });
    }

    // Close dropdown when clicking outside of it
    window.addEventListener('click', function (event) {
        if (userOptions && !userOptions.contains(event.target) && !userBtn.contains(event.target)) {
            userOptions.style.display = 'none';
        }
    });

    // Update button text based on selected users
    document.querySelectorAll('#multiselect-options-users input[type="checkbox"]').forEach(function (checkbox) {
        checkbox.addEventListener('change', function () {
            const selectedCheckboxes = document.querySelectorAll('#multiselect-options-users input[type="checkbox"]:checked');
            const count = selectedCheckboxes.length;
            userBtn.textContent = `Select Users (${count})`;
        });
    });
});

</script>

<script>
jQuery(document).ready(function ($) {
    // Initial setup for role redirect links visibility
    var selectedValue = $('input[name="bca_settings[redirectUser]"]:checked').val();
    if (selectedValue == 'redirectYes') {
        $('input[name="bca_settings[redirectAfterMFA]"]').removeAttr('disabled');
        $('#roleRedirectLinks').show();
    } else {
        $('input[name="bca_settings[redirectAfterMFA]"]').attr('disabled', 'disabled');
        $('#roleRedirectLinks').hide();
    }

    $('input[name="bca_settings[redirectUser]"]').click(function () {
        var value = $(this).attr("value");
        if (value == 'redirectYes') {
            $('input[name="bca_settings[redirectAfterMFA]"]').removeAttr('disabled');
            $('#roleRedirectLinks').show();
        } else {
            $('input[name="bca_settings[redirectAfterMFA]"]').attr('disabled', 'disabled');
            $('#roleRedirectLinks').hide();
        }
    });

    // Variable to keep track of added role fields
    var roleFieldCounter = <?php echo isset($settings['roleRedirects']) ? count($settings['roleRedirects']) : 0; ?>;

    // Add new role field
    $('#addRoleField').click(function () {
        var roleOptions = '';
        <?php foreach ($roles as $role_key => $role_name) : ?>
            roleOptions += '<option value="<?php echo esc_attr($role_key); ?>"><?php echo esc_html($role_name); ?></option>';
        <?php endforeach; ?>

        var newField = '<div class="form-row align-items-center role-field" data-id="' + roleFieldCounter + '">' +
            '<div class="col-md-2">' +
            '<select name="bca_settings[roleRedirects][' + roleFieldCounter + '][role]" class="form-control role-select">' + roleOptions + '</select>' +
            '</div>' +
            '<div class="col-md-4">' +
            '<input type="text" class="form-control link-input" name="bca_settings[roleRedirects][' + roleFieldCounter + '][link]" placeholder="Enter URL for role">' +
            '</div>' +
            '<div class="col-md-1">' +
            '<button type="button" class="btn btn-danger remove-field-btn">-</button>' +
            '</div>' +
            '</div>';

            $('#roleRedirectFieldsContainer').append(newField);
        roleFieldCounter++;
    });

    // Remove role field handler
    $(document).on('click', '.remove-field-btn', function () {
        // Get the closest parent form-row and remove it
        $(this).closest('.role-field').remove();
    });
});
</script>

<script>
    jQuery(document).ready(function ($) {
        // Initial setup for MFA method visibility
        var selectedMfaMethod = $('input[name="bca_settings[mfaMethod]"]:checked').val();
        // Check if roleMFA is selected and show/hide roleMfaMethods accordingly
        if (selectedMfaMethod == 'role') {
            $('#roleMfaMethods').show();  
        } else {
            $('#roleMfaMethods').hide();  
        }

        // Toggle between "Default MFA method for all users" and "Role-based MFA methods"
        $('input[name="bca_settings[mfaMethod]"]').click(function () {
            var value = $(this).val(); 
            if (value == 'default') {
                $('#defaultMfaOptions').show();
                $('#roleMfaMethods').hide();  
            } else if (value == 'role') {
                $('#defaultMfaOptions').hide(); 
                $('#roleMfaMethods').show();   
            }
        });

        // Variable to keep track of added role fields
        var mfaFieldCounter = <?php echo isset($settings['roleMfaMethods']) ? count($settings['roleMfaMethods']) : 0; ?>;

        
        // Add new role MFA method field
        $('#addRoleMfaField').click(function () {
            var roleOptions = '';
            <?php foreach ($roles as $role_key => $role_name) : ?>
                roleOptions += '<option value="<?php echo esc_attr($role_key); ?>"><?php echo esc_html($role_name); ?></option>';
            <?php endforeach; ?>

            var mfaOptions = '';
            var mfaTypes = {
                'totp': 'TOTP via BAAR Auth App',
                'pushNotification': 'Push Notification via BAAR Auth App',
                'otpEmail': 'OTP via Email',
                // 'otpPhone': 'OTP via SMS',
                'securityquestions': 'Security Questions (KBA)'
            };
            for (var mfaKey in mfaTypes) {
                mfaOptions += '<option value="' + mfaKey + '">' + mfaTypes[mfaKey] + '</option>';
            }

            var newField = '<div class="form-row align-items-center role-field" data-id="' + mfaFieldCounter + '">' +
                '<div class="col-md-2">' +
                '<select name="bca_settings[roleMfaMethods][' + mfaFieldCounter + '][role]" class="form-control role-select">' + roleOptions + '</select>' +
                '</div>' +
                '<div class="col-md-4">' +
                '<select name="bca_settings[roleMfaMethods][' + mfaFieldCounter + '][mfaType]" class="form-control mfa-type-select">' + mfaOptions + '</select>' +
                '</div>' +
                '<div class="col-md-1">' +
                '<button type="button" class="btn btn-danger remove-field-btn">-</button>' +
                '</div>' +
                '</div>';

            $('#roleMfaFieldsContainer').append(newField);
            mfaFieldCounter++;
        });

        // Remove role MFA method field
        $(document).on('click', '.remove-field-btn', function () {
            $(this).closest('.role-field').remove();
        });

         // Ensure unselected roles default to 'totp'
        $(document).on('change', '.role-select', function () {
            var selectedRole = $(this).val();
            var mfaTypeSelect = $(this).closest('.role-field').find('.mfa-type-select');
            
            // Check if no MFA type is selected, and set it to TOTP if it's not
            if (mfaTypeSelect.val() === '') {
                mfaTypeSelect.val('totp');  // Set to TOTP by default
            }
        });
    });
</script>

<script>
// JavaScript for filtering roles
document.getElementById('searchRoles').addEventListener('input', function () {
    var filter = this.value.toLowerCase();
    var options = document.querySelectorAll('.multiselect-option');
    options.forEach(function (option) {
        var roleName = option.getAttribute('data-role-name');
        if (roleName.indexOf(filter) > -1) {
            option.style.display = '';
        } else {
            option.style.display = 'none';
        }
    });
});

// JavaScript for filtering users
document.getElementById('searchUsers').addEventListener('input', function () {
    var filter = this.value.toLowerCase();
    var options = document.querySelectorAll('.multiselect-option-users');
    options.forEach(function (option) {
        var userName = option.getAttribute('data-user-name');
        if (userName.indexOf(filter) > -1) {
            option.style.display = '';
        } else {
            option.style.display = 'none';
        }
    });
});
</script>