<style>
    .pricing-table {
        border: 1px solid #dee2e6;
    }
    .pricing-header {
        background-color: #f8f9fa;
        padding: 1rem;
    }
    .feature-check {
        color: #198754;
    }
    .upgrade-btn a {
        color: #f1f1f1;
        font-weight: bold;
        text-decoration: none;
    }
    .upgrade-btn a:hover {
        color: #c46c24 !important;
        font-weight: bold;
    }
    .card-footer {
        background: no-repeat;
    }
    .try-free-btn, .upgrade-btn {
        background-color: #c46c24;
        border-color: #c46c24;
        color: #f1f1f1;
        font-weight: bold;
        padding: 10px 30px;
    }

    .try-free-btn:hover, .upgrade-btn:hover {
        background-color: #f1f1f1;
        border-color:rgb(71, 71, 71);
        color: #c46c24 !important;
        font-weight: bold;
        padding: 10px 30px;
    }

    .comparison-table td, 
    .comparison-table th {
        text-align: center;
        vertical-align: middle;
    }

    .comparison-table tr th {
        background-color: #034a81 !important;
        color: #f1f1f1 !important;
    }

    tr.upgrade-table-list td.applicable {
        color: #1b8d03;
        font-weight: 600;
    }

    tr.upgrade-table-list td.not-applicable {
        color: #e61c1c;
        font-weight: 600;
    }

    div.upgrade-plan-list ul {
        li {
            position: relative;
            /* font-size: 22px; */
            color: black;
            padding: 0px 0 0px 20px;

            &:before {
                content: '';
                display: block;
                position: absolute;
                top: 5px;
                left: 0;
                width: 7px;
                height: 14px;
                border: solid #198754;
                border-width: 0 3px 3px 0;
                transform: rotate(45deg);
            }
        }
    }

    /* Optional: Style the icons */
    .icon-available {
        font-size: 20px;
        color: green;
    }

    .icon-not-available {
        font-size: 20px;
        color: red;
    }

</style>


<div class="container py-5">
    <div class="text-center mb-5">
        <h1 class="display-5 fw-bold mb-3">BAAR MFA for WordPress</h1>
        <p class="lead">Explore the plans and pricing</p>
    </div>

    <div class="row row-cols-1 row-cols-md-3 row-cols-lg-3 g-4 mb-5" id="pricing-container">
        <!-- Pricing plans will be dynamically inserted here -->
    </div>

    <script>
    // Fetch the data from the API
    fetch('https://store.baar.ai/api/get-plans/1', {
        method: 'GET',
        headers: {
            'X-API-KEY': 'barrmfa-1US2NYn1PkQTRmuswd6jZIFovT4',
            'Cookie': 'XSRF-TOKEN=your-csrf-token; laravel_session=your-session-token'
        }
    })
        .then(response => response.json())
        .then(data => {
            const plans = data.plans;
            const container = document.getElementById('pricing-container');
            
            plans.forEach(plan => {
                const basePrice = parseFloat(plan.base_price);  // Base price for 1 site
                const extraSiteCost = parseFloat(plan.extra_site_cost);  // Extra cost per site (not needed for calculation)
                
                // Build the HTML for each plan
                const planCard = document.createElement('div');
                planCard.classList.add('col');
                
                planCard.innerHTML = `
                    <div class="card h-100 pricing-table">
                        <div class="pricing-header">
                            <h5 class="text-center mb-0">${plan.name}</h5>
                            <p class="text-center mb-0"><span class="price">$${basePrice}</span>/year</p>
                            <small class="text-center d-block">No of Sites: 
                                <select name="no_of_sites" id="no_of_sites_${plan.id}" data-base-price="${basePrice}">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5</option>
                                </select>
                            </small>
                        </div>
                        <div class="card-body upgrade-plan-list">
                            <ul class="list-unstyled">
                                ${plan.features.filter(feature => feature.is_key_feature === 1).map(feature => `
                                    <li class="mb-2">${feature.name}</li>
                                `).join('')}
                            </ul>
                        </div>
                        <div class="card-footer text-center">
                            <button class="btn upgrade-btn"><a href="https://store.baar.ai/pricing-mfa" target="_blank">UPGRADE</a></button>
                        </div>
                    </div>
                `;
                
                // Append the plan card to the container
                container.appendChild(planCard);
            });

            // Add event listeners to all site select dropdowns to update price
            document.querySelectorAll('select[name="no_of_sites"]').forEach(selectElement => {
                selectElement.addEventListener('change', function () {
                    const basePrice = parseFloat(this.dataset.basePrice);  // Get the base price for 1 site
                    const extraSiteCost = parseFloat(plan.extra_site_cost); // Get the extra cost for additional sites
                    const noOfSites = parseInt(this.value);  // Get the selected number of sites
                    
                    // Correct price calculation: basePrice + (extraSiteCost * (noOfSites - 1))
                    const totalPrice = basePrice + (extraSiteCost * (noOfSites - 1));
                    this.closest('.pricing-table').querySelector('.price').textContent = `$${totalPrice.toFixed(2)}`;
                });
            });
        })
        .catch(error => console.error('Error fetching pricing plans:', error));
    </script>

    <div class="text-center mb-5">
        <h4>Looking to get the MFA for more than five sites?</h4>
        <p>Please contact our sales team at <a href="mailto:support@store.baar.ai">support@store.baar.ai</a></p>
        <p>Please see the detailed comparison between the plans and their respective features.</p>
        <p>Upgrade Now to get the most out of it</p>
        <button class="btn try-free-btn">TRY FOR FREE</button>
    </div>

    <!-- Comparison Table -->
    <div class="table-responsive">
        <table class="table table-bordered comparison-table">
            <thead>
                <tr class="upgrade-table-list">
                    <th>Features</th>
                    <!-- Dynamic Plan Names -->
                    <th id="plan-free-header"></th>
                    <th id="plan-standard-header"></th>
                    <th id="plan-pro-header"></th>
                    <!-- <th id="plan-premium-header"></th> -->
                </tr>
            </thead>
            <tbody id="comparison-body">
                <!-- Comparison rows will be dynamically inserted here -->
            </tbody>
        </table>
    </div>

    <script>
        // Fetch the data from the API
        fetch('https://store.baar.ai/api/get-plans/1', {
            method: 'GET',
            headers: {
                'X-API-KEY': 'barrmfa-1US2NYn1PkQTRmuswd6jZIFovT4',
                'Cookie': 'XSRF-TOKEN=your-csrf-token; laravel_session=your-session-token'
            }
        })
        .then(response => response.json())
        .then(data => {
            const plans = data.plans;

            // Assuming you are always dealing with three plans:
            const planNames = plans.slice(0, 3).map(plan => plan.name);

            // Set dynamic headers for plan names
            document.getElementById('plan-free-header').textContent = planNames[0] || 'Free';
            document.getElementById('plan-standard-header').textContent = planNames[1] || 'Standard';
            document.getElementById('plan-pro-header').textContent = planNames[2] || 'Pro';

            // Extract features dynamically from the API response
            const planFeatures = [];

            // Dynamic feature rows generation (with plans array length control)
            plans.forEach(plan => {
                plan.features.forEach(feature => {
                    const existingFeature = planFeatures.find(f => f.feature === feature.name);
                    
                    if (!existingFeature) {
                        planFeatures.push({
                            feature: feature.name,
                            free: feature.is_included && plan.name === planNames[0] ? 1 : 0,
                            standard: feature.is_included && plan.name === planNames[1] ? 1 : 0,
                            pro: feature.is_included && plan.name === planNames[2] ? 1 : 0,
                        });
                    } else {
                        existingFeature[plan.name.toLowerCase()] = feature.is_included ? 1 : 0;
                    }
                });
            });
            // Generate the comparison table dynamically based on the planFeatures array
            const tbody = document.getElementById('comparison-body');

            // Generate the comparison table dynamically based on the planFeatures array
            planFeatures.forEach(item => {
                const tr = document.createElement('tr');
                tr.classList.add('upgrade-table-list');

                // Create the first column for the feature
                const featureCell = document.createElement('td');
                featureCell.textContent = item.feature;
                tr.appendChild(featureCell);

                // Create the remaining columns for each plan with color-coded icons (green tick or red cross)
                const plans = ['free', 'standard', 'premium'];
                plans.forEach(plan => {
                    const planCell = document.createElement('td');
                    const icon = document.createElement('span');
                    
                    if (item[plan] === 1) {
                        icon.classList.add('icon-available');  // green
                        icon.style.color = 'green';            // Green color for available (key feature)
                        icon.textContent = '✓';  // Check mark
                    } else if (item[plan] === 0) {
                        icon.classList.add('icon-not-available');  // red
                        icon.style.color = 'red';                   // Red color for not available
                        icon.textContent = '✗';  // Cross mark
                    }
                    
                    planCell.appendChild(icon);
                    tr.appendChild(planCell);
                });

                // Append the row to the table body
                tbody.appendChild(tr);
            });
        })
        .catch(error => console.error('Error fetching pricing plans:', error));
    </script>

    <!-- Instructions Section -->
    <div class="mt-5">
        <h3>Instructions on How to Upgrade?</h3>

        <ul class="list-group gap-2">
            <li class="list-group-item">Click the "Upgrade Now" button under your preferred plan above. You'll be redirected to the payment page.</li>
            <li class="list-group-item">Select the number of users/sites you wish to upgrade for, and add any additional features or add-ons you'd like to purchase. Click "Proceed to Payment."</li>
            <li class="list-group-item">You'll be redirected to the <a href="https://store.baar.ai/" target="_blank">BAAR Store.</a> Enter your username and password to access the Payment Details page.</li>
            <li class="list-group-item">Review your selections and click "Proceed to Payment" to complete the transaction.</li>
            <li class="list-group-item">After payment, navigate to the "Account Tab" On the plugin.</li>
            <li class="list-group-item">Enter your unique License Key and Activate the license.</li>
            <li class="list-group-item">Users will now be able to use the premium features of the plugin.</li>
            <li class="list-group-item">The subscription details will be available in the Account Tab after activation.</li>
        </ul>

        <!-- Multisite Support Section -->
        <div class="mt-4">
            <h4>Multisite Support</h4>
            <p>The first license automatically supports up to three subsites on the same domain. For additional subsites, please contact support.</p>
        </div>

        <!-- Refund Policy Section -->
        <div class="mt-4">
            <h4>Refund Policy</h4>
            <p>For more information, read our <a href="https://store.baar.ai/refund-policy" class="text-decoration-none">Refund Policy.</a></p>
        </div>

        <!-- License Agreement Section -->
        <div class="mt-4">
            <h4>End User License Agreement</h4>
            <p>Review our <a href="https://store.baar.ai/end-user-license-agreement" class="text-decoration-none">End User License Agreement (EULA)</a> for details.</p>
        </div>

        <!-- Need Help Section -->
        <div class="mt-4">
            <h4>Need Help?</h4>
            <p>
                If you have questions or need assistance with licensing plans, email us at 
                <a href="mailto:support@store.baar.ai" class="text-decoration-none">support@store.baar.ai</a> 
                or submit a query via the support Tab.
            </p>
        </div>
    </div>
</div>
