<div class="container my-5 faqsupport">
    <!-- FAQ Section -->
    <h2 class="mb-4">Frequently Asked Questions</h2>
    
    <div class="accordion mb-5" id="faqAccordion">
        <!-- Question 1 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1">
                    How is BAAR MFA different from other MFA plugins?
                </button>
            </h2>
            <div id="collapse1" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    Unlike other MFA plugins, BAAR MFA comes with an inbuilt BAAR IGA Authenticator—no need to use external apps like Google Authenticator or Authy. It also supports push notifications, OTP via SMS/Email, and backup codes.
                </div>
            </div>
        </div>

        <!-- Question 2 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2">
                    Who should use BAAR MFA?
                </button>
            </h2>
            <div id="collapse2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    BAAR MFA is perfect for businesses, website administrators, and developers who want to protect their WordPress sites from brute force attacks, credential theft, and unauthorized access.
                </div>
            </div>
        </div>

        <!-- Question 3 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3">
                    Is BAAR MFA free to use?
                </button>
            </h2>
            <div id="collapse3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    BAAR MFA offers both free and premium plans. The free version provides basic MFA security, while the premium version unlocks advanced features like role-based MFA, reporting, and enterprise-level integration.
                </div>
            </div>
        </div>

        <!-- Question 4 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4">
                    How do I install BAAR MFA on my WordPress site?
                </button>
            </h2>
            <div id="collapse4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    Go to Plugins → Add New in your WordPress dashboard.<br>
                    Search for BAAR MFA and click Install Now.<br>
                    Activate the plugin and follow the setup wizard to configure authentication methods.
                </div>
            </div>
        </div>

        <!-- Question 5 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse5">
                    What authentication methods does BAAR MFA support?
                </button>
            </h2>
            <div id="collapse5" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    BAAR MFA provides multiple authentication options:<br>
                    ✔ Push Notification (via BAAR IGA Authenticator)<br>
                    ✔ OTP via SMS or Email<br>
                    ✔ Backup Codes<br>
                    ✔ Passwordless Login (coming soon)
                </div>
            </div>
        </div>

        <!-- Question 6 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse6">
                    What happens if a user loses access to their MFA device?
                </button>
            </h2>
            <div id="collapse6" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    If a user loses access to their registered device, they can:<br>
                    ✔ Use backup codes generated during the setup.<br>
                    ✔ Request an admin to disable MFA temporarily.<br>
                    ✔ Verify their identity via email-based recovery (if enabled).
                </div>
            </div>
        </div>

        <!-- Question 7 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse7">
                    Can I enforce MFA only for specific users or roles?
                </button>
            </h2>
            <div id="collapse7" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    Yes! BAAR MFA allows role-based MFA enforcement, so you can enable MFA for admins, editors, or high-privilege users while keeping it optional for others.
                </div>
            </div>
        </div>

        <!-- Question 8 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse8">
                    How do I set up MFA for users?
                </button>
            </h2>
            <div id="collapse8" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    After activating the plugin, go to BAAR MFA → Settings and select the authentication methods you want to enable (Push Notification, OTP, Backup Codes). Users can then register their authentication methods via their profile settings.
                </div>
            </div>
        </div>

        <!-- Question 9 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse9">
                    Can I disable MFA for certain users or groups?
                </button>
            </h2>
            <div id="collapse9" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    Yes, many MFA plugins allow administrators to configure MFA settings on a per-user or per-group basis. You can disable MFA for specific users if necessary or apply different authentication methods depending on user roles or organizational policies.
                </div>
            </div>
        </div>

        <!-- Question 10 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse10">
                    What should I do if I lose access to my MFA device (phone, token, etc.)?
                </button>
            </h2>
            <div id="collapse10" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    If you lose access to your MFA device, most plugins provide a recovery process. This may involve:<br>
                    ✔ Using backup codes generated during setup.<br>
                    ✔ Contacting your organization's admin to reset MFA settings.<br>
                    ✔ Verifying your identity through other means (e.g., email or security questions).<br>
                    Make sure to set up backup options during initial MFA setup to avoid issues in case of device loss.
                </div>
            </div>
        </div>

        <!-- Question 11 -->
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse11">
                    Why am I not receiving OTP emails?
                </button>
            </h2>
            <div id="collapse11" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                <div class="accordion-body">
                    The plugin uses your site’s SMTP settings to send OTP emails. If SMTP isn't configured, the emails won’t be delivered. Please set up a working SMTP plugin or server in WordPress for OTP via email to function.
                </div>
            </div>
        </div>
    </div>


    <!-- Contact Form -->
    <div class="row justify-content-center">
        <div class="col-md-8">
            <iframe src="https://stage-store.baarconnect.com/contact-form-external"
                width="100%" height="700" style="border: none;"></iframe>
        </div>
    </div>
</div>

