<?php
global $wpdb;
$user_id = get_current_user_id();

// Clear the transient cache first to force a refresh
$license_data = $wpdb->get_row("SELECT licence_key FROM {$wpdb->prefix}bca_licence_detail");
$license_key = $license_data->licence_key ?? '';

// Define a transient key based on the license key hash
$transient_key = 'bca_license_info_' . md5($license_key);

// Delete existing transient to force refresh
delete_transient($transient_key);

// Debug variables
$debug_api_response = [];
$debug_plan_value = '';

// Try to get fresh license info
$license_info = false;

if ($license_key) {
    // Validate license via API
    $response = wp_remote_post('https://store.baar.ai/api/validate-license-features', [
        'headers' => ['Content-Type' => 'application/json'],
        'body' => json_encode(['license_key' => $license_key]),
        'timeout' => 10
    ]);

    if (!is_wp_error($response)) {
        $body = json_decode(wp_remote_retrieve_body($response), true);
        $debug_api_response = $body; // Store full response for debugging
        
        if (!empty($body['status']) && $body['status'] == 1 && !empty($body['data'])) {
            $license_info = $body['data'];
            // Cache for 6 hours
            // set_transient($transient_key, $license_info, 6 * HOUR_IN_SECONDS);
        }
    }
}

// Debug the structure of the response
if ($license_info) {
    $debug_plan_value = isset($license_info['plan']) ? $license_info['plan'] : 'NOT SET';
}

// Determine plan - check both fields that might contain the plan information
$plan_name = '';
if (isset($license_info['plan'])) {
    $plan_name = strtolower(trim($license_info['plan']));
} 

// Check if we need to look for plan in a different structure
if (empty($plan_name) && isset($debug_api_response['data']['plan'])) {
    $plan_name = strtolower(trim($debug_api_response['data']['plan']));
}

// Default to free if no plan found
if (empty($plan_name)) {
    $plan_name = 'free';
}

$is_premium = ($plan_name === 'premium');

// Force premium for testing if needed
// $is_premium = true;
?>

<style>
.blur-content {
    filter: blur(1px);
    pointer-events: none;
    user-select: none;
    position: relative;
}

.premium-overlay-alert {
    margin-top: 20px;
    padding: 15px;
    border-radius: 5px;
    background-color: #fff3cd;
    color: #856404;
    border: 1px solid #ffeeba;
    display: flex;
    align-items: center;
    gap: 10px;
    font-weight: 600;
    font-size: 15px;
}

.premium-overlay-alert::before {
    content: "⚠️";
    font-size: 18px;
}

.debug-box {
    background-color: #f8f9fa;
    border: 1px solid #ddd;
    padding: 10px;
    margin-bottom: 15px;
    font-family: monospace;
    font-size: 12px;
    white-space: pre-wrap;
}
</style>

<div class="container my-3 mb-5 position-relative">
    <!-- Enhanced Debug Info (remove in production) -->
    <!-- <div class="debug-info debug-box" style="display: block;">
        <strong>License Key:</strong> <?php echo !empty($license_key) ? substr($license_key, 0, 5) . '...' : 'Not found'; ?><br>
        <strong>Raw API Response:</strong> <pre><?php print_r($debug_api_response); ?></pre><br>
        <strong>Plan Value:</strong> "<?php echo htmlspecialchars($debug_plan_value); ?>"<br>
        <strong>Plan Name (used):</strong> "<?php echo htmlspecialchars($plan_name); ?>"<br>
        <strong>Is Premium:</strong> <?php echo $is_premium ? 'Yes' : 'No'; ?><br>
    </div> -->

    <div class="<?php echo !$is_premium ? 'blur-content' : ''; ?>">
        <!-- Response Message -->
        <div id="brandMessage" class="mt-3"></div>

        <!-- Section Title with Crown Icon -->
        <div class="form-section-titl mb-3" style="font-weight: bold; display: flex; align-items: center; gap: 8px;">
            <span>White Labelling Brand</span>
            <!-- <span title="Premium Feature" style="color: goldenrod; font-size: 20px;">👑</span> -->
            <span class="info-icon" data-toggle="tooltip" title="Customize the MFA login experience with your own branding.">ℹ️</span>
        </div>

        <!-- Brand Form -->
        <form id="brandForm" enctype="multipart/form-data">
            <!-- Brand Name -->
            <div class="mb-3">
                <label for="brand_name" class="form-label">Brand Name:</label>
                <input type="text" class="form-control" id="brand_name" name="brand_name" required>
            </div>

            <!-- Brand Logo Upload -->
            <div class="mb-3">
                <label for="brand_logo" class="form-label">Brand Logo:</label>
                <input type="file" class="form-control" id="brand_logo" name="brand_logo" accept="image/*">
                <div class="mt-3">
                    <a id="brandImageLink" href="#" target="_blank" style="display: none;">
                        <img id="brandImagePreview" src="" alt="Brand Logo" style="max-width: 150px;">
                    </a>
                </div>
            </div>

            <!-- Hidden Brand ID -->
            <input type="hidden" id="brand_id" name="brand_id">

            <!-- Submit Button -->
            <button type="button" id="submitBrand" class="btn btn-primary">Save</button>
        </form>
    </div>

    <?php if (!$is_premium): ?>
        <!-- Message shown at bottom -->
        <div class="premium-overlay-alert">
            Please upgrade your plan to <strong>Premium</strong> to access branding settings.
        </div>
    <?php endif; ?>
</div>

<script>
// Add this JavaScript to force a page refresh if needed
document.addEventListener('DOMContentLoaded', function() {
    // If you need to force clear cache on client side
    // window.location.reload(true);
});
</script>