<?php
global $wpdb;

// Query to check if a license is activated for the current site
$license_data = $wpdb->get_row(
    $wpdb->prepare(
        "SELECT * FROM {$wpdb->prefix}bca_licence_detail WHERE site_url = %s AND licence_status = 'active'",
        get_site_url() // Use the current site URL
    )
);
?>
<style>
    /* .license-info {
    background-color: #f9f9f9;
    padding: 20px;
    border-radius: 5px;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
}

.license-info h3 {
    margin-bottom: 20px;
}

.license-info table {
    width: 100%;
    border-collapse: collapse;
}

.license-info table td {
    padding: 8px;
    border: 1px solid #ddd;
}

.license-info table td strong {
    width: 150px;
} */

.license-info table {
    width: 100%;
    border-collapse: collapse; /* Ensures no space between table cells */
}

/* Style for the table cells */
.license-info table td, .license-info table th {
    padding: 8px 12px; /* Adjust padding to reduce space */
    border: 1px solid #ddd; /* Adds a border for clarity */
}

/* Optional: Style for the table headers (if you want to add headers) */
.license-info table th {
    background-color: #f4f4f4; /* Light background for the header */
    font-weight: bold; /* Make the header text bold */
}


</style>


<div class="container my-5 account-tab">
    <form class="account-info" id="accountTabForm">
        <!-- License Key Input -->
        <div class="info-row">
            <div class="info-label">License Key</div>
            <input type="text" class="form-control" id="license_key" value="<?php echo esc_attr($license_data ? $license_data->licence_key : ''); ?>" required>
        </div>

        <!-- Activate Button -->
        <div class="form-actions mb-4">
            <button type="button" id="activate_license_btn" class="submit-btn">
                <?php echo ($license_data) ? 'Update License Key' : 'Activate License'; ?>
            </button>
        </div>

        <!-- Message display -->
        <div id="activation_message"></div>
    </form>

    <?php if ($license_data): ?>
        <!-- Display License Information Below the Form -->
        <div class="license-info mt-4">
            <h3>License Information</h3>
            <table class="table">
                <tr>
                    <td><strong>Customer Id</strong></td>
                    <td><?php echo esc_html($license_data->api_customer_id); ?></td>
                </tr>
                <tr>
                    <td><strong>Email</strong></td>
                    <td><?php echo esc_html($license_data->user_email); ?></td>
                </tr>
                <tr>
                    <td><strong>Site URL</strong></td>
                    <td><?php echo esc_html($license_data->site_url); ?></td>
                </tr>
                <tr>
                    <td><strong>Plan Type</strong></td>
                    <td><?php echo esc_html(ucfirst($license_data->plan_name)); ?></td>
                </tr>
                <tr>
                    <td><strong>Status</strong></td>
                    <td><?php echo esc_html(ucfirst($license_data->licence_status)); ?></td>
                </tr>
                <tr>
                    <td><strong>Date Activated</strong></td>
                    <td><?php echo esc_html(date('Y-m-d', strtotime($license_data->created_at))); ?></td>
                </tr>
                <tr>
                    <td><strong>Date of Expiry</strong></td>
                    <td><?php echo esc_html($license_data->licence_expiry_date); ?></td>
                </tr>
            </table>
        </div>
    <?php endif; ?>
</div>
