<?php
$current_user = wp_get_current_user();
$user_email = $current_user->user_email;

// Query the database to get the user's saved MFA method
global $wpdb;
$selected_option = ''; // Default to an empty value

// Check if there's a record for the current user
$entry = $wpdb->get_row(
    $wpdb->prepare("SELECT default_mfa_method FROM {$wpdb->prefix}bca_api_entries WHERE user_email = %s", $user_email)
);

if ($entry) {
    $selected_option = $entry->default_mfa_method; // Set the selected option to the saved method
}

$bca_settings = get_option('bca_settings');
$allowPreferredMFA = isset($bca_settings['allowPreferredMFA']) ? $bca_settings['allowPreferredMFA'] : '';
$allowDisableMFA = isset($bca_settings['allowDisableMFA']) ? $bca_settings['allowDisableMFA'] : '';

?>
    <!-- Success Message -->
    <div id="success-message" class="alert alert-success mt-3" style="display: none;">
        Settings saved successfully!
    </div>
    <?php 
    if ($allowPreferredMFA === 'allowPreferredYes') { ?>
    <div class="form-section mt-4">
        <div class="form-section-title">Select your default MFA Method <span class="info-icon" data-toggle="tooltip" title="Choosing an option will set default MFA method for your account.">ℹ️</span></div>
        <div class="form-section-content">
            <div class="form-check">
                <select id="mfa-options" class="form-control" data-bs-toggle="tooltip" title="Select an MFA option from the dropdown to set as your default MFA method.">
                    <option value="totp" <?php echo ($selected_option == 'totp') ? 'selected' : ''; ?>>TOTP via BAAR Auth App.</option>
                    <option value="pushNotification" <?php echo ($selected_option == 'pushNotification') ? 'selected' : ''; ?>>Push Notification via BAAR Auth App.</option>
                    <option value="otpEmail" <?php echo ($selected_option == 'otpEmail') ? 'selected' : ''; ?>>OTP via Email.</option>
                    <option value="otpPhone" <?php echo ($selected_option == 'otpPhone') ? 'selected' : ''; ?>>OTP via SMS.</option>
                    <option value="securityquestions" <?php echo ($selected_option == 'securityquestions') ? 'selected' : ''; ?>>Security Questions (KBA)</option>
                    <?php if ($allowDisableMFA === 'allowDisableYes') { ?>
                        <option value="allowDisableYes" <?php echo ($selected_option == 'allowDisableYes') ? 'selected' : ''; ?>>I opt out of MFA for myself.</option>
                    <?php } ?>
                </select>
            </div>
        </div>
    </div>
    <!-- Save Settings Button -->
    <button id="save-settings" class="btn btn-primary mt-3" onclick="saveSettings()">Save Settings</button>
    <?php } else { ?>
        <div class="form-section mt-4">
            <h5>Don't have full access</h5>
        </div>
    <?php } ?>

</div>

<script>
    var selectedOption = '<?php echo $selected_option; ?>'; // Initialize with the selected option

    // Initialize tooltips (requires Bootstrap JS)
    document.addEventListener('DOMContentLoaded', function () {
        var tooltipTriggerList = Array.from(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.forEach(function (tooltipTriggerEl) {
            new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });

    // Function to save settings
    function saveSettings() {
        selectedOption = jQuery('#mfa-options').val(); // Get the selected option from the dropdown

        if (!selectedOption) {
            alert('Please select an MFA option');
            return;
        }

        // Send an AJAX request to save the selected option
        var data = {
            action: 'save_user_setting_mfa_option',
            selected_option: selectedOption
        };

        jQuery.post(ajaxurl, data, function(response) {
            if (response.success) {
                // Display success message
                jQuery('#success-message').show();
                setTimeout(function() {
                    jQuery('#success-message').fadeOut();
                }, 3000); // Hide success message after 3 seconds
            } else {
                alert('Failed to save settings');
            }
        });
    }
</script>

