<?php wp_nonce_field('bca_save_mfa', 'bca_mfa_nonce'); 

global $wpdb;
$current_user = wp_get_current_user();
$user_email = $current_user->user_email;

$mfaStatus = $wpdb->get_var(
    $wpdb->prepare(
        "SELECT qr_status FROM {$wpdb->prefix}bca_api_entries WHERE user_email = %s", 
        $user_email
    )
);

$mfa_config_status = $wpdb->get_row(
    $wpdb->prepare(
        "SELECT totp_config, otpEmail_config, pushnotification_config, securityQuestion_config 
        FROM {$wpdb->prefix}bca_api_entries 
        WHERE user_email = %s", 
        $user_email
    ), 
    ARRAY_A // Fetch as an associative array
);

$query = $wpdb->prepare(
    "SELECT code_1, code_2, code_3, code_4, code_5 FROM {$wpdb->prefix}bca_recovery_code WHERE user_email = %s LIMIT 1", 
    $user_email
);
$recovery_codes = $wpdb->get_row($query);

$hide_button = false;

if ($recovery_codes && (
    !empty($recovery_codes->code_1) || 
    !empty($recovery_codes->code_2) || 
    !empty($recovery_codes->code_3) || 
    !empty($recovery_codes->code_4) || 
    !empty($recovery_codes->code_5)
)) {
    $hide_button = true; 
}

$bca_settings = get_option('bca_settings');
$recoveryCodes = isset($bca_settings['recoveryCodes']) ? $bca_settings['recoveryCodes'] : '';
$userSelection = isset($bca_settings['userSelection']) ? $bca_settings['userSelection'] : '';
$promptUserSetupRoles = isset($bca_settings['promptusersetuproles']) ? $bca_settings['promptusersetuproles'] : '';

if (!is_array($promptUserSetupRoles)) {
    $promptUserSetupRoles = array_map('trim', explode(',', $promptUserSetupRoles)); 
}

$promptUserSetupRoles = array_map('strtolower', $promptUserSetupRoles);
$user_roles = wp_get_current_user()->roles;
$user_roles = array_map('strtolower', $user_roles);

$shouldPromptUser = false;

if ($userSelection === 'specificUser') {
    if (!empty($promptUserSetupRoles)) {
        foreach ($user_roles as $role) {
            if (in_array($role, $promptUserSetupRoles)) {
                $shouldPromptUser = true;
                break;
            }
        }
    }
} else {
    $shouldPromptUser = true;
}

?>
<!-- Authentication Options -->
<div class="px-4 mfa-sec">
    <div class="row g-4 config-cards">
        <!-- BAAR-IGA Authenticator -->
        <div class="col-12 col-md-6 col-lg-3" id="card-baarIga">
            <div class="card card-mfa h-100 border-2 bg-muted" id="baarIgaCard">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="auth-icon me-3">
                            <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . '../../assets/images/logo.webp'); ?>"
                                alt="BAAR-IGA" width="32" height="32" />
                        </div>
                        <h5 class="card-title mb-0">BAAR-IGA Authenticator</h5>
                    </div>
                    <p class="card-text text-muted">Use Push Notification or Timed-One Time Password shown in BAAR-IGA Authenticator App to login.</p>
                    <hr>
                    <a href="#" class="btn text-blue  p-0 mt-2" id="baarIgaAuth" data-bs-toggle="collapse"
                        data-bs-target="#authenticatorSetup" onclick="activateCard('baarIgaCard')">Configure</a>
                </div>
            </div>
        </div>

        <!-- OTP over Email -->
        <div class="col-12 col-md-6 col-lg-3" id="card-otpEmail">
            <div class="card card-mfa h-100 border-2" id="otpEmailCard">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="auth-icon me-3">
                            <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . '../../assets/images/email.png'); ?>"
                                alt="BAAR-IGA" width="32" height="32" />
                        </div>
                        <h5 class="card-title mb-0">OTP over Email</h5>
                    </div>
                    <p class="card-text text-muted">Use One Time Password sent to your email address to login.</p>
                    <hr>
                    <a href="#" class="btn text-blue  p-0 mt-2" data-bs-toggle="collapse"
                        data-bs-target="#otpConfig" onclick="activateCard('otpEmailCard')">Configure</a>
                </div>
            </div>
        </div>

        <!-- OTP Via Mobile -->
        <div class="col-12 col-md-6 col-lg-3" id="card-otpMobile">
            <div class="card card-mfa h-100 border-2" id="otpMobileCard">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="auth-icon me-3">
                            <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . '../../assets/images/SMS.png'); ?>"
                                alt="BAAR-IGA" width="32" height="32" />
                        </div>
                        <h5 class="card-title mb-0">OTP Via SMS</h5>
                    </div>
                    <p class="card-text text-muted">Use One Time Password sent to your mobile number to login.</p>
                    <hr>
                    <a href="#" class="btn text-blue  p-0 mt-2">Coming Soon</a>
                    <!-- <a href="#" class="btn text-blue  p-0 mt-2" data-bs-toggle="collapse"
                        data-bs-target="#otpmobileConfig" onclick="activateCard('otpMobileCard')">Configure</a> -->
                </div>
            </div>
        </div>

        <!-- Security Questions -->
        <div class="col-12 col-md-6 col-lg-3" id="card-securityQuestions">
            <div class="card card-mfa h-100 border-2" id="securityQuestionsCard">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="auth-icon me-3">
                            <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . '../../assets/images/security-quetion.png'); ?>"
                                alt="BAAR-IGA" width="32" height="32" />
                        </div>
                        <h5 class="card-title mb-0">Security Questions</h5>
                    </div>
                    <p class="card-text text-muted">Configure and Answer Three Security Questions</p>
                    <hr>
                    <a href="#" class="btn text-blue  p-0 mt-2" data-bs-toggle="collapse"
                        data-bs-target="#securityQuestions" onclick="activateCard('securityQuestionsCard')">Configure</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Authenticator Setup Collapse -->
    <div class="collapse mt-4" id="authenticatorSetup">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="mb-0">BAAR-IGA Authenticator</h5>
                <?php 
                if (!empty($mfa_config_status['totp_config']) && $mfa_config_status['totp_config'] === 'completed') {
                    echo '<h5 class="mb-0" style="color:green;">You have successfully configured BAAR MFA</h5>';
                }
                ?>
                <button type="button" class="btn-close" data-bs-toggle="collapse"
                    data-bs-target="#authenticatorSetup"></button>
            </div>
            <hr>
            <div class="row mt-4">
                <!-- Column 1 -->
                <div class="col-12 col-md-6">
                    <div class="p-3 border-end border-1">
                        <!--<div class="mb-4 d-md-flex justify-content-between">
                            <label class="form-label fw-bold">1. Choose an Authenticator App</label>
                            <select class="form-select">
                                <option>BAAR IGA Authenticator</option>
                                <option>Add Authenticator (Premium)</option>
                            </select>
                        </div>-->
                        <div class="mb-4" style="display: grid" id="qrCodeContainer">
                            <label class="form-label fw-bold">Scan the QR code from Authenticator</label>
                            <div id="qrCodeContainer1"></div>
                        </div>
                        <div class="mb-4" style="display: grid" id="qrCodeGenerateContainer">
                            <p id="statusMessage" style="display: none; font-size: 17px;"></p>
                            <button type="submit" id="qrCodeGenerateContainerBtn" class="btn btn-primary px-4">Generate QR Code and Register</button>
                        </div>
                        <hr>
                        <form method="POST" action="" class="mt-3" id="verify-otp-form">
                            <div class="mb-4 d-md-flex justify-content-between">
                                <label class="form-label fw-bold">Enter the code from the Authenticator App:</label>
                                <input type="text" name="otp_code" id="otp_code" class="form-control bg-gray"
                                    placeholder="Enter TOTP">
                            </div>

                            <button type="submit" class="btn btn-primary px-4">Verify & Save</button>
                        </form>
                        <div id="totp-response-message"></div>
                        <!-- <div class="p-3">
                            <p class="mb-2 fs-6 text-blue">Can't scan the QR code?</p>
                            <p class="mb-2 fs-6 text-dark">1. Tap on (+) and Add Set up Key</p>
                            <p class="mb-2 fs-6 text-dark">2. Enter the following information in the respective fields:</p>
                            <div class="mt-4 mb-4 bg-warning p-3 rounded">
                                <p class="mb-2 fs-6 text-dark"><strong>Account Provided = </strong> <?php //echo esc_html($tenant_name); ?></p>
                                <p class="mb-2 fs-6 text-dark"><strong>Email address = </strong> <?php// echo esc_html($user_email); ?></p>
                                <p class="mb-2 fs-6 text-dark"><strong>Secret Key = </strong> <?php //echo esc_html($api_key); ?></p>
                            </div>
                            <p class="mb-2 fs-6 text-dark">3. Key type: Make sure Time-based is selected.</p>
                            <p class="mb-2 fs-6 text-dark">4. Tap Submit To complete the Registration.</p>
                        </div> -->
                    </div>
                </div>

                <!-- Column 2 -->
                <div class="col-12 col-md-6">
                    <div class="p-3">
                        <p class="mb-2 fs-6 text-blue">Can't scan the QR code? <a href="?page=baar-connect-auth&tab=faq"
                                class="text-primary text-decoration-none text-blue">Contact Support</a>.</p>
                        <div class="mt-4 bg-light p-3 rounded">
                            <p class="mb-2">Get the Authenticator App -</p>
                            <div>
                                <a href="https://play.google.com/store/apps/details?id=com.baar.ai.baar_iga_authenticator&hl=en_IN" target="_blank" class="text-primary text-decoration-none me-3 text-blue">Android Play
                                    Store</a>
                                <a href="https://apps.apple.com/ca/app/baar-iga-authenticator/id6450792846" target="_blank" class="text-primary text-decoration-none text-blue">iOS App Store</a>
                            </div>
                            <?php if($mfaStatus === 'scanned' && $recoveryCodes === 'enableRecoveryCodes'){ ?>
                                <div class="mfa-tab-container" <?php echo $hide_button ? 'style="display:none;"' : ''; ?>>
                                    <button type="button" id="generate-recovery-codes" class="btn btn-primary px-4 mt-4">Generate Recovery Codes</button>
                                    <div id="recovery-codes-output" class="px-4 mt-4"></div>
                                    <form id="verify-recovery-code-form" class="px-4 mt-4">
                                    </form>
                                </div>
                                <div id="recovery-codes-display">
                                    <?php if ($recovery_codes) : ?>
                                        <p class="mb-2 mt-4">Your recovery codes are:</p>
                                        <ul>
                                            <?php foreach ($recovery_codes as $key => $code) : ?>
                                                <?php if (!empty($code)) : ?>
                                                    <li><?php echo esc_html($code); ?></li>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </ul>
                                        <button type="button" id="download-recovery-codes" class="btn btn-primary mt-4">Download Recovery Codes (PDF)</button>
                                        <button type="button" id="send-recovery-codes-email" class="btn btn-secondary mt-4">Send Recovery Codes via Email</button>
                                    <?php endif; ?>
                                </div>
                                <?php } elseif ($recoveryCodes === 'disableRecoveryCodes'){
                                echo "<p class='mb-2 mt-4' style='color:red; font-weight: 400; font-size: 17px;'>Recovery Codes are disabled by admin</p>";

                                } else { echo '<button type="button" class="btn btn-primary px-4 mt-4">Generate Recovery Codes</button><p class="mb-2 mt-4" style="color:red; font-weight: 400; font-size: 17px;"> Please register with TOTP via BAAR-IGA Authenticator to enable and generate Recovery Codes </p>'; 
                            } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Security Questions Configuration Collapse -->
    <div class="collapse mt-4" id="securityQuestions">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="mb-0">Configure Security Questions</h5>
                <?php 
                if (!empty($mfa_config_status['securityQuestion_config']) && $mfa_config_status['securityQuestion_config'] === 'completed') {
                    echo '<h5 class="mb-0" style="color:green;">You have successfully configured Security Questions MFA</h5>';
                }
                ?>
                <button type="button" class="btn-close" data-bs-toggle="collapse" data-bs-target="#securityQuestions"></button>
            </div>
            <hr class="border-2">
            <form id="security-questions-form">
                <!-- Question 1 -->
                <div class="row mb-3">
                    <div class="col-1 col-md-1">
                        <label class="fw-bold">1.</label>
                    </div>
                    <div class="col-5 col-md-5">
                        <label>What was the name of your first school?</label>
                        <input type="hidden" name="question_1" value="What was the name of your first school?">
                    </div>
                    <div class="col-5 col-md-6 text-center">
                        <input type="text" name="answer_1" class="form-control" id="answer_1" placeholder="Enter your answer" required>
                    </div>
                </div>

                <!-- Question 2 -->
                <div class="row mb-3">
                    <div class="col-1 col-md-1">
                        <label class="fw-bold">2.</label>
                    </div>
                    <div class="col-5 col-md-5">
                        <label>In what city were you born?</label>
                        <input type="hidden" name="question_2" value="In what city were you born?">
                    </div>
                    <div class="col-5 col-md-6 text-center">
                        <input type="text" name="answer_2" class="form-control" id="answer_2" placeholder="Enter your answer" required>
                    </div>
                </div>

                <!-- Question 3 -->
                <div class="row mb-3">
                    <div class="col-1 col-md-1">
                        <label class="fw-bold">3.</label>
                    </div>
                    <div class="col-5 col-md-5">
                        <label>What is the name of your favorite holiday destination?</label>
                        <input type="hidden" name="question_3" value="What is the name of your favorite holiday destination?">
                    </div>
                    <div class="col-5 col-md-6 text-center">
                        <input type="text" name="answer_3" class="form-control" id="answer_3" placeholder="Enter your answer" required>
                    </div>
                </div>

                <!-- Question 4 -->
                <div class="row mb-3">
                    <div class="col-1 col-md-1">
                        <label class="fw-bold">4.</label>
                    </div>
                    <div class="col-5 col-md-5">
                        <label>What was the make of your first car?</label>
                        <input type="hidden" name="question_4" value="What was the make of your first car?">
                    </div>
                    <div class="col-5 col-md-6 text-center">
                        <input type="text" name="answer_4" class="form-control" id="answer_4" placeholder="Enter your answer" required>
                    </div>
                </div>

                <!-- Question 5 -->
                <div class="row mb-3">
                    <div class="col-1 col-md-1">
                        <label class="fw-bold">5.</label>
                    </div>
                    <div class="col-5 col-md-5">
                        <label>What is your mother’s maiden name?</label>
                        <input type="hidden" name="question_5" value="What is your mother’s maiden name?">
                    </div>
                    <div class="col-5 col-md-6 text-center">
                        <input type="text" name="answer_5" class="form-control" id="answer_5" placeholder="Enter your answer" required>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary px-4 mt-4 submit-btn" id="saveBtn">Save</button>
                </div>
            </form>
        </div>
    </div>

    <!-- OTP over email Configuration Collapse -->
    <div class="collapse mt-4" id="otpConfig">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="mb-0">Configure OTP over Email</h5>
                <?php 
                if (!empty($mfa_config_status['otpEmail_config']) && $mfa_config_status['otpEmail_config'] === 'completed') {
                    echo '<h5 class="mb-0" style="color:green;">You have successfully configured Email OTP MFA</h5>';
                }
                ?>
                <button type="button" class="btn-close" data-bs-toggle="collapse" data-bs-target="#otpConfig"></button>
            </div>
            <hr class="border-2">
                <P class="mb-0">Please note that OTP over email will be enabled only if the STMP is configured in your WordPress site.
            </P>

            <div class="row">
                <div class="col-12 col-md-12">
                    <div class="p-4">
                        <div class="row align-items-center">
                            <div class="col-md-12 d-md-flex gap-4 align-items-center">
                                <label for="email" class="form-label mb-0 fs-6 fw-bold mb-md-0 mb-3">Enter your
                                    Email:</label>
                                <input type="email" class="form-control bg-gray w-25" id="email"
                                    value="<?php echo esc_attr(wp_get_current_user()->user_email); ?>" disabled>
                            </div>
                        </div>
                        <button type="button" id="sendOtpButton" class="btn btn-primary px-4 mt-4"
                            data-bs-toggle="modal" data-bs-target="#otpModal">
                            Verify and Save
                        </button>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- OTP over mobile Configuration Collapse -->
    <div class="collapse mt-4" id="otpmobileConfig">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="mb-0">Configure OTP via SMS</h5>
                <button type="button" class="btn-close" data-bs-toggle="collapse" data-bs-target="#otpmobileConfig"></button>
            </div>
            <hr class="border-2">
            <div class="row">
                <div class="col-12 col-md-12">
                    <div class="p-4">
                        <div class="row align-items-center">
                            <div class="col-md-12 d-md-flex gap-4 align-items-center">
                                <label for="number" class="form-label mb-0 fs-6 fw-bold mb-md-0 mb-3">Enter your
                                    Mobile:</label>
                                <input type="number" class="form-control bg-gray w-25" id="number"
                                    value="<?php echo esc_attr(wp_get_current_user()->user_email); ?>" disabled>
                            </div>
                        </div>
                        <button type="button" id="sendOtpButton" class="btn btn-primary px-4 mt-4"
                            data-bs-toggle="modal" data-bs-target="#otpModal">
                            Send OTP
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- OTP Verification Modal -->
    <div class="modal fade" id="otpModal" tabindex="-1" aria-labelledby="otpModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header border-0">
                    <!-- <button type="button" class="btn-close" data-bs-dismiss="modal"></button> -->
                </div>
                <div class="modal-body opt-body">
                    <!-- <h5 class="modal-title fw-bold mb-3" id="otpModalLabel">Enter OTP:</h5> -->
                    <h6 id="otpMessage" class="mb-3"></h6>
                    <form>
                        <input type="text" class="form-control mb-2 w-100" id="otpInput" placeholder="Enter OTP">
                        <div class="d-md-flex justify-content-between">
                            <!-- <div class="text-danger mb-2 small fw-bold" id="otpErrorMessage">Incorrect OTP. Please enter
                                the correct OTP.</div> -->
                            <a href="#" class="text-primary text-decoration fw-bold mb-3" id="resendOtp">Resend OTP</a>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    // Generate QR code 

// jQuery(document).ready(function($) {
//     $('#qrCodeGenerateContainerBtn').on('click', function(e) {
//         e.preventDefault();
// alert('hello');
//         // Send an AJAX request
//         $.ajax({
//             url: myPluginAjax.ajax_url,
//             type: 'POST',
//             data: {
//                 action: 'generate_qr_code', // Action hook for PHP
//                 nonce: myPluginAjax.generate_qr_nonce, // Send the nonce to validate on server side
//             },
//             success: function(response) {
//                 if (response.success) {
//                     // Show the QR code image
//                     alert('QR Code generated successfully! URL: ' + response.data.qr_code_data);
//                 } else {
//                     alert('Error: ' + response.data.message);
//                 }
//             },
//             error: function() {
//                 alert('An error occurred while generating the QR Code.');
//             }
//         });
//     });
// });

</script>