<?php
require_once plugin_dir_path(__FILE__) . 'includes/class-non-admin-mfa.php';

add_action('admin_menu', 'bca_register_non_admin_menu');

function bca_register_non_admin_menu() {

    $bca_settings = get_option('bca_settings');
    $allowDisableMFA = isset($bca_settings['allowDisableMFA']) ? $bca_settings['allowDisableMFA'] : '';

    $enforceOn = isset($bca_settings['enforceOn']) ? $bca_settings['enforceOn'] : '';
    $selectedRoles = isset($bca_settings['selectedRoles']) ? $bca_settings['selectedRoles'] : '';
    $selectedUsers = isset($bca_settings['selectedUsers']) ? $bca_settings['selectedUsers'] : '';

    if (!is_array($selectedRoles)) {
        $selectedRoles = array_map('trim', explode(',', $selectedRoles)); 
    }

    if (!is_array($selectedUsers)) {
        $selectedUsers = array_map('trim', explode(',', $selectedUsers)); 
    }

    $selectedRoles = array_map('strtolower', $selectedRoles);
    $user_roles = wp_get_current_user()->roles;
    $user_roles = array_map('strtolower', $user_roles);

    // Get the current user's ID
    $current_user_id = get_current_user_id();

    $shouldShowMenu = false;

    // Handle enforceOn conditions
    if ($enforceOn === 'allUsers') {
        $shouldShowMenu = true;
    } elseif ($enforceOn === 'noEnforce') {
        $shouldShowMenu = false;
    } elseif ($enforceOn === 'selectedUsers') {
        // Check if the current user has one of the selected roles
        if (!empty($selectedRoles)) {
            foreach ($user_roles as $role) {
                if (in_array($role, $selectedRoles)) {
                    $shouldShowMenu = true;
                    break;
                }
            }
        }

        // Check if the current user is in the selected users list
        if (!empty($selectedUsers) && in_array($current_user_id, $selectedUsers)) {
            $shouldShowMenu = true;
        }
    } else {
        // Default case: Check roles or users
        if (!empty($selectedRoles)) {
            foreach ($user_roles as $role) {
                if (in_array($role, $selectedRoles)) {
                    $shouldShowMenu = true;
                    break;
                }
            }
        }

        // Check if the current user is in the selected users list
        if (!empty($selectedUsers) && in_array($current_user_id, $selectedUsers)) {
            $shouldShowMenu = true;
        }
    }

    // If the menu should be shown (either role or user check passed), and other conditions are met, show the menu
    if ($shouldShowMenu && !current_user_can('administrator')) {
        // Add the "Baar Connect MFA" menu for non-admin users
        add_menu_page(
            'BAAR MFA', // Page title
            'BAAR MFA', // Menu title
            'read',             // Capability required to access the menu (use 'read' to allow all non-admins)
            'baar-connect-mfa', // Menu slug (this should match the unique identifier you want to use)
            'bca_render_non_admin_page', // Function to render the page content
            'dashicons-lock', // Icon for the menu (you can use any Dashicon)
            80  // Position of the menu item
        );
    }

    // Optionally remove the original menu for non-admin users
    if (!current_user_can('administrator')) {
        remove_menu_page('baar-connect-auth'); // Removes the original "Baar Connect Auth" menu from non-admin users
    }
}

// Function to render the non-admin menu page content
function bca_render_non_admin_page() {

    BCA_NonAdminMfa::render_tab();
}


// Check if user exists and create a new entry if not, then handle role-based redirection
function check_and_create_user_and_role_based_redirect($user_login, $user) {
    global $wpdb;

    ob_start();

    // Get user email
    $user_email = $user->user_email;

    // Query to check if the user exists in bca_api_entries table
    $query = $wpdb->prepare(
        "SELECT * FROM {$wpdb->prefix}bca_api_entries WHERE user_email = %s",
        $user_email
    );

    // Fetch result
    $result = $wpdb->get_row($query);

    // If the user does not exist, create a new user record in bca_api_entries table
    if (empty($result)) {
        // Get tenant name and API key from bca_master table
        $tenant_query = $wpdb->prepare("SELECT tenant_name, api_key FROM {$wpdb->prefix}bca_master LIMIT 1");
        $tenant_result = $wpdb->get_row($tenant_query);

        if (!empty($tenant_result)) {
            $tenant_name = $tenant_result->tenant_name;
            $api_key = $tenant_result->api_key;

            // Insert new record into bca_api_entries table
            $insert_result = $wpdb->insert(
                "{$wpdb->prefix}bca_api_entries",
                [
                    'tenant_name' => $tenant_name,
                    'user_email' => $user_email,
                    'username' => $user_login, // Or any field that represents the username
                    'default_mfa_method' => 'totp',
                    'qr_code' => '',
                    'qr_status' => 'not_scanned',
                    'created_at' => current_time('mysql'),
                    'modified_at' => current_time('mysql'),
                    // 'totp' => '' // Initially, no TOTP
                    // 'user_status' => 'login'
                ]
            );

            // Optionally, log or handle errors if the user creation fails
            if ($insert_result === false) {
                error_log('Failed to insert new user into bca_api_entries for ' . $user_email);
            }

            update_user_meta($user->ID, 'account_status', 'active');
        }
    }

    // $bca_settings = get_option('bca_settings');
    // $redirect_url = isset($bca_settings['redirectAfterMFA']) ? $bca_settings['redirectAfterMFA'] : '';
    // $redirectUser = isset($bca_settings['redirectUser']) ? $bca_settings['redirectUser'] : '';

    // if(empty($redirect_url) || $redirectUser == 'redirectNo') {
    //     $redirect_url = admin_url();
    // }

    wp_redirect(admin_url());
    exit;
}

// Hook into wp_login to perform both user creation and redirection
add_action('wp_login', 'check_and_create_user_and_role_based_redirect', 10, 2);


function update_user_status_on_logout($user_id) {
    global $wpdb;

    // Get user email based on user ID
    $user = get_user_by('id', $user_id);
    if ($user) {
        $user_email = $user->user_email;

        // Update user status to 'logout' in bca_api_entries table
        $update_result = $wpdb->update(
            "{$wpdb->prefix}bca_api_entries", // Table name
            ['user_status' => 'logout'], // Column to update
            ['user_email' => $user_email], // Where clause (match by user_email)
            ['%s'], // Data format for 'user_status' (string)
            ['%s'] // Data format for 'user_email' (string)
        );

        // Log the result of the update operation
        if ($update_result === false) {
            error_log('Error updating user status to logout for ' . $user_email);
        } else {
            error_log('Successfully updated user status to logout for ' . $user_email);
        }
    }
}

// Hook into wp_logout to update the user status when they log out
add_action('wp_logout', 'update_user_status_on_logout');



// Handle AJAX request to save user MFA option
// Handle AJAX request to save user MFA option
add_action('wp_ajax_save_user_setting_mfa_option', 'save_user_setting_mfa_option');

function save_user_setting_mfa_option() {
    if (isset($_POST['selected_option'])) {
        global $wpdb;

        $selected_option = sanitize_text_field($_POST['selected_option']);
        $current_user = wp_get_current_user();
        $user_email = $current_user->user_email;

        // Check if the user already has an entry in the table
        $existing_entry = $wpdb->get_row(
            $wpdb->prepare("SELECT * FROM {$wpdb->prefix}bca_api_entries WHERE user_email = %s", $user_email)
        );

        if ($existing_entry) {
            // Update the existing entry with the new MFA method
            $wpdb->update(
                "{$wpdb->prefix}bca_api_entries",
                array(
                    'default_mfa_method' => $selected_option,
                ),
                array('user_email' => $user_email),
                array('%s'),
                array('%s')
            );
        } else {
            // Insert a new entry if the user doesn't have one
            $wpdb->insert(
                "{$wpdb->prefix}bca_api_entries",
                array(
                    'user_email' => $user_email,
                    'defauly_mfa_method' => $selected_option,
                ),
                array('%s', '%s')
            );
        }

        wp_send_json_success(); // Send a success response
    }

    wp_send_json_error(); // Send an error response if no data is provided
}


// user logout if he not verified MFA start

// Check account status when a user tries to log in
function plugin_prevent_inactive_user_login($user, $username, $password) {
    if (is_a($user, 'WP_User')) {
        $account_status = get_user_meta($user->ID, 'account_status', true);
        $bca_settings = get_option('bca_settings');
        $gracePeriodAction = isset($bca_settings['gracePeriodAction']) ? $bca_settings['gracePeriodAction'] : '';

        if ($account_status === 'inactive' && $gracePeriodAction === 'blockUser') {
            return new WP_Error(
                'inactive_user',
                __('Your account is inactive. Please contact the admin to activate your account.')
            );
        }
    }

    return $user;
}

add_filter('authenticate', 'plugin_prevent_inactive_user_login', 30, 3);


// Check account status for logged-in users (including those already logged in)
function check_inactive_user_status() {
    // If the user is not logged in, no need to check
    if (!is_user_logged_in()) {
        return;
    }

    // Get the current logged-in user
    $user = wp_get_current_user();

    $bca_settings = get_option('bca_settings');
    $gracePeriodAction = isset($bca_settings['gracePeriodAction']) ? $bca_settings['gracePeriodAction'] : '';

    // Check if the account status is inactive
    if (get_user_meta($user->ID, 'account_status', true) == 'inactive' && $gracePeriodAction == 'blockUser') {
        wp_logout(); // Log the user out
        wp_die('Your account is inactive. Please contact the admin to activate your account.'); // Show error message
    }
}
add_action('admin_init', 'check_inactive_user_status'); // For admin/dashboard area
add_action('template_redirect', 'check_inactive_user_status'); // For the front end



// function role_based_redirect_after_login($user_login, $user) {
//     $user_role = $user->roles[0];
//     $redirect_url = '';
//     if ($user_role == 'administrator') {
//         $redirect_url = admin_url('admin.php?page=baar-connect-auth&tab=mfa');  
//     } elseif ($user_role == 'editor') {
//         $redirect_url = admin_url('admin.php?page=baar-connect-mfa');  
//     } elseif ($user_role == 'subscriber') {
//         $redirect_url = admin_url('admin.php?page=baar-connect-mfa');  
//     } else {
//         $redirect_url = admin_url('admin.php?page=baar-connect-mfa');  
//     }

//     wp_redirect($redirect_url);
//     exit;
// }

// add_action('wp_login', 'role_based_redirect_after_login', 10, 2);


// function show_popup_on_login() {
//     $bca_settings = get_option('bca_settings');
    
//     if ($bca_settings && isset($bca_settings['promptSetup']) && $bca_settings['promptSetup'] === 'on') {
//         echo '
//         <div id="mfa-setup-popup" style="display:none;">
//             <div class="popup-content">
//                 <h2>Setup MFA</h2>
//                 <p>Please complete your MFA setup.</p>
//                 <button id="close-popup">Close</button>
//             </div>
//         </div>
//         <style>
//             #mfa-setup-popup {
//                 position: fixed;
//                 top: 0;
//                 left: 0;
//                 width: 100%;
//                 height: 100%;
//                 background: rgba(0, 0, 0, 0.5);
//                 display: flex;
//                 justify-content: center;
//                 align-items: center;
//             }
//             .popup-content {
//                 background: white;
//                 padding: 20px;
//                 border-radius: 5px;
//                 text-align: center;
//             }
//             #close-popup {
//                 margin-top: 10px;
//             }
//         </style>
//         <script type="text/javascript">
//             jQuery(document).ready(function($) {
//                 $("#mfa-setup-popup").fadeIn();
//                 $("#close-popup").click(function() {
//                     $("#mfa-setup-popup").fadeOut();
//                 });
//             });
//         </script>';
//     }
// }

// add_action('wp_footer', 'show_popup_on_login');



