<?php 
class BCA_NonAdminMfa
{
    public static function render_tab()
    {
        global $wpdb;
        $current_user = wp_get_current_user();
        // Prepare and run the query
        $query = $wpdb->prepare("SELECT * FROM {$wpdb->prefix}bca_master");
        $result = $wpdb->get_row($query);

        // Check if the result is not empty and retrieve data
        if (!empty($result)) {
            $tenant_name = $result->tenant_name;
            $api_key = $result->api_key;
            $user_email = $current_user->user_email;
        } else {
            // Handle case when no result is returned
            $tenant_name = '';
            $api_key = '';
            $user_email = '';
        }

        // Get the current tab from the URL, default to 'mfa' if not set
        $active_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'mfa';

        // Begin the container for the page content
        echo '<div class="wrap container">
        <div class="auth-icon me-3 d-flex align-items-center bca-main-title-div">
            <img src="' . esc_url(plugin_dir_url(__FILE__) . '../../assets/images/logo.webp') . '" alt="BAAR-IGA" width="32" height="32" />
            <h1 class="bca-main-title">BAAR MFA</h1>
        </div>';

        // Nav tabs: Only show the "User Setting" tab if 'allowPreferredMFA' is set to 'allowPreferredYes'
        echo '<ul class="nav nav-tabs">
        <li class="nav-item">
            <a class="nav-link ' . ($active_tab === 'mfa' ? 'active' : '') . '" href="?page=baar-connect-mfa&tab=mfa">MFA</a>
        </li>
        <li class="nav-item">
                <a class="nav-link ' . ($active_tab === 'user_setting' ? 'active' : '') . '" href="?page=baar-connect-mfa&tab=user_setting">User Setting</a>
            </li>
        </ul>';

        // Begin the container for the page content
        // echo '<div class="wrap container">
        //         <div class="auth-icon me-3 d-flex align-items-center bca-main-title-div">
        //             <img src="' . esc_url(plugin_dir_url(__FILE__) . '../../assets/images/logo.webp') . '" alt="BAAR-IGA" width="32" height="32" />
        //             <h1 class="bca-main-title">BAAR MFA</h1>
        //         </div>

        //         <ul class="nav nav-tabs">
        //             <li class="nav-item">
        //                 <a class="nav-link ' . ($active_tab === 'mfa' ? 'active' : '') . '" href="?page=baar-connect-mfa&tab=mfa">MFA</a>
        //             </li>
        //             <li class="nav-item">
        //                 <a class="nav-link ' . ($active_tab === 'user_setting' ? 'active' : '') . '" href="?page=baar-connect-mfa&tab=user_setting">User Setting</a>
        //             </li>
        //         </ul>';

        // Render content based on the active tab
        // switch ($active_tab) {
        //     case 'user_setting':
        //         self::render_user_setting_tab($tenant_name, $api_key, $user_email);
        //         break;
        //     case 'mfa':
        //     default:
        //         self::render_mfa_tab($tenant_name, $api_key, $user_email);
        //         break;
        // }

        switch ($active_tab) {
            case 'user_setting':
                self::render_user_setting_tab($tenant_name, $api_key, $user_email);
                break;
            case 'mfa':
            default:
                self::render_mfa_tab($tenant_name, $api_key, $user_email);
                break;
        }

        echo '</div>';
    }

    // Render the MFA tab content
    public static function render_mfa_tab($tenant_name, $api_key, $user_email)
    {
        include BCA_PLUGIN_PATH . 'non-admin/templates/mfa-config.php';
    }

    // Render the User Setting tab content
    public static function render_user_setting_tab($tenant_name, $api_key, $user_email)
    {
        include BCA_PLUGIN_PATH . 'non-admin/templates/user-setting.php';
    }
}

