<?php
ob_start();
function hide_admin_bar_until_verified($show_admin_bar) {
    $user_id = get_current_user_id();
    if (!get_user_meta($user_id, '_otp_verified', true)) {
        return false; // Don't show the admin bar if OTP is not verified
    }
    return $show_admin_bar; // Show admin bar after OTP verification
}
add_filter('show_admin_bar', 'hide_admin_bar_until_verified');

// OTP Verification Popup Script
function otp_verification_popup_script() {
    // Get the current screen
    $current_screen = get_current_screen();

    if (is_user_logged_in() && !get_user_meta(get_current_user_id(), '_otp_verified', true) && (!isset($current_screen->id) || !in_array($current_screen->id, ['toplevel_page_baar-connect-mfa', 'toplevel_page_baar-connect-auth'])) && !(isset($_GET['page']) && $_GET['page'] === 'baar-connect-auth' && isset($_GET['tab']) && $_GET['tab'] === 'mfa')) {

        // Get the current user and check if they have records in the bca_api_entries table
        global $wpdb;
        $current_user = wp_get_current_user();
        $user_email = $current_user->user_email;
        $username = $current_user->user_login;

        $bca_settings = get_option('bca_settings');
        $recoveryCodes = isset($bca_settings['recoveryCodes']) ? $bca_settings['recoveryCodes'] : '';

       // Specify the table name
        $table_name = $wpdb->prefix . "bca_brand_details";

        // Fetch the first row from the table (assuming only one entry)
        $existing_brand = $wpdb->get_row("SELECT brand_name, brand_logo FROM $table_name LIMIT 1");

        // Set fallback values
        $default_logo = plugin_dir_url(__FILE__) . '../assets/images/logo.webp';
        $brand_name = 'BAAR MFA';
        $brand_logo = $default_logo; // Default logo

        // If a brand entry exists, use it
        if ($existing_brand) {
            $brand_name = $existing_brand->brand_name ?: $brand_name; // Use the brand name if set
            $brand_logo = !empty($existing_brand->brand_logo) 
                ? plugin_dir_url(__FILE__) . $existing_brand->brand_logo 
                : $default_logo; // Construct the logo URL
        }

        // Query to check if the user has records in the bca_api_entries table
        $query = $wpdb->prepare(
            "SELECT m.tenant_name, m.api_key, e.user_status, e.qr_code, e.force_user, e.qr_status, e.default_mfa_method, e.created_at, e.modified_at, e.totp
            FROM {$wpdb->prefix}bca_master m
            JOIN {$wpdb->prefix}bca_api_entries e ON m.tenant_name = e.tenant_name
            WHERE e.user_email = %s",
            $user_email
        );
        
        // Execute the query
        $result = $wpdb->get_row($query);

        // Redirect user based on role 
        $bca_settings = get_option('bca_settings');

        $redirect_url = isset($bca_settings['redirectAfterMFA']) ? $bca_settings['redirectAfterMFA'] : '';
        $redirectUser = isset($bca_settings['redirectUser']) ? $bca_settings['redirectUser'] : '';

        $role_redirects = isset($bca_settings['roleRedirects']) ? $bca_settings['roleRedirects'] : array();

        if (empty($redirect_url) || $redirectUser == 'redirectNo') {
            $current_user = wp_get_current_user();
            if (isset($role_redirects[$current_user->roles[0]])) {
                $redirect_url = $role_redirects[$current_user->roles[0]];
            } else {
                $redirect_url = admin_url();
            }
        }

        echo '<script type="text/javascript">var redirect_url = "' . esc_js($redirect_url) . '";</script>';


        // Check IP allow or not 
        $user_ip = file_get_contents('https://api.ipify.org');
        $allowed_ips = isset($settings['allowedIps']) ? $settings['allowedIps'] : '';

        $allowed_ips_array = array_map('trim', explode(',', $allowed_ips));

        $ipallow = in_array($user_ip, $allowed_ips_array);

        if (in_array($user_ip, $allowed_ips_array)) {
            $message = "Your IP is matched!";
        } else {
            $message = "Your IP is not matched!";
        }


        $enforceOn = isset($bca_settings['enforceOn']) ? $bca_settings['enforceOn'] : '';
        $userSelection = isset($bca_settings['userSelection']) ? $bca_settings['userSelection'] : '';
        $promptUserSetupRoles = isset($bca_settings['promptusersetuproles']) ? $bca_settings['promptusersetuproles'] : '';
        $selectedRoles = isset($bca_settings['selectedRoles']) ? $bca_settings['selectedRoles'] : '';
        $selectedUsers = isset($bca_settings['selectedUsers']) ? $bca_settings['selectedUsers'] : '';


        if (!is_array($promptUserSetupRoles)) {
            $promptUserSetupRoles = array_map('trim', explode(',', $promptUserSetupRoles)); 
        }

        $promptUserSetupRoles = array_map('strtolower', $promptUserSetupRoles);
        $user_roles = wp_get_current_user()->roles;
        $user_roles = array_map('strtolower', $user_roles);

        $current_user = wp_get_current_user();
        $current_user_id = $current_user->ID;

        // check if the user should be prompted role
        $shouldPromptUser = false;

        if ($userSelection === 'specificUser') {
            if (!empty($promptUserSetupRoles)) {
                foreach ($user_roles as $role) {
                    if (in_array($role, $promptUserSetupRoles)) {
                        $shouldPromptUser = true;
                        break;
                    }
                }
            }
        } else {
            $shouldPromptUser = true;
        }

        // check if the user enabled for the mfa setup user and role

        $shouldShowMenu = false;
        // Handle enforceOn conditions
        if ($enforceOn === 'allUsers') {
            $shouldShowMenu = true;
        } elseif ($enforceOn === 'noEnforce') {
            $shouldShowMenu = false;
        } elseif ($enforceOn === 'selectedUsers') {
            // Check if the current user has one of the selected roles
            if (!empty($selectedRoles)) {
                foreach ($user_roles as $role) {
                    if (in_array($role, $selectedRoles)) {
                        $shouldShowMenu = true;
                        break;
                    }
                }
            }

            // Check if the current user is in the selected users list
            if (!empty($selectedUsers) && in_array($current_user_id, $selectedUsers)) {
                $shouldShowMenu = true;
            }
        } else {
            // Default case: Check roles or users
            if (!empty($selectedRoles)) {
                foreach ($user_roles as $role) {
                    if (in_array($role, $selectedRoles)) {
                        $shouldShowMenu = true;
                        break;
                    }
                }
            }

            // Check if the current user is in the selected users list
            if (!empty($selectedUsers) && in_array($current_user_id, $selectedUsers)) {
                $shouldShowMenu = true;
            }
        }


        // Check if qr_status is 'scanned' and totp is not empty
        if ($result && $result->qr_status == 'scanned' && $result->user_status == 'logout' && !empty($result->totp)) {
            
            // Check if MFA type is "totp"
            if ($shouldShowMenu && isset($bca_settings['mfaType']) && $result->default_mfa_method == 'totp' && $bca_settings['enforceOn'] != 'noEnforce') {
                ?>

<script type="text/javascript">
var brandData = {
    brandName: "<?php echo esc_js($brand_name); ?>",
    brandLogo: "<?php echo esc_url($brand_logo); ?>"
};
jQuery(document).ready(function($) {
    var otpPopupHtml =
        '<div id="otp-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
        '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;line-height: 1.5;">Please enter the TOTP from your BAAR-IGA Authenticator App to Proceed</h3>' +
        '<form method="POST" action="" class="mt-3" id="loginverify-totp-form">' +
        '<div class="mb-4 d-md-flex justify-content-between">' +
        '<input type="text" name="otp_code" id="otp_code" class="form-control bg-gray" placeholder="Enter TOTP" style="padding: 6px; width: 50%;" />' +
        '</div>' +
        '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;padding: 15px;">' +
        '<button type="submit" class="btn btn-primary px-4" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Verify Now</button>' +
        '</div>' +
        '</form>' +
        '<div id="totp-response-message" style="margin-top: 20px; font-size: 14px; color: #555;"></div>' +
        '<p>have issues? <a href="#" id="try-alternative-method" style="text-decoration: underline; color: #2295f2;font-family: Arial, sans-serif; margin-top: 20px; font-size: 14px;">Use Recovery Code</a></p>' +
        '</div>' +

         '<p>If you have lost your recovery code, please contact the administrator.</p>' +
        '</div>' +
        '</div>';
    $('body').append(otpPopupHtml);

    // Responsive Styles
    var responsiveStyles =
        '<style>' +
        '@media screen and (max-width: 768px) {' +
        '#otp-popup > div {' +
        'padding: 20px;' +
        'max-width: 90%;' +
        '}' +
        '#otp-popup p:first-child {' +
        'font-size: 18px;' +
        '}' +
        '#otp-popup p:last-child {' +
        'font-size: 14px;' +
        '}' +
        'button[type="submit"] {' +
        'padding: 12px;' +
        'font-size: 14px;' +
        '}' +
        '#otp_code {' +
        'font-size: 14px;' +
        'padding: 10px;' +
        '}' +
        '}' +
        '@media screen and (max-width: 480px) {' +
        '#otp-popup p:first-child {' +
        'font-size: 16px;' +
        '}' +
        '#otp-popup p:last-child {' +
        'font-size: 12px;' +
        '}' +
        'button[type="submit"] {' +
        'font-size: 12px;' +
        '}' +
        '#otp_code {' +
        'font-size: 12px;' +
        '}' +
        '}' +
        '</style>';
    $('head').append(responsiveStyles);

    // Handle the form submission via AJAX
    $('#loginverify-totp-form').submit(function(e) {
        e.preventDefault(); // Prevent normal form submission
        var otp = $('#otp_code').val();

        if (otp !== '') {
            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: 'POST',
                data: {
                    action: 'loginTOTP_verify',
                    otp_code: otp // Send the OTP code to the server
                },
                success: function(response) {
                    console.log(response);
                    if (response.success) {
                        $('#totp-response-message').html(
                            '<div class="alert alert-success" style="color: green;">TOTP verified successfully!</div>'
                            );
                        // $('#otp-popup').remove(); // Close the OTP popup
                        if (redirect_url) {
                            setTimeout(function() {
                                window.location.href =
                                redirect_url; // Redirect to the URL
                            }, 2000); // 2-second delay before redirection
                        } else {
                            // If no redirect URL is found, just close the popup
                            setTimeout(function() {
                                $('#otp-popup').fadeOut();
                            }, 2000); // 2-second delay
                        }
                    } else {
                        $('#totp-response-message').html(
                            '<div class="alert alert-danger" style="color: red;">Invalid TOTP. Please try again.</div>'
                            );
                    }
                },
                error: function() {
                    $('#totp-response-message').html(
                        '<div class="alert alert-danger">An error occurred. Please try again.</div>'
                        );
                }
            });
        } else {
            $('#totp-response-message').html(
                '<div class="alert alert-warning">Please enter the TOTP.</div>');
        }
    });

    // Handle the alternative method link for TOTP
    $('#try-alternative-method').click(function(e) {
        e.preventDefault();
        // Hide the OTP popup
        $('#otp-popup').fadeOut();

        // Show the recovery code popup
        var recoveryPopupHtml =
            '<div id="recovery-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
            '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
            '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
            '<img src="' + brandData.brandLogo +
            '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
            '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
            '</div>' +
            '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;line-height: 1.5;">Please use your one-time recovery code generated at the time of registration to login</h3>' +
            '<form method="POST" action="" class="mt-3" id="recovery-form">' +
            '<div class="mb-4">' +
            '<label class="form-label" style="font-weight: 700;font-size: 16px;margin: 15px;">Enter Recovery Code:</label>' +
            '<input type="text" name="recovery_code" id="recovery_code" class="form-control" style="padding: 6px; width: 25%;" />' +
            '</div>' +
            '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;padding: 15px;">' +
            '<button type="submit" class="btn btn-primary px-4" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Submit</button>' +
            '</div>' +
            '</form>' +
            '<div id="recovery-response-message" style="margin-top: 20px; font-size: 14px; color: #555;"></div>' +
            '</div>' +
            '</div>';
        $('body').append(recoveryPopupHtml);

        // Handle recovery code form submission
        $('#recovery-form').submit(function(e) {
            e.preventDefault();
            var recoveryCode = $('#recovery_code').val();
            var data = {
                action: 'loginverify_recovery_code',
                nonce: '<?php echo wp_create_nonce("loginverify_recovery_code_nonce"); ?>',
                recovery_code: recoveryCode
            };

            $.ajax({
                url: '<?php echo admin_url("admin-ajax.php"); ?>',
                type: 'POST',
                data: data,
                success: function(response) {
                    var messageDiv = $('#recovery-response-message');
                    if (response.success) {
                        messageDiv.html(
                            '<p style="color: green; font-size: 17px;">' +
                            response.data.message + '</p>');
                        if (redirect_url) {
                            setTimeout(function() {
                                window.location.href =
                                redirect_url; // Redirect to the URL
                            }, 2000); // 2-second delay before redirection
                        } else {
                            // If no redirect URL is found, just close the popup
                            setTimeout(function() {
                                $('#recovery-popup').fadeOut();
                            }, 2000); // 2-second delay
                        }
                    } else {
                        messageDiv.html('<p style="color: red; font-size: 17px;">' +
                            response.data.message + '</p>');
                    }
                },
                error: function() {
                    $('#recovery-response-message').html(
                        '<p style="color: red; font-size: 17px;">An error occurred. Please try again.</p>'
                        );
                }
            });
        });
    });
});
</script>
<?php
            }

            // Check if MFA type is "pushNotification"
            if ($shouldShowMenu && isset($bca_settings['mfaType']) && $result->default_mfa_method == 'pushNotification' && $bca_settings['enforceOn'] != 'noEnforce') {
                ?>
<script type="text/javascript">
var brandData = {
    brandName: "<?php echo esc_js($brand_name); ?>",
    brandLogo: "<?php echo esc_url($brand_logo); ?>"
};
jQuery(document).ready(function($) {

    var loaderImageUrl = "<?php echo esc_url(plugin_dir_url(__FILE__) . '../assets/images/loader.gif'); ?>";

    // Add the popup HTML and Loader
    var pushNotificationPopupHtml =
        '<div id="push-notification-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
        '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;line-height: 1.5;">Please check your registered device and approve the request to continue</h3>' +
        '<div style="display: flex; justify-content: center; align-items: center;">' +
        '<img src="' + loaderImageUrl + '" alt="Loading..." width="80" height="80" id="loader-image" />' +
        '</div>' +
        '<p id="response-message" style="font-family: Arial, sans-serif; font-size: 14px; margin-top: 20px; color: #555;"></p>' +
        '<p>have issues? <a href="#" id="try-alternative-method" style="text-decoration: underline; color: #2295f2;font-family: Arial, sans-serif; margin-top: 20px; font-size: 14px;">Use Recovery Code</a></p>' +
        '</div>' +

        
         '<p>If you have lost your recovery code, please contact the administrator.</p>' +
        '</div>' +
        '</div>';
    $('body').append(pushNotificationPopupHtml);

    // Trigger the API function
    function triggerPushNotificationAuth() {
        var data = {
            action: 'login_push_notification_auth',
            nonce: '<?php echo wp_create_nonce("push_notification_nonce"); ?>'
        };

        $.ajax({
            url: '<?php echo admin_url("admin-ajax.php"); ?>',
            type: 'POST',
            data: data,
            beforeSend: function() {
                $('#response-message').css({
                    'color': '#2295f2', // Set the text color to green
                    'font-size': '18px' // Set a bigger font size, adjust the value as needed
                }).text('Processing your request...');
            },
            success: function(response) {
                console.log(response);
                // Hide loader
                $('#loader-image').hide();
                // Handle the API response
                if (response.success) {
                    // $('#response-message').text(response.data.message);  // Show success message
                    $('#response-message').css({
                        'color': 'green', // Set the text color to green
                        'font-size': '18px' // Set a bigger font size, adjust the value as needed
                    }).text(response.data.message); // Show success message

                    if (redirect_url) {
                        setTimeout(function() {
                            window.location.href = redirect_url; // Redirect to the URL
                        }, 2000); // 2-second delay before redirection
                    } else {
                        // If no redirect URL is found, just close the popup
                        setTimeout(function() {
                            $('#push-notification-popup').fadeOut();
                        }, 2000); // 2-second delay
                    }
                } else {
                    $('#response-message').css({
                        'color': 'red', // Set the text color to green
                        'font-size': '18px' // Set a bigger font size, adjust the value as needed
                    }).text(response.data.message); // Show error message
                }
            },
            error: function() {
                $('#loader-image').hide();
                $('#response-message').css({
                    'color': 'red', // Set the text color to green
                    'font-size': '18px' // Set a bigger font size, adjust the value as needed
                }).text('An error occurred. Please try again.');
            }
        });
    }

    // Automatically trigger the API call when the page loads
    triggerPushNotificationAuth();

    // Optional: Handle the alternative method link
    $('#try-alternative-method').click(function(e) {
        e.preventDefault();
        // Hide the push notification popup
        $('#push-notification-popup').fadeOut();

        // Show the recovery code popup
        var recoveryPopupHtml =
            '<div id="recovery-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
            '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
            '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
            '<img src="' + brandData.brandLogo +
            '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
            '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
            '</div>' +
            '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;line-height: 1.5;">Please use your one-time recovery code generated at the time of registration to login</h3>' +
            '<form method="POST" action="" class="mt-3" id="recovery-form">' +
            '<div class="mb-4">' +
            '<label class="form-label" style="font-weight: 700;font-size: 16px;margin: 15px;">Enter Recovery Code:</label>' +
            '<input type="text" name="recovery_code" id="recovery_code" class="form-control" style="padding: 6px; width: 25%;" />' +
            '</div>' +
            '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;padding: 15px;">' +
            '<button type="submit" class="btn btn-primary px-4" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Submit</button>' +
            '</div>' +
            '</form>' +
            '<div id="recovery-response-message" style="margin-top: 20px; font-size: 14px; color: #555;"></div>' +
            '</div>' +
            '</div>';
        $('body').append(recoveryPopupHtml);

        // Handle recovery code form submission
        $('#recovery-form').submit(function(e) {
            e.preventDefault();
            var recoveryCode = $('#recovery_code').val();
            var data = {
                action: 'loginverify_recovery_code',
                nonce: '<?php echo wp_create_nonce("loginverify_recovery_code_nonce"); ?>',
                recovery_code: recoveryCode
            };

            $.ajax({
                url: '<?php echo admin_url("admin-ajax.php"); ?>',
                type: 'POST',
                data: data,
                success: function(response) {
                    var messageDiv = $('#recovery-response-message');
                    if (response.success) {
                        messageDiv.html(
                            '<p style="color: green; font-size: 17px;">' +
                            response.data.message + '</p>');
                        if (redirect_url) {
                            setTimeout(function() {
                                window.location.href =
                                redirect_url; // Redirect to the URL
                            }, 2000); // 2-second delay before redirection
                        } else {
                            // If no redirect URL is found, just close the popup
                            setTimeout(function() {
                                $('#recovery-popup').fadeOut();
                            }, 2000); // 2-second delay
                        }
                    } else {
                        messageDiv.html('<p style="color: red; font-size: 17px;">' +
                            response.data.message + '</p>');
                    }
                },
                error: function() {
                    $('#recovery-response-message').html(
                        '<p style="color: red; font-size: 17px;">An error occurred. Please try again.</p>'
                        );
                }
            });
        });
    });
});
</script>
<?php
            }

            // Check if MFA type is "OTP on Email"
            if ($shouldShowMenu && isset($bca_settings['mfaType']) && $result->default_mfa_method == 'otpEmail' && $bca_settings['enforceOn'] != 'noEnforce') { ?>
<script type="text/javascript">
var brandData = {
    brandName: "<?php echo esc_js($brand_name); ?>",
    brandLogo: "<?php echo esc_url($brand_logo); ?>",
    recoveryCodes: "<?php echo esc_js($recoveryCodes); ?>"
};
jQuery(document).ready(function($) {
    var recoveryCodeHtml = '';
    if (brandData.recoveryCodes === "enableRecoveryCodes") {
        recoveryCodeHtml = '<p>Have issues? <a href="#" id="try-alternative-method" style="text-decoration: underline; color: #2295f2;font-family: Arial, sans-serif; margin-top: 20px; font-size: 14px;">Use Recovery Code</a></p>';
    }
    var loaderImageUrl = "<?php echo esc_url(plugin_dir_url(__FILE__) . '../assets/images/loader.gif'); ?>";

    // OTP email popup HTML
    var otpEmailPopupHtml =
        '<div id="otp-email-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
        '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;line-height: 1.5;">Please check your email inbox for OTP to continue</h3>' +
        '<div style="display: flex; justify-content: center; align-items: center;">' +
        '<img src="' + loaderImageUrl + '" alt="Loading..." width="80" height="80" id="loader-image" />' +
        '</div>' +
        '<p id="response-message" style="font-family: Arial, sans-serif; font-size: 14px; margin-top: 20px; color: #555;"></p>' +
        '<div id="otp-input-section" style="display: none;">' +
        '<div class="mb-4 d-md-flex justify-content-between">' +
        '<input type="text" id="otp" name="otp" class="form-control" placeholder="Enter OTP" style="padding: 8px; width: 40%; margin: 10px 0;" />' +
        '</div>' +
        '<button id="verifyOtpButton" class="btn btn-primary" style="background-color: #2295f2; color: #fff; border: none; padding: 10px 20px; font-size: 16px; cursor: pointer;">Verify OTP</button>' +
        '</div>' +
        // '<p>Having issues? <a href="#" id="try-alternative-method" style="text-decoration: underline; color: #2295f2; font-family: Arial, sans-serif; font-size: 14px;">Use Recovery Code</a></p>' +
        recoveryCodeHtml +
        '</div>' +
        '</div>';
    $('body').append(otpEmailPopupHtml);

    // Send OTP Email
    function sendOtpEmail() {
        var email =
        '<?php echo $user_email; ?>'; // You can dynamically get this from the logged-in user's email
        var nonce = '<?php echo wp_create_nonce("email_otp_nonce"); ?>';

        $.ajax({
            url: '<?php echo admin_url("admin-ajax.php"); ?>',
            type: 'POST',
            data: {
                action: 'send_loginotp_email',
                nonce: nonce,
                email: email
            },
            beforeSend: function() {
                $('#response-message').css({
                    'color': '#2295f2',
                    'font-size': '18px'
                }).text('Sending OTP to your email...');
            },
            success: function(response) {
                $('#loader-image').hide();
                if (response.success) {
                    $('#response-message').css({
                        'color': 'green',
                        'font-size': '18px'
                    }).text(response.data.message); // Show success message
                    $('#otp-input-section').show(); // Show OTP input and verify button
                } else {
                    $('#response-message').css({
                        'color': 'red',
                        'font-size': '18px'
                    }).text(response.data.message); // Show error message
                }
            },
            error: function() {
                $('#loader-image').hide();
                $('#response-message').css({
                    'color': 'red',
                    'font-size': '18px'
                }).text('An error occurred. Please try again.');
            }
        });
    }

    // Automatically trigger OTP email when the page loads
    sendOtpEmail();

    // Handle OTP verification
    $('#verifyOtpButton').on('click', function() {
        var otp = $('#otp').val();
        var email = '<?php echo $user_email; ?>';
        var nonce = '<?php echo wp_create_nonce("email_otp_nonce"); ?>';

        if (otp) {
            $.ajax({
                url: '<?php echo admin_url("admin-ajax.php"); ?>',
                type: 'POST',
                data: {
                    action: 'email_loginverify_otp',
                    nonce: nonce,
                    email: email,
                    otp: otp
                },
                beforeSend: function() {
                    $('#response-message').text('Verifying OTP...');
                },
                success: function(response) {
                    if (response.success) {
                        $('#response-message').css({
                            'color': 'green',
                            'font-size': '18px'
                        }).text(response.data.message); // Show success message
                        if (redirect_url) {
                            setTimeout(function() {
                                window.location.href =
                                redirect_url; // Redirect to the URL
                            }, 2000); // 2-second delay before redirection
                        } else {
                            // If no redirect URL is found, just close the popup
                            setTimeout(function() {
                                $('#otp-email-popup').fadeOut();
                            }, 2000); // 2-second delay
                        }
                    } else {
                        $('#response-message').css({
                            'color': 'red',
                            'font-size': '18px'
                        }).text(response.data.message); // Show error message
                    }
                },
                error: function() {
                    $('#response-message').css({
                        'color': 'red',
                        'font-size': '18px'
                    }).text('An error occurred. Please try again.');
                }
            });
        } else {
            alert('Please enter the OTP.');
        }
    });

    // Optional: Handle the alternative method link
    $('#try-alternative-method').click(function(e) {
        e.preventDefault();
        // Hide the push notification popup
        $('#push-notification-popup').fadeOut();

        // Show the recovery code popup
        var recoveryPopupHtml =
            '<div id="recovery-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
            '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
            '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
            '<img src="' + brandData.brandLogo +
            '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
            '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
            '</div>' +
            '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;line-height: 1.5;">Please use your one-time recovery code generated at the time of registration to login</h3>' +
            '<form method="POST" action="" class="mt-3" id="recovery-form">' +
            '<div class="mb-4">' +
            '<label class="form-label" style="font-weight: 700;font-size: 16px;margin: 15px;">Enter Recovery Code:</label>' +
            '<input type="text" name="recovery_code" id="recovery_code" class="form-control" style="padding: 6px; width: 25%;" />' +
            '</div>' +
            '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;padding: 15px;">' +
            '<button type="submit" class="btn btn-primary px-4" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Submit</button>' +
            '</div>' +
            '</form>' +
            '<div id="recovery-response-message" style="margin-top: 20px; font-size: 14px; color: #555;"></div>' +
            '</div>' +
            '</div>';
        $('body').append(recoveryPopupHtml);

        // Handle recovery code form submission
        $('#recovery-form').submit(function(e) {
            e.preventDefault();
            var recoveryCode = $('#recovery_code').val();
            var data = {
                action: 'loginverify_recovery_code',
                nonce: '<?php echo wp_create_nonce("loginverify_recovery_code_nonce"); ?>',
                recovery_code: recoveryCode
            };

            $.ajax({
                url: '<?php echo admin_url("admin-ajax.php"); ?>',
                type: 'POST',
                data: data,
                success: function(response) {
                    var messageDiv = $('#recovery-response-message');
                    if (response.success) {
                        messageDiv.html(
                            '<p style="color: green; font-size: 17px;">' +
                            response.data.message + '</p>');
                        if (redirect_url) {
                            setTimeout(function() {
                                window.location.href =
                                redirect_url; // Redirect to the URL
                            }, 2000); // 2-second delay before redirection
                        } else {
                            // If no redirect URL is found, just close the popup
                            setTimeout(function() {
                                $('#recovery-popup').fadeOut();
                            }, 2000); // 2-second delay
                        }
                    } else {
                        messageDiv.html('<p style="color: red; font-size: 17px;">' +
                            response.data.message + '</p>');
                    }
                },
                error: function() {
                    $('#recovery-response-message').html(
                        '<p style="color: red; font-size: 17px;">An error occurred. Please try again.</p>'
                        );
                }
            });
        });
    });
});
</script>
<?php 
            } 
            
            // Check if MFA type is "Security Question"
            if ($shouldShowMenu && $shouldPromptUser && isset($bca_settings['mfaType']) && $result->default_mfa_method == 'securityquestions' && $bca_settings['enforceOn'] != 'noEnforce') {
                // Get the current logged-in user's email
                global $wpdb;
                $user_email = wp_get_current_user()->user_email;
                $table_name = $wpdb->prefix . 'bca_user_security_questions';
                
                // Query to fetch the security question data for the user
                $query = $wpdb->prepare(
                    "SELECT * FROM $table_name WHERE user_email = %s LIMIT 1",
                    $user_email
                );
                $user_security_data = $wpdb->get_row($query);

                // Check if the user has security question data
                if ($user_security_data) {
                    // Randomly select a question (assuming there are 5 questions)
                    $questions = [
                        $user_security_data->question_1,
                        $user_security_data->question_2,
                        $user_security_data->question_3,
                        $user_security_data->question_4,
                        $user_security_data->question_5
                    ];
                    $random_question_index = array_rand($questions);
                    $random_question = $questions[$random_question_index];
                    $correct_answer = $user_security_data->{'answer_' . ($random_question_index + 1)};
                    ?>
<script type="text/javascript">
var brandData = {
    brandName: "<?php echo esc_js($brand_name); ?>",
    brandLogo: "<?php echo esc_url($brand_logo); ?>"
};
jQuery(document).ready(function($) {
    var otpPopupHtml =
        '<div id="otp-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
        '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;line-height: 1.5;">Please answer the security question to proceed</h3>' +
        '<p style="font-size: 18px;">' + '<?php echo $random_question; ?>' + '</p>' +
        '<form method="POST" action="" class="mt-3" id="security-question-form">' +
        '<div class="mb-4 d-md-flex justify-content-between">' +
        '<input type="text" name="security_answer" id="security_answer" class="form-control bg-gray" placeholder="Enter your answer" style="padding: 6px; width: 50%;" />' +
        '</div>' +
        '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;padding: 15px;">' +
        '<button type="submit" class="btn btn-primary px-4" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Verify Answer</button>' +
        '</div>' +
        '</form>' +
        '<div id="security-response-message" style="margin-top: 20px; font-size: 14px; color: #555;"></div>' +
        '<p>have issues? <a href="#" id="try-alternative-method" style="text-decoration: underline; color: #2295f2;font-family: Arial, sans-serif; margin-top: 20px; font-size: 14px;">Use Recovery Code</a></p>' +
        '</div>' +

        
         '<p>If you have lost your recovery code, please contact the administrator.</p>' +
        '</div>' +
        '</div>';
    $('body').append(otpPopupHtml);

    // Handle the form submission via AJAX
    $('#security-question-form').submit(function(e) {
        e.preventDefault(); // Prevent normal form submission
        var answer = $('#security_answer').val();
        var correctAnswer = '<?php echo $correct_answer; ?>'; // The correct answer from PHP
        var userEmail = '<?php echo $user_email; ?>'; // User email from PHP

        if (answer !== '') {
            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: 'POST',
                data: {
                    action: 'verify_security_answer',
                    answer: answer,
                    correct_answer: correctAnswer,
                    user_email: userEmail // Pass the user email here
                },
                success: function(response) {
                    if (response.success) {
                        $('#security-response-message').html(
                            '<div class="alert alert-success" style="color: green; font-size: 17px;">Answer verified successfully!</div>'
                            );
                        if (redirect_url) {
                            setTimeout(function() {
                                window.location.href =
                                redirect_url; // Redirect to the URL
                            }, 2000); // 2-second delay before redirection
                        } else {
                            // If no redirect URL is found, just close the popup
                            setTimeout(function() {
                                $('#otp-popup').fadeOut();
                            }, 2000); // 2-second delay
                        }
                    } else {
                        $('#security-response-message').html(
                            '<div class="alert alert-danger" style="color: red; font-size: 17px;">Invalid answer. Please try again.</div>'
                            );
                    }
                },
                error: function() {
                    $('#security-response-message').html(
                        '<div class="alert alert-danger" style="color: red; font-size: 17px;">An error occurred. Please try again.</div>'
                        );
                }
            });
        } else {
            $('#security-response-message').html(
                '<div class="alert alert-warning" style="color: red; font-size: 17px;">Please enter an answer.</div>'
                );
        }
    });

    // Handle the alternative method link for TOTP
    $('#try-alternative-method').click(function(e) {
        e.preventDefault();
        // Hide the push notification popup
        $('#push-notification-popup').fadeOut();

        // Show the recovery code popup
        var recoveryPopupHtml =
            '<div id="recovery-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
            '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
            '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
            '<img src="' + brandData.brandLogo +
            '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
            '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
            '</div>' +
            '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;line-height: 1.5;">Please use your one-time recovery code generated at the time of registration to login</h3>' +
            '<form method="POST" action="" class="mt-3" id="recovery-form">' +
            '<div class="mb-4">' +
            '<label class="form-label" style="font-weight: 700;font-size: 16px;margin: 15px;">Enter Recovery Code:</label>' +
            '<input type="text" name="recovery_code" id="recovery_code" class="form-control" style="padding: 6px; width: 25%;" />' +
            '</div>' +
            '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;padding: 15px;">' +
            '<button type="submit" class="btn btn-primary px-4" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Submit</button>' +
            '</div>' +
            '</form>' +
            '<div id="recovery-response-message" style="margin-top: 20px; font-size: 14px; color: #555;"></div>' +
            '</div>' +
            '</div>';
        $('body').append(recoveryPopupHtml);

        // Handle recovery code form submission
        $('#recovery-form').submit(function(e) {
            e.preventDefault();
            var recoveryCode = $('#recovery_code').val();
            var data = {
                action: 'loginverify_recovery_code',
                nonce: '<?php echo wp_create_nonce("loginverify_recovery_code_nonce"); ?>',
                recovery_code: recoveryCode
            };

            $.ajax({
                url: '<?php echo admin_url("admin-ajax.php"); ?>',
                type: 'POST',
                data: data,
                success: function(response) {
                    var messageDiv = $('#recovery-response-message');
                    if (response.success) {
                        messageDiv.html(
                            '<p style="color: green; font-size: 17px;">' +
                            response.data.message + '</p>');
                        if (redirect_url) {
                            setTimeout(function() {
                                window.location.href =
                                redirect_url; // Redirect to the URL
                            }, 2000); // 2-second delay before redirection
                        } else {
                            // If no redirect URL is found, just close the popup
                            setTimeout(function() {
                                $('#recovery-popup').fadeOut();
                            }, 2000); // 2-second delay
                        }
                    } else {
                        messageDiv.html('<p style="color: red; font-size: 17px;">' +
                            response.data.message + '</p>');
                    }
                },
                error: function() {
                    $('#recovery-response-message').html(
                        '<p style="color: red; font-size: 17px;">An error occurred. Please try again.</p>'
                        );
                }
            });
        });
    });
});
</script>

<?php
                } else {
                    // Display a message in the popup if security questions are not set up
                    ?>
<script type="text/javascript">
var brandData = {
    brandName: "<?php echo esc_js($brand_name); ?>",
    brandLogo: "<?php echo esc_url($brand_logo); ?>"
};
jQuery(document).ready(function($) {
    var otpPopupHtml =
        '<div id="otp-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
        '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;line-height: 1.5;">You have not updated Answers for Security Questions</h3>' +
        '<p style="font-size: 18px; color: #f39c12;">Please update your security questions in your MFA settings.</p>' +
        '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;padding: 15px;">' +
        // '<button type="button" onclick="window.location.href=\'/account-settings\'" class="btn btn-primary px-4" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer;">Go to Settings</button>' +
        '</div>' +
        '</div>' +
        '</div>';
    $('body').append(otpPopupHtml);
});
</script>
<?php
                }
            }

        }else{
                $bca_settings = get_option('bca_settings');
                $promptSetup = isset($bca_settings['promptSetup']) ? $bca_settings['promptSetup'] : ''; 
                $enforceSetup = isset($bca_settings['enforceSetup']) ? $bca_settings['enforceSetup'] : '';  
                $enforceOn = isset($bca_settings['enforceOn']) ? $bca_settings['enforceOn'] : '';
                $gracePeriodDays = isset($bca_settings['gracePeriodDays']) ? $bca_settings['gracePeriodDays'] : 10;
                $mfaType = isset($bca_settings['mfaType']) ? $bca_settings['mfaType'] : '';
                $gracePeriodAction = isset($bca_settings['gracePeriodAction']) ? $bca_settings['gracePeriodAction'] : ''; 
                $notificationMethod = isset($bca_settings['notificationMethod']) ? $bca_settings['notificationMethod'] : '';
                $userSelection = isset($bca_settings['userSelection']) ? $bca_settings['userSelection'] : '';
                $promptUserSetupRoles = isset($bca_settings['promptusersetuproles']) ? $bca_settings['promptusersetuproles'] : '';
                $selectedRoles = isset($bca_settings['selectedRoles']) ? $bca_settings['selectedRoles'] : '';
                $selectedUsers = isset($bca_settings['selectedUsers']) ? $bca_settings['selectedUsers'] : '';
                $forceUser = isset($result->force_user) ? $result->force_user : '';

                if (!is_array($promptUserSetupRoles)) {
                    $promptUserSetupRoles = array_map('trim', explode(',', $promptUserSetupRoles)); 
                }

                $promptUserSetupRoles = array_map('strtolower', $promptUserSetupRoles);
                $user_roles = wp_get_current_user()->roles;
                $user_roles = array_map('strtolower', $user_roles);

                $current_user = wp_get_current_user();
                $current_user_id = $current_user->ID;

                // check if the user should be prompted role
                $shouldPromptUser = false;

                if ($userSelection === 'specificUser') {
                    if (!empty($promptUserSetupRoles)) {
                        foreach ($user_roles as $role) {
                            if (in_array($role, $promptUserSetupRoles)) {
                                $shouldPromptUser = true;
                                break;
                            }
                        }
                    }
                } else {
                    $shouldPromptUser = true;
                }

                // check if the user enabled for the mfa setup user and role

                $shouldShowMenu = false;
                // Handle enforceOn conditions
                if ($enforceOn === 'allUsers') {
                    $shouldShowMenu = true;
                } elseif ($enforceOn === 'noEnforce') {
                    $shouldShowMenu = false;
                } elseif ($enforceOn === 'selectedUsers') {
                    // Check if the current user has one of the selected roles
                    if (!empty($selectedRoles)) {
                        foreach ($user_roles as $role) {
                            if (in_array($role, $selectedRoles)) {
                                $shouldShowMenu = true;
                                break;
                            }
                        }
                    }

                    // Check if the current user is in the selected users list
                    if (!empty($selectedUsers) && in_array($current_user_id, $selectedUsers)) {
                        $shouldShowMenu = true;
                    }
                } else {
                    // Default case: Check roles or users
                    if (!empty($selectedRoles)) {
                        foreach ($user_roles as $role) {
                            if (in_array($role, $selectedRoles)) {
                                $shouldShowMenu = true;
                                break;
                            }
                        }
                    }

                    // Check if the current user is in the selected users list
                    if (!empty($selectedUsers) && in_array($current_user_id, $selectedUsers)) {
                        $shouldShowMenu = true;
                    }
                }


                // Only display the popup if promptSetup is on
                if ($shouldShowMenu && $shouldPromptUser && $result && $result->qr_status == 'not_scanned' && $promptSetup === 'on' &&  $enforceOn !== 'noEnforce') {
                    
                    // Check if the grace period of 10 days has passed after 'Setup Later'
                    $user_id = get_current_user_id();
                    $setup_later_date = get_user_meta($user_id, '_setup_later_date', true);
                    
                    if ($setup_later_date) {
                        // Calculate the difference between today's date and the stored date
                        $today = current_time('mysql');
                        $date_diff = strtotime($today) - strtotime($setup_later_date);
                        $days_diff = floor($date_diff / (60 * 60 * 24));

                        // if ($days_diff < $gracePeriodDays) {
                        //     return; // Don't show the popup if grace period is not over
                        // }

                        if ($days_diff < $gracePeriodDays && empty($result->user_status) && $result->user_status == 0) { 
                            $update_result = $wpdb->update(
                                "{$wpdb->prefix}bca_api_entries",
                                [
                                    'force_user' => 'canComplete'
                                ],
                                ['user_email' => $user_email]
                            );
                            return; // Don't show the popup if grace period is not over
                        } else if ($days_diff >= $gracePeriodDays && !empty($result->user_status)) {
                            $update_result = $wpdb->update(
                                "{$wpdb->prefix}bca_api_entries",
                                [
                                    'force_user' => 'mustComplete'
                                ],
                                ['user_email' => $user_email]
                            );
                        } else if ($days_diff <= $gracePeriodDays && !empty($result->user_status) && $result->user_status == 'logout') {
                            $update_result = $wpdb->update(
                                "{$wpdb->prefix}bca_api_entries",
                                [
                                    'force_user' => 'canComplete'
                                ],
                                ['user_email' => $user_email]
                            );
                        }
                        
                        if ($days_diff >= $gracePeriodDays && $gracePeriodAction == 'blockUser') {
                    
                            // If MFA is not completed, set the account status to 'inactive'
                            if (empty($result->auth_type) && $result->qr_status == 'not_scanned') {
                                update_user_meta($user_id, 'account_status', 'inactive');
                    
                                // Optionally, you can log the user out or show a message
                                wp_logout();

                                // Redirect the user to the login page
                                wp_redirect(wp_login_url()); 
                                exit; 
                            }
                        }
                    }
    global $wpdb;

     $license_key = null;
    // Fetch license key
$license = $wpdb->get_row(
    "SELECT licence_key FROM {$wpdb->prefix}bca_licence_detail"
);

if ($license && !empty($license->licence_key)) {
    $license_key = $license->licence_key;
} 
     
      
    $current_user = wp_get_current_user();
    $user_email = $current_user->user_email;

    $api_url = 'https://store.baar.ai/api/valiate-freeplan-user';
        $headers = [
            'X-API-KEY' => 'barrmfa-1US2NYn1PkQTRmuswd6jZIFovT4',
            'Content-Type' => 'application/json',
        ];
        $body = json_encode([
            'site_url' => site_url(),
            'email' => $user_email,
            'user_name' => $current_user->user_login,
            'license_key' => $license_key

        ]);

        $response = wp_remote_post($api_url, [
            'method'  => 'POST',
            'headers' => $headers,
            'body'    => $body,
        ]);

        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            echo "API request failed: " . $error_message;
            return;
        }

        $response_body = wp_remote_retrieve_body($response);
        $body = json_decode($response_body, true);
        $free_plan_user_status = $body['status'];
            
                    ?>
    
                    
                    
                    
<script type="text/javascript">
var brandData = {
    brandName: "<?php echo esc_js($brand_name); ?>",
    brandLogo: "<?php echo esc_url($brand_logo); ?>"
   
};
var free_plan_user_status = '<?php echo esc_js($free_plan_user_status); ?>';
jQuery(document).ready(function($) {
    // Show OTP popup with 'Setup Now' and 'Setup Later' buttons
    var setupButtonsHtml = '';

    var enforceSetup = '<?php echo esc_js($enforceSetup); ?>'; // Escape PHP variable for JS use

    var forceUser = '<?php echo esc_js($forceUser); ?>';
    // console.log("enforceSetup value:", enforceSetup); 
    // console.log("forceUser value:", forceUser);

    // if (enforceSetup === 'canComplete') {
    if (forceUser === 'mustComplete' || enforceSetup === 'mustComplete') {
        // Show both buttons (Setup Now and Setup Later)
        setupButtonsHtml =
            '<button id="setup-now" class="button button-primary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">' +
            'Setup Now' +
            '</button>';
        // } else if (enforceSetup === 'mustComplete') {
    } else if (enforceSetup === 'canComplete' && (forceUser === '' || forceUser !== 'mustComplete')) {
        // Show only 'Setup Now' button
        setupButtonsHtml =
            '<button id="setup-now" class="button button-primary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">' +
            'Setup Now' +
            '</button>' +
            '<button id="setup-later" class="button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">' +
            'Setup Later' +
            '</button>';
    }
    var popupHtml ='';
    
//     $status=1;
  if (free_plan_user_status == 1 || free_plan_user_status == 2) {


    var popupHtml =
        '<div id="otp-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
        '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;">MFA has been enabled for your site.</h3>' +
        '<p style="font-size: 20px; text-align: center; margin-bottom: 20px;">Would you like to set up MFA now?</p>' +
        '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;padding: 15px;">' +
        setupButtonsHtml +
        '</div>' +
        '</div>' +
        '</div>';
    $('body').append(popupHtml);

    }

    // Close the first popup and show the second warning popup if 'Setup Later' is clicked
    // $('#setup-later').click(function() {
    //     // AJAX request to update user meta with today's date
    //     $.ajax({
    //         url: '<?php echo admin_url('admin-ajax.php'); ?>',
    //         type: 'POST',
    //         data: {
    //             action: 'update_user_meta_for_later',
    //             user_id: <?php echo get_current_user_id(); ?>,
    //         },
    //         success: function(response) {
    //             if (response.success) {
    //                 $('#otp-popup').remove(); // Close the first popup after saving

    //                 // Now, show the warning popup
    //                 var warningPopupHtml =
    //                     '<div id="warning-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
    //                     '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
    //                     '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
    //                     '<img src="' + brandData.brandLogo +
    //                     '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
    //                     '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData
    //                     .brandName + '</h3>' +
    //                     '</div>' +
    //                     '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px; padding: 10px;">Complete MFA Setup Within <?php echo $gracePeriodDays; ?> Days</h3>' +
    //                     '<p style="font-size: 20px; text-align: center; margin-bottom: 20px;">Please complete your Multi-Factor Authentication (MFA) setup within <?php echo $gracePeriodDays; ?> days, or your account will be blocked.</p>' +
    //                     '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;padding: 15px;">' +
    //                     '<button id="okay-button" class="button button-primary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">' +
    //                     'Okay' +
    //                     '</button>' +
    //                     '</div>' +
    //                     '</div>' +
    //                     '</div>';
    //                 $('body').append(warningPopupHtml);

    //                 // Close the warning popup when 'Okay' button is clicked
    //                 $('#okay-button').click(function() {
    //                     $('#warning-popup').remove(); // Remove the warning popup
    //                 });
    //             } else {
    //                 alert('Failed to save your choice. Please try again.');
    //             }
    //         }
    //     });
    // });

    $('#setup-later').click(function() {
    var notificationMethod = "<?php echo esc_js($notificationMethod); ?>";
    // var notificationMethod = "adminNotice";

    $.ajax({
        url: '<?php echo admin_url('admin-ajax.php'); ?>',
        type: 'POST',
        data: {
            action: 'update_user_meta_for_later',
            user_id: <?php echo get_current_user_id(); ?>,
        },
        success: function(response) {
            if (response.success) {
                $('#otp-popup').remove(); // remove main popup

                if (notificationMethod === 'adminNotice') {
                    // Reload page to show admin notice
                    location.reload();
                } else {
                    // Show warning popup
                    var warningPopupHtml =
                        '<div id="warning-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
                        '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
                        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
                        '<img src="' + brandData.brandLogo + '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
                        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
                        '</div>' +
                        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px;">Complete MFA Setup Within <?php echo $gracePeriodDays; ?> Days</h3>' +
                        '<p style="font-size: 20px;">Please complete your Multi-Factor Authentication (MFA) setup within <?php echo $gracePeriodDays; ?> days, or your account will be blocked.</p>' +
                        '<div style="text-align: center; padding: 15px;">' +
                        '<button id="okay-button" class="button button-primary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Okay</button>' +
                        '</div>' +
                        '</div>' +
                        '</div>';
                    $('body').append(warningPopupHtml);

                    $('#okay-button').click(function() {
                        $('#warning-popup').remove();
                    });
                }
            } else {
                alert('Failed to save your choice. Please try again.');
            }
        }
    });
});


    // Setup Now button functionality
    $('#setup-now').click(function() {
        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>',
            type: 'POST',
            data: {
                action: 'redirect_user_based_on_role',
                user_id: <?php echo get_current_user_id(); ?>,
            },
            success: function(response) {
                if (response.success) {
                    window.location.href = response.data
                    .redirect_url; // Redirect the user based on their role
                } else {
                    alert('Failed to redirect. Please try again.');
                }
            }
        });
    });
});
</script>
<?php
                }elseif ($promptSetup === 'on' && (empty($enforceSetup) || !isset($enforceSetup)) && (empty($enforceOn) || !isset($enforceOn))) { ?>
<script type="text/javascript">
var brandData = {
    brandName: "<?php echo esc_js($brand_name); ?>",
    brandLogo: "<?php echo esc_url($brand_logo); ?>"
};
jQuery(document).ready(function($) {
    var currentStep = 1; // Start with Step 1

    // Function to show the current step and hide others
    function showStep(step) {
        $('.step').hide(); // Hide all steps
        $('#step' + step).show(); // Show the current step
    }

    // Handle next button click
    $(document).on('click', '.next', function() {
        if (currentStep < 5) {
            currentStep++; // Increment step number
            showStep(currentStep); // Show the next step
        }
    });

    // Handle previous button click
    $(document).on('click', '.prev', function() {
        if (currentStep > 1) {
            currentStep--; // Decrement step number
            showStep(currentStep); // Show the previous step
        }
    });

    $(document).on('click', '#final-submit', function() {
        var formData = {
            enforceSetup: $('input[name="enforceSetup"]:checked').val(),
            enforceOn: $('input[name="enforceOn"]:checked').val(),
            mfaType: $('input[name="mfaType"]:checked').val(),
            graceTime: $('input[name="graceTime"]:checked').val(),
            recoveryCodes: $('input[name="recoveryCodes"]:checked').val(),
            promptSetup: 'on',
            gracePeriodDays: 10
        };

        console.log(formData); // Check the data in the console to see if it is populated correctly

        // Send form data via AJAX to save it
        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>',
            type: 'POST',
            data: {
                action: 'save_mfa_settings',
                bca_settings: formData
            },
            success: function(response) {
                console.log(response); // Log the response to see what is returned
                if (response.success) {
                    $('#otp-popup').remove(); // Close the popup after submission
                } else {
                    alert('Error saving settings.');
                }
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error: " + status + ": " + error);
            }
        });
    });

    // Initialize the first step and show it
    showStep(currentStep);

    // Show OTP popup with multi-step form
    var popupHtml =
        '<div id="otp-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
        '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
        '<button id="close-popup" style="position: absolute; top: 10px; right: 10px; background: none; border: none; font-size: 24px; color: black; cursor: pointer;">&times;</button>' +
        // Step 1: Enforce Setup
        '<div class="step" id="step1">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px;">Require MFA Setup</h3>' +
        '<div style="text-align: left;padding: 20px 30px;">' +
        '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="enforceSetup" value="mustComplete"> Force users to set up MFA when they login.</label><br>' +
        '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="enforceSetup" value="canComplete"> Allow users to skip and set it up later from their Profile or Dashboard.</label><br><br>' +
        '</div>' +
        '<div style="text-align: center;">' +
        '<button type="button" class="next button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Next</button>' +
        '</div>' +
        '</div>' +

        // Step 2: Enforce On
        '<div class="step" id="step2" style="display: none;">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px;">Who Needs to Set Up MFA?</h3>' +
        '<div style="text-align: left;padding: 20px 30px;">' +
        '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="enforceOn" value="allUsers"> All Users</label><br>' +
        '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="enforceOn" value="noEnforce"> No One</label><br><br>' +
        '</div>' +
        '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;">' +
        '<button type="button" class="prev button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Previous</button>' +
        '<button type="button" class="next button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Next</button>' +
        '</div>' +
        '</div>' +

        // Step 3: MFA Type
        '<div class="step" id="step3" style="display: none;">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px;">Available MFA Methods</h3>' +
        '<div style="text-align: left;padding: 20px 30px;">' +
        //'<label style="font-size: 18px;line-height: 2;"><input type="radio" name="mfaType" value="pushNotification"> Push Notification via BAAR Auth App</label><br>' +
        '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="mfaType" value="totp"> TOTP via BAAR Auth App</label><br>' +
       // '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="mfaType" value="otpEmail"> OTP via Email</label><br>' +
        // '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="mfaType" value="otpPhone"> OTP via SMS</label><br>' +
        '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="mfaType" value="securityquestions"> Security Questions (KBA)</label><br><br>' +
        '</div>' +
        '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;">' +
        '<button type="button" class="prev button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Previous</button>' +
        '<button type="button" class="next button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Next</button>' +
        '</div>' +
        '</div>' +

        // Step 4: Grace Time
        // '<div class="step" id="step4" style="display: none;">' +
        //     '<h3 style="font-size: 30px; text-align: center; margin-bottom: 20px;">Set up - Grace Time</h3>' +
        //     '<div style="text-align: left;padding: 20px 30px;">' +
        //         '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="graceTime" value="enforceLogin"> Enforce MFA setup on login</label><br>' +
        //         '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="graceTime" value="enforceGrace"> Enforce MFA setup after the grace period</label><br>' +
        //     '</div>' +
        //     '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;">' +
        //         '<button type="button" class="prev button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Previous</button>' +
        //         '<button type="button" class="next button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Next</button>' +
        //     '</div>' +
        // '</div>' +

        // Step 5: Recovery Codes
        '<div class="step" id="step4" style="display: none;">' +
        '<div style="display: flex; align-items: center; justify-content: center; width: 100%;">' +
        '<img src="' + brandData.brandLogo +
        '" alt="Brand Logo" width="50" height="auto" style="margin-top: 0;margin-right: 15px;">' +
        '<h3 style="font-size: 30px; margin-right: 10px;">' + brandData.brandName + '</h3>' +
        '</div>' +
        '<h3 style="font-size: 25px; text-align: center; margin-bottom: 20px;">Enable Recovery Codes</h3>' +
        '<div style="text-align: left;padding: 20px 30px;">' +
        '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="recoveryCodes" value="enableRecoveryCodes"> Enable Recovery Codes</label><br>' +
        '<label style="font-size: 18px;line-height: 2;"><input type="radio" name="recoveryCodes" value="disableRecoveryCodes"> Disable Recovery Codes</label><br><br>' +
        '</div>' +
        '<div style="text-align: center; display: flex; justify-content: center; gap: 10px;">' +
        '<button type="button" class="prev button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Previous</button>' +
        '<button type="button" id="final-submit" class="button button-secondary" style="padding: 8px; background-color: #2295f2; color: #fff; border: none; border-radius: 5px; font-size: 18px; cursor: pointer; width: 25%; margin: 10px;">Submit</button>' +
        '</div>' +
        '</div>' +
        '</div>' +
        '</div>';
    // Append the popup to the body
    $('body').append(popupHtml);

    // Close the popup when close button is clicked
    $('#close-popup').click(function() {
        // Create a custom confirmation popup HTML
        var customConfirmHtml =
            '<div id="custom-confirm-popup" style="display: block; background: rgb(0 0 0 / 88%); position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 9999; text-align: center; overflow: hidden;">' +
            '<div style="background: white; padding: 30px; margin: auto; width: 100%; max-width: 700px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); border-radius: 8px; box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);">' +
            '<h3 style="font-size: 30px; text-align: center; margin-bottom: 20px;">Exit Setup Wizard?</h3>' +
            '<p style="font-size: 18px; text-align: center;">Exiting the setup wizard will restore default settings in the plugin. Are you sure you want to continue?</p>' +
            '<div style="text-align: center; display: flex; justify-content: center; gap: 20px;">' +
            '<button id="confirm-yes" style="padding: 8px 16px; background-color: #f44336; color: white; border: none; border-radius: 5px; font-size: 18px; cursor: pointer;">Yes</button>' +
            '<button id="confirm-no" style="padding: 8px 16px; background-color: #4CAF50; color: white; border: none; border-radius: 5px; font-size: 18px; cursor: pointer;">Cancel</button>' +
            '</div>' +
            '</div>' +
            '</div>';

        // Append the custom confirmation popup to the body
        $('body').append(customConfirmHtml);

        // Handle "Yes" button click
        $('#confirm-yes').click(function() {
            var enforceOnValue = 'allUsers';

            // Send the value to the server via AJAX
            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: 'POST',
                data: {
                    action: 'close_popup_and_save_mfa_settings',
                    enforceOn: enforceOnValue, 
                    bca_settings_nonce: '<?php echo wp_create_nonce('bca_save_settings'); ?>' // Add the nonce for security
                },
                success: function(response) {
                    console.log(response);
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error: " + status + ": " + error);
                }
            });

            // Close the original OTP popup
            $('#otp-popup').remove();

            // Close the custom confirmation popup
            $('#custom-confirm-popup').remove();
        });

        $('#confirm-no').click(function() {
            $('#custom-confirm-popup')
        .remove(); 
        });
    });


});
</script>
<?php }
        }
    }
}
add_action('admin_footer', 'otp_verification_popup_script');

// Hook to handle the AJAX request
add_action('wp_ajax_close_popup_and_save_mfa_settings', 'handle_close_popup_and_save_mfa_settings');
add_action('wp_ajax_nopriv_close_popup_and_save_mfa_settings', 'handle_close_popup_and_save_mfa_settings');

function handle_close_popup_and_save_mfa_settings() {
    if (!isset($_POST['bca_settings_nonce']) || !wp_verify_nonce($_POST['bca_settings_nonce'], 'bca_save_settings')) {
        wp_send_json_error('Nonce verification failed. Please try again.');
    }

    if (isset($_POST['enforceOn'])) {
        // Sanitize the enforceOn value
        $settings['promptSetup'] = 'on';
        $settings['enforceOn'] = 'allUsers';
        $settings['notificationMethod'] = 'userPageNotification';
        $settings['userSelection'] = 'allUsersPrompt';
        $settings['enforceSetup'] = 'canComplete';
        $settings['gracePeriodDays'] = 10;
        $settings['recoveryCodes'] = 'enableRecoveryCodes';
        $settings['mfaMethod'] = 'default';
        $settings['defaultMfa'] = 'totp';

        update_option('bca_settings', $settings);

        wp_send_json_success('Settings saved successfully!');
    } else {
        wp_send_json_error('Error: enforceOn value is missing.');
    }

    wp_die(); 
}


// function show_admin_notice() {
//     global $wpdb;
//     $current_user = wp_get_current_user();
//     $user_id = get_current_user_id();
//     $username = $current_user->user_login;

//     $bca_settings = get_option('bca_settings');
//     $gracePeriodDays = isset($bca_settings['gracePeriodDays']) && is_numeric($bca_settings['gracePeriodDays']) ? (int) $bca_settings['gracePeriodDays'] : 0;
//     $setup_later_date = get_user_meta($user_id, '_setup_later_date', true);
    
//     if ($setup_later_date) {
//         $today = current_time('mysql');
//         $date_diff = strtotime($today) - strtotime($setup_later_date);
//         $days_diff = floor($date_diff / (60 * 60 * 24));

//         $days_left = max(0, $gracePeriodDays - $days_diff);
//     }

//     echo '<div class="notice notice-warning is-dismissible">
//             <p><strong>Attention '.$username.':</strong> Your grace period to configure MFA for this will expire in '. $days_left.' days. Please complete the MFA set up soon.</p>
//           </div>';
// }


function show_admin_notice() {
    $current_user = wp_get_current_user();
    $user_id = $current_user->ID;
    $username = $current_user->user_login;

    $bca_settings = get_option('bca_settings');
    $gracePeriodDays = isset($bca_settings['gracePeriodDays']) ? (int) $bca_settings['gracePeriodDays'] : 0;
    $notificationMethod = isset($bca_settings['notificationMethod']) ? $bca_settings['notificationMethod'] : '';

    $setup_later_date = get_user_meta($user_id, '_setup_later_date', true);
    $days_left = $gracePeriodDays;

    if ($setup_later_date) {
        $today = current_time('mysql');
        $date_diff = strtotime($today) - strtotime($setup_later_date);
        $days_passed = floor($date_diff / (60 * 60 * 24));
        $days_left = max(0, $gracePeriodDays - $days_passed);
    }

    if ($notificationMethod === 'adminNotice') {
        echo '<div class="notice notice-warning is-dismissible">
            <p><strong>Attention ' . esc_html($username) . ':</strong> Your grace period to configure MFA will expire in <strong>' . $days_left . ' days</strong>. Please complete the MFA setup soon.</p>
        </div>';
    }
}

add_action('admin_notices', function () {
    $user_id = get_current_user_id();
        show_admin_notice();
});


// The AJAX handler for saving MFA settings
add_action('wp_ajax_save_mfa_settings', 'save_mfa_settings_callback');
function save_mfa_settings_callback() {
    // Check if 'bca_settings' is in the POST data
    if (isset($_POST['bca_settings'])) {
        $settings = $_POST['bca_settings'];
        $settings['notificationMethod']  = 'userPageNotification';
        $settings['userSelection']  = 'allUsersPrompt';
        $settings['gracePeriodDays'] = 10;
        $settings['mfaMethod'] = 'default';
        $settings['defaultMfa'] = 'totp';
        $settings['enforceSetup'] = isset($settings['enforceSetup']) ? sanitize_text_field($settings['enforceSetup']) : '';
        $settings['enforceOn'] = isset($settings['enforceOn']) ? sanitize_text_field($settings['enforceOn']) : '';
        $settings['mfaType'] = isset($settings['mfaType']) ? sanitize_text_field($settings['mfaType']) : '';
        $settings['graceTime'] = isset($settings['graceTime']) ? sanitize_text_field($settings['graceTime']) : '';
        $settings['gracePeriodDays'] = isset($settings['gracePeriodDays']) ? sanitize_text_field($settings['gracePeriodDays']) : '';
        $settings['recoveryCodes'] = isset($settings['recoveryCodes']) ? sanitize_text_field($settings['recoveryCodes']) : '';
        $settings['promptSetup'] = isset($settings['promptSetup']) ? sanitize_text_field($settings['promptSetup']) : '';
        // Save the sanitized settings in WordPress options table
        update_option('bca_settings', $settings);
        
        // Respond back with a success message
        wp_send_json_success(array('message' => 'Settings saved.'));
    } else {
        // Respond with an error if 'bca_settings' is not set
        wp_send_json_error(array('message' => 'No settings received.'));
    }
}

// Update user meta when clicking 'Setup Later'
function update_user_meta_for_later() {
    global $wpdb;
    $current_user = wp_get_current_user();
    $user_email = $current_user->user_email;
    
    if (!is_user_logged_in()) {
        wp_send_json_error(['message' => 'User is not logged in.']);
    }

    $user_id = $_POST['user_id'];
    if (!$user_id) {
        wp_send_json_error(['message' => 'User ID is missing.']);
    }

    $update_result = $wpdb->update(
        "{$wpdb->prefix}bca_api_entries",
        [
            'user_status' => 'login'
        ],
        ['user_email' => $user_email]
    );


    // Update user meta with today's date
    $today = current_time('mysql');
    update_user_meta($user_id, '_setup_later_date', $today);

    wp_send_json_success(['message' => 'User meta updated successfully.']);
}
add_action('wp_ajax_update_user_meta_for_later', 'update_user_meta_for_later');

// AJAX handler for 'Setup Now' to redirect based on user role
function redirect_user_based_on_role() {
    if (!is_user_logged_in()) {
        wp_send_json_error(['message' => 'User is not logged in.']);
    }

    $user_id = $_POST['user_id'];
    if (!$user_id) {
        wp_send_json_error(['message' => 'User ID is missing.']);
    }

    $user = get_userdata($user_id);
    $user_role = $user->roles[0];  // Get the user's primary role
    $redirect_url = '';

    if ($user_role == 'administrator') {
        $redirect_url = admin_url('admin.php?page=baar-connect-auth&tab=mfa');
    } elseif ($user_role == 'editor' || $user_role == 'subscriber' || $user_role == 'contributor' || $user_role == 'author') {
        $redirect_url = admin_url('admin.php?page=baar-connect-mfa');
    } else {
        $redirect_url = admin_url();
    }

    wp_send_json_success(['redirect_url' => $redirect_url]);
}
add_action('wp_ajax_redirect_user_based_on_role', 'redirect_user_based_on_role');


// login ajax functionality
function loginTOTP_verify() {
    global $wpdb;
    
    // Get the current user's email
    $current_user = wp_get_current_user();
    $user_email = $current_user->user_email;

    // Query to get data related to the user
    $query = $wpdb->prepare(
        "SELECT m.tenant_name, m.api_key, e.qr_code, e.qr_status
        FROM {$wpdb->prefix}bca_master m
        JOIN {$wpdb->prefix}bca_api_entries e ON m.tenant_name = e.tenant_name
        WHERE e.user_email = %s",
        $user_email
    );

    $result = $wpdb->get_results($query);

    // If no result found
    if (empty($result)) {
        wp_send_json_error(['status' => 'error', 'message' => 'No data found for the given email.']);
        return;
    }

    // Extract values from the result
    $tenant = $result[0]->tenant_name;
    $api_key = $result[0]->api_key;
    $qr_code = $result[0]->qr_code;
    $qr_status = $result[0]->qr_status;

    // Get the OTP code passed via AJAX
    $otp_code = isset($_POST['otp_code']) ? sanitize_text_field($_POST['otp_code']) : '';

    // Check if OTP is empty
    if (empty($otp_code)) {
        wp_send_json_error(['status' => 'error', 'message' => 'TOTP is missing.']);
        return;
    }

    // Prepare API request to validate OTP
    $api_url = 'https://pushnotifications.baariga.com/api/v1/push-notify/validate-totp';
    $headers = [
        'tanant' => $tenant,
        'ID' => $api_key,
        'Content-Type' => 'application/json',
    ];
    
    $data = [
        'userId' => $user_email,
        'totpCode' => $otp_code
    ];

    // Send the API request using wp_remote_post
    $response = wp_remote_post($api_url, [
        'headers' => $headers,
        'body' => json_encode($data),
    ]);

    // Check for errors in the request
    if (is_wp_error($response)) {
        wp_send_json_error(['status' => 'error', 'message' => 'Error making the API request.']);
        return;
    }

    // Get the response body
    $response_body = wp_remote_retrieve_body($response);
    $response_data = json_decode($response_body, true);

    // Validate OTP
    if ($response_data && isset($response_data['status']) && $response_data['status'] === true) {
        // OTP is valid, update the database
        $update_result = $wpdb->update(
            "{$wpdb->prefix}bca_api_entries",
            [
                'TOTP' => $otp_code, 
                'qr_status' => 'scanned',
                'user_status' => 'login',
                'auth_type' => 'TOTP'
            ],
            ['user_email' => $user_email]
        );

        // Return success response
        wp_send_json_success(['status' => 'success', 'message' => 'Successfully authenticated!']);
    } else {
        // Invalid OTP, return error
        wp_send_json_error(['status' => 'error', 'message' => 'Incorrect TOTP. Please try again.']);
    }
}

// Register the AJAX action for both logged-in and non-logged-in users
add_action('wp_ajax_loginTOTP_verify', 'loginTOTP_verify'); // For logged-in users
add_action('wp_ajax_nopriv_loginTOTP_verify', 'loginTOTP_verify'); // For non-logged-in users


// push notification functionality

add_action('wp_ajax_login_push_notification_auth', 'handle_login_push_notification_auth');

function handle_login_push_notification_auth() {
    // Check nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'push_notification_nonce')) {
        wp_send_json_error(['message' => 'Invalid nonce']);
    }

    // Get the dynamic values for tenant, api_key, and user_email
    global $wpdb;
    $current_user = wp_get_current_user();
    $user_email = $current_user->user_email;

    $query = $wpdb->prepare(
        "SELECT m.tenant_name, m.api_key
        FROM {$wpdb->prefix}bca_master m
        JOIN {$wpdb->prefix}bca_api_entries e ON m.tenant_name = e.tenant_name
        WHERE e.user_email = %s",
        $user_email
    );

    $result = $wpdb->get_results($query);

    if (!empty($result)) {
        $tenant = $result[0]->tenant_name;
        $api_key = $result[0]->api_key;
    } else {
        wp_send_json_error(['message' => 'No data found for the given email']);
    }

    // Call the API to send the push notification
    $sendResponse = sendLoginPushNotification($tenant, $api_key, $user_email);

    // Ensure we received a sessionId
    if (isset($sendResponse['sessionId'])) {
        $sessionId = $sendResponse['sessionId'];

        // Loop to check the status every second (up to TTL)
        $ttl = 20;  // Time to live in seconds
        $startTime = time();  // Record the start time

        while ((time() - $startTime) < $ttl) {
            sleep(2);  // Check every second

            // Check the auth response
            $authResponse = checkLoginAuthResponse($sessionId, $tenant, $api_key);

            // If auth response is not 'PENDING', break the loop
            if (isset($authResponse['authResponse']) && $authResponse['authResponse'] != 'PENDING') {
                break;
            }
        }
        // Check the response
        if (isset($authResponse['authResponse'])) {
            // Case handling for success/failure responses
            switch ($authResponse['authResponse']) {
                case 'ACCEPT':
                    // Send success message to the front-end
                    // Now update the database
                    global $wpdb;
                    $current_user = wp_get_current_user();
                    $user_email = $current_user->user_email;

                    // Update the qr_status and user_status fields in the bca_api_entries table
                    $update_result = $wpdb->update(
                        "{$wpdb->prefix}bca_api_entries",  // Table name
                        [
                            'qr_status' => 'scanned',      // New qr_status value
                            'user_status' => 'login',      // New user_status value
                            'auth_type' => 'Push Notification',
                            'pushnotification_config' => 'completed',
                        ],
                        [
                            'user_email' => $user_email    // Where condition: user_email
                        ]
                    );

                    // Check if the update was successful
                    if ($update_result !== false) {
                        // Optionally, log success or add further actions if needed
                        error_log("Database updated successfully for user: $user_email");
                    } else {
                        // Handle error if update failed
                        error_log("Error updating database for user: $user_email");
                    }

                    wp_send_json_success(['message' => 'Authentication successful!']);
                    break;
                case 'REJECT':
                    wp_send_json_error(['message' => 'Authentication rejected. Please try again.']);
                    break;
                case 'TIMEOUT':
                    wp_send_json_error(['message' => 'Timeout: Please try again.']);
                    break;
                case 'PENDING':
                    wp_send_json_error(['message' => 'Timeout: Status still PENDING after 60 seconds. Please try again.']);
                    break;
                default:
                    wp_send_json_error(['message' => 'Unknown response from server.']);
                    break;
            }
        } else {
            wp_send_json_error(['message' => 'Error: No response received from the authentication server.']);
        }

    } else {
        wp_send_json_error(['message' => 'Error: No sessionId received.']);
    }
}

// Function to send the Push Notification to get sessionId
function sendLoginPushNotification($tenant, $api_key, $user_email) {
    $url = 'https://pushnotifications.baariga.com/api/v1/push-notify/send-auth-notification/oauth';

    // Dynamically set headers using the provided $tenant and $api_key
    $headers = [
        'tanant: ' . $tenant,  // Use the dynamic tenant
        'ID: ' . $api_key,     // Use the dynamic API key
        'Content-Type: application/json',
    ];

    // Dynamically set data using the provided $user_email
    $data = [
        "userId" => $user_email,  // Use the dynamic user email
        "ttl" => "20",  // Time to live in seconds
        "location" => "Kolkata, West Bengal",
        "geoLocationLat" => "31.556860",
        "geoLocationLong" => "75.904170",
        "deviceType" => "Mobile",
        "logInDeviceBrowser" => "Chrome",
        "deviceIpAddress" => "192.168.1.5",
        "deviceName" => "iPhone 13",
        "deviceOS" => "iOS",
        "logInInitiationTime" => "05-02-2025 12:00:00",
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Function to check the response of the sent notification
function checkLoginAuthResponse($sessionId, $tenant, $api_key) {
    $url = 'https://pushnotifications.baariga.com/api/v1/push-notify/check-auth-response';

    $headers = [
        'tanant: ' . $tenant,  // Use the dynamic tenant
        'ID: ' . $api_key,     // Use the dynamic API key
        'Content-Type: application/json',
    ];

    $data = [
        "sessionId" => $sessionId,
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}



// recovery code functionality

function handle_loginverify_recovery_code_ajax() {
    global $wpdb;
    
    // Verify the nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'loginverify_recovery_code_nonce')) {
        wp_send_json_error(['message' => 'Invalid nonce']);
    }

    // Get the current user's email
    $current_user = wp_get_current_user();
    if ($current_user->ID == 0) {
        wp_send_json_error(['message' => 'User not logged in']);
    }

    $user_email = $current_user->user_email;
    $recovery_code = sanitize_text_field($_POST['recovery_code']); // Get entered recovery code

    // Check if the entered recovery code is valid
    $table_name = $wpdb->prefix . 'bca_recovery_code';

    // Query to get recovery code data for the user
    $query = $wpdb->prepare(
        "SELECT * 
         FROM {$wpdb->prefix}bca_recovery_code 
         WHERE user_email = %s 
           AND (code_1 = %s 
                OR code_2 = %s 
                OR code_3 = %s 
                OR code_4 = %s 
                OR code_5 = %s) 
           AND recovery_completed = false",
        $user_email, $recovery_code, $recovery_code, $recovery_code, $recovery_code, $recovery_code
    );

    // Get the result, expecting a single row
    $codes = $wpdb->get_row($query);
    // If result is found
    if ($codes) {
        // Check each code to find the matching one that is unverified
        for ($i = 1; $i <= 5; $i++) {
            $code_field = 'code_' . $i;
            $status_field = 'status_' . $i;
            
            // Check if the code matches and hasn't been verified
            if ($codes->$code_field == $recovery_code && $codes->$status_field == false) {
                // Mark this specific code as verified
                $updated = $wpdb->update(
                    $table_name,
                    [$status_field => true],
                    ['user_email' => $user_email, $code_field => $recovery_code]
                );

                if ($updated !== false) {
                    // Update the bca_api_entries table
                    $update_result = $wpdb->update(
                        "{$wpdb->prefix}bca_api_entries",
                        [
                            'qr_status' => 'scanned',
                            'user_status' => 'login',
                            'auth_type' => 'Recovery Code'
                        ],
                        ['user_email' => $user_email]
                    );

                    // Check if the update to bca_api_entries was successful
                    if ($update_result !== false) {
                        wp_send_json_success(['message' => 'Code Verified Successfully!']);
                    } else {
                        // Error updating bca_api_entries
                        error_log('Error updating bca_api_entries: ' . $wpdb->last_error);
                        wp_send_json_error(['message' => 'Error updating user status in API entries.']);
                    }
                } else {
                    // Error in updating verify status in bca_recovery_code
                    error_log('Error updating verify status: ' . $wpdb->last_error);
                    wp_send_json_error(['message' => 'Error updating the recovery code verification.']);
                }
            }
        }
    } else {
        wp_send_json_error(['message' => 'Invalid or already verified recovery code.']);
    }
}

// Hook the function to handle the AJAX request
add_action('wp_ajax_loginverify_recovery_code', 'handle_loginverify_recovery_code_ajax');




// otp via email function 

add_action('wp_ajax_send_loginotp_email', 'send_loginotp_email');
add_action('wp_ajax_nopriv_send_loginotp_email', 'send_loginotp_email');

// function send_loginotp_email() {
//     if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'email_otp_nonce')) {
//         wp_send_json_error(array('message' => 'Nonce verification failed'));
//     }

//     if (isset($_POST['email'])) {
//         $email = sanitize_email($_POST['email']);
        
//         // Generate a random OTP (6-digit number)
//         $otp = rand(100000, 999999);

//         // Save the OTP in session for verification
//         session_start();
//         $_SESSION['otp_email'] = $email;
//         $_SESSION['otp_code'] = $otp;

//         // Send OTP email
//         $subject = 'Your OTP Code';
//         $message = 'Your OTP code is: ' . $otp;
//         $headers = array('Content-Type: text/html; charset=UTF-8');

//         $mail_sent = wp_mail($email, $subject, $message, $headers);
        
//         if ($mail_sent) {
//             wp_send_json_success(array('message' => 'OTP sent successfully.'));
//         } else {
//             wp_send_json_error(array('message' => 'Failed to send OTP.'));
//         }
//     }
//     wp_die();
// }


// Filter to dynamically get the "From" email
// function custom_wp_mail_from($email) {
//     // Retrieve the "From" email from the database (you can change the query as needed)
//     global $wpdb;
//     $template = $wpdb->get_row("SELECT from_email FROM {$wpdb->prefix}bca_email_templates WHERE template_name = '2MFA setup code email' LIMIT 1");
    
//     // Check if a template was found and return the email, otherwise fallback to default
//     if ($template && !empty($template->from_email)) {
//         return $template->from_email; // Return the "From" email from the database
//     }
    
//     // Default value if no email found in the database
//     return 'defaultemail@domain.com'; 
// }
// add_filter('wp_mail_from', 'custom_wp_mail_from');

// Function to replace placeholders with dynamic values
// Function to replace placeholders with dynamic values
// function replace_email_placeholders($content, $user = null, $otp = null) {
//     // Get site URL and site name
//     $site_url = get_site_url();
//     $site_name = get_bloginfo('name');

//     // Get user information if not passed
//     if ($user === null) {
//         $user = wp_get_current_user();
//     }

//     // Replace the placeholders in the content
//     $content = str_replace('{site_url}', $site_url, $content);
//     $content = str_replace('{site_name}', $site_name, $content);
//     $content = str_replace('{user_login_name}', $user->user_login, $content);
//     $content = str_replace('{user_first_name}', $user->user_first_name, $content);
//     $content = str_replace('{user_last_name}', $user->user_last_name, $content);

//     // Replace {login_code} with the OTP code
//     if ($otp) {
//         $content = str_replace('{login_code}', $otp, $content);
//     }

//     return $content;
// }

function replace_email_placeholders($content, $user = null, $otp = null, $codes = null) {
    // Get site URL and site name
    $site_url = get_site_url();
    $site_name = get_bloginfo('name');

    // Get user information if not passed
    if ($user === null) {
        $user = wp_get_current_user();
    }

    // Fetch user meta for first name and last name
    $user_first_name = get_user_meta($user->ID, 'first_name', true);
    $user_last_name = get_user_meta($user->ID, 'last_name', true);

    // Replace the placeholders in the content
    $content = str_replace('{site_url}', $site_url, $content);
    $content = str_replace('{site_name}', $site_name, $content);
    $content = str_replace('{user_login_name}', $user->user_login, $content);
    $content = str_replace('{user_first_name}', $user_first_name, $content); // Replace {user_first_name}
    $content = str_replace('{user_last_name}', $user_last_name, $content); // Replace {user_last_name}

    // Replace {login_code} with the OTP code (if provided)
    if ($otp) {
        $content = str_replace('{login_code}', $otp, $content);
    }

    // Replace {backup_codes} with the recovery codes (if provided)
    if ($codes) {
        $content = str_replace('{backup_codes}', implode(', ', $codes), $content); // Replace {backup_codes} with the recovery codes
    }

    return $content;
}


function send_loginotp_email() {
    // Verify nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'email_otp_nonce')) {
        wp_send_json_error(array('message' => 'Nonce verification failed'));
    }

    if (isset($_POST['email'])) {
        $email = sanitize_email($_POST['email']);
        
        // Generate a random OTP (6-digit number)
        $otp = rand(100000, 999999);

        // Save the OTP in session for verification
        session_start();
        $_SESSION['otp_email'] = $email;
        $_SESSION['otp_code'] = $otp;

        // Query the database for the "2MFA setup code email" template
        global $wpdb;
        $template = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT * FROM {$wpdb->prefix}bca_email_templates WHERE template_name = %s LIMIT 1",
                'One-Time Passcode (OTP) Email' // We're searching for this template name
            )
        );

        if ($template) {
            // Retrieve values from the template
            $subject = $template->email_subject;
            $message = $template->email_message;
            $from_email = $template->from_email;
            $from_name = $template->from_name;
        
            // Optionally, get user info if not passed as a parameter
            $user = wp_get_current_user(); // If you need user information (for logged-in users)
        
            // Replace placeholders in the subject and message body
            $subject = replace_email_placeholders($subject, $user, $otp);
            $message = replace_email_placeholders($message, $user, $otp);
        
            // Set custom email headers
            $headers = array(
                'Content-Type: text/html; charset=UTF-8',
                'From: ' . $from_name . ' <' . $from_email . '>',
                'Reply-To: ' . $from_email, // Optionally set Reply-To header as well
            );
        
            // Send OTP email
            $mail_sent = wp_mail($email, $subject, $message, $headers);
            
            if ($mail_sent) {
                wp_send_json_success(array('message' => 'OTP sent successfully! Email delivery depends on your SMTP setup.'));
            } else {
                wp_send_json_error(array('message' => 'Failed to send OTP.'));
            }
        } else {
            wp_send_json_error(array('message' => 'No active email template found for 2FA setup.'));
        }    
    } else {
        wp_send_json_error(array('message' => 'Email address is required.'));
    }

    wp_die();
}

add_action('wp_ajax_email_loginverify_otp', 'email_loginverify_otp');
add_action('wp_ajax_nopriv_email_loginverify_otp', 'email_loginverify_otp');


function email_loginverify_otp() {
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'email_otp_nonce')) {
        wp_send_json_error(array('message' => 'Nonce verification failed'));
    }

    if (isset($_POST['email']) && isset($_POST['otp'])) {
        session_start();
        global $wpdb;
        $user_email = sanitize_email($_POST['email']);
        $otp = sanitize_text_field($_POST['otp']);

        // Check if the entered OTP matches the one saved in the session
        if (isset($_SESSION['otp_code']) && $_SESSION['otp_email'] == $user_email && $_SESSION['otp_code'] == $otp) {
            $update_result = $wpdb->update(
                "{$wpdb->prefix}bca_api_entries",
                [
                    'email_otp' => $otp, 
                    'qr_status' => 'scanned',
                    'user_status' => 'login',
                    'auth_type' => 'OTP via Email',
                    'otpEmail_config' => 'completed',
                ],
                ['user_email' => $user_email]
            );
            wp_send_json_success(array('message' => 'OTP verified successfully.'));
        } else {
            wp_send_json_error(array('message' => 'Invalid OTP.'));
        }
    }
    wp_die();
}


// Security question 

add_action('wp_ajax_verify_security_answer', 'verify_security_answer_callback');
function verify_security_answer_callback() {
    if (isset($_POST['answer'], $_POST['correct_answer'], $_POST['user_email'])) {
        $user_answer = sanitize_text_field($_POST['answer']);
        $correct_answer = sanitize_text_field($_POST['correct_answer']);
        $user_email = sanitize_email($_POST['user_email']);

        // Check if the answer is correct
        if (strcasecmp($user_answer, $correct_answer) === 0) {
            global $wpdb;

            // Update the record
            $update_result = $wpdb->update(
                "{$wpdb->prefix}bca_api_entries",
                [
                    'qr_status' => 'scanned',
                    'user_status' => 'login',
                    'auth_type' => 'Security Question'
                ],
                ['user_email' => $user_email]
            );

            // Check if the update was successful
            if ($update_result !== false) {
                wp_send_json_success(array('message' => 'Answer verified successfully and record updated.'));
            } else {
                wp_send_json_error(array('message' => 'Failed to update the record.'));
            }
        } else {
            // If the answer is incorrect
            wp_send_json_error(array('message' => 'Incorrect answer. Please try again.'));
        }
    } else {
        wp_send_json_error(array('message' => 'Missing required data.'));
    }

    wp_die(); // Terminate the AJAX request
}




// Ensure no output is sent prematurely
ob_end_flush();
?>