<?php
class bca_Settings {
    public static function render_tab() {
        global $wpdb; 
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bca_settings'])) {    
            // Verify nonce
            if (!isset($_POST['bca_settings_nonce']) || !wp_verify_nonce($_POST['bca_settings_nonce'], 'bca_save_settings')) {
                echo '<div class="alert alert-danger">Nonce verification failed. Please try again.</div>';
                return;
            }

            // Sanitize and save form data
            $settings = $_POST['bca_settings'];

            // Sanitize each input field
            $settings['promptSetup'] = 'on'; // Ensure promptSetup is either 'on' or 'off'
            $settings['enforceSetup'] = isset($settings['enforceSetup']) ? sanitize_text_field($settings['enforceSetup']) : '';
            $settings['enforceOn'] = isset($settings['enforceOn']) ? sanitize_text_field($settings['enforceOn']) : '';
            $settings['userSelection'] = isset($settings['userSelection']) ? sanitize_text_field($settings['userSelection']) : '';
            $settings['mfaType'] = isset($settings['mfaType']) ? sanitize_text_field($settings['mfaType']) : '';
            // $settings['authenticatorApp'] = isset($settings['authenticatorApp']) ? sanitize_text_field($settings['authenticatorApp']) : '';
            $settings['graceTime'] = isset($settings['graceTime']) ? sanitize_text_field($settings['graceTime']) : '';
            $settings['gracePeriodAction'] = isset($settings['gracePeriodAction']) ? sanitize_text_field($settings['gracePeriodAction']) : '';
            $settings['notificationMethod'] = isset($settings['notificationMethod']) ? sanitize_text_field($settings['notificationMethod']) : '';
            // $settings['redirectAfterMFA'] = isset($settings['redirectAfterMFA']) ? sanitize_text_field($settings['redirectAfterMFA']) : '';
            // $settings['redirectUser'] = isset($settings['redirectUser']) ? sanitize_text_field($settings['redirectUser']) : '';
            $settings['allowDisableMFA'] = isset($settings['allowDisableMFA']) ? sanitize_text_field($settings['allowDisableMFA']) : '';
            $settings['allowPreferredMFA'] = isset($settings['allowPreferredMFA']) ? sanitize_text_field($settings['allowPreferredMFA']) : '';
            $settings['recoveryCodes'] = isset($settings['recoveryCodes']) ? sanitize_text_field($settings['recoveryCodes']) : '';
            $settings['allowedIps'] = isset($settings['allowedIps']) ? sanitize_text_field($settings['allowedIps']) : '';

            // Role based redirect code 
            $settings['redirectAfterMFA'] = isset($settings['redirectAfterMFA']) ? sanitize_text_field($settings['redirectAfterMFA']) : '';
            $settings['redirectUser'] = isset($settings['redirectUser']) ? sanitize_text_field($settings['redirectUser']) : '';

            // Sanitizing and saving role-based redirect links
            if (isset($_POST['bca_settings']['roleRedirects']) && is_array($_POST['bca_settings']['roleRedirects'])) {
                $roleRedirects = [];
            
                foreach ($_POST['bca_settings']['roleRedirects'] as $index => $data) {
                    // Ensure that both role and link are sanitized
                    $role = isset($data['role']) ? sanitize_text_field($data['role']) : '';
                    $link = isset($data['link']) ? sanitize_text_field($data['link']) : '';
            
                    // Only add the role/link pair if both are non-empty
                    if (!empty($role) && !empty($link)) {
                        $roleRedirects[$role] = $link;
                    }
                }
            
                // Save the role redirects if they are not empty
                if (!empty($roleRedirects)) {
                    $settings['roleRedirects'] = $roleRedirects;
                } else {
                    unset($settings['roleRedirects']);
                }
            
                // Save the updated settings to the database
                update_option('bca_settings', $settings);
            }   
            
            
            // Save the selected MFA method for users (either 'default' or 'role')
            $settings['mfaMethod'] = isset($settings['mfaMethod']) ? sanitize_text_field($settings['mfaMethod']) : '';

            // Check if the "Default MFA method for all users" is selected
            if ($settings['mfaMethod'] === 'default') {
                // Save the selected default MFA method
                $settings['defaultMfa'] = isset($settings['defaultMfa']) ? sanitize_text_field($settings['defaultMfa']) : '';
            } else {
                // Ensure no default MFA is set if "role" is selected
                unset($settings['defaultMfa']);
            }

            // Check if "Assign different MFA methods based on role" is selected and process role-based MFA
            if ($settings['mfaMethod'] === 'role' && isset($settings['roleMfaMethods']) && is_array($settings['roleMfaMethods'])) {
                $roleMfaMethods = [];

                // Loop through each role and MFA type pair
                foreach ($settings['roleMfaMethods'] as $index => $data) {
                    // Ensure that both role and MFA type are sanitized
                    $role = isset($data['role']) ? sanitize_text_field($data['role']) : '';
                    $mfaType = isset($data['mfaType']) ? sanitize_text_field($data['mfaType']) : '';

                    // Only add the role/mfaType pair if both are non-empty
                    if (!empty($role) && !empty($mfaType)) {
                        $roleMfaMethods[$role] = $mfaType;
                    }
                }

                // Add default MFA type (TOTP) for any role not explicitly assigned an MFA method
                global $wp_roles;
                $roles = $wp_roles->get_names();
                foreach ($roles as $role_key => $role_name) {
                    // If role doesn't have a specific MFA method set, default to 'totp'
                    if (!isset($roleMfaMethods[$role_key])) {
                        $roleMfaMethods[$role_key] = 'totp';
                    }
                }

                // Save the role-specific MFA methods if they are not empty
                if (!empty($roleMfaMethods)) {
                    $settings['roleMfaMethods'] = $roleMfaMethods;
                } else {
                    unset($settings['roleMfaMethods']);
                }
            }


            // Sanitize selected users and roles (they could be arrays)
            if (isset($settings['selectedUsers']) && is_array($settings['selectedUsers'])) {
                $settings['selectedUsers'] = array_map('intval', $settings['selectedUsers']);
            }

            if (isset($settings['selectedRoles']) && is_array($settings['selectedRoles'])) {
                $settings['selectedRoles'] = array_map('sanitize_text_field', $settings['selectedRoles']);
            }

            // Sanitize promptusersetuproles (store role names instead of role keys)
            if (isset($settings['promptusersetuproles']) && is_array($settings['promptusersetuproles'])) {
                // Get all the editable roles
                $all_roles = get_editable_roles();
                
                // Sanitize and store role names
                $settings['promptusersetuproles'] = array_map(function($role_key) use ($all_roles) {
                    return isset($all_roles[$role_key]) ? $all_roles[$role_key]['name'] : '';
                }, $settings['promptusersetuproles']);
            }

            // Sanitize arrays (if any)
            if (isset($settings['users']) && is_array($settings['users'])) {
                $settings['users'] = array_map('intval', $settings['users']);
            }

            if (isset($settings['checkboxes']) && is_array($settings['checkboxes'])) {
                $settings['checkboxes'] = array_map('sanitize_text_field', $settings['checkboxes']);
            }

            // Save the settings using update_option
            update_option('bca_settings', $settings);
            echo '<div class="alert alert-success">Settings saved successfully.</div>';

            // global $wpdb;

            // Check if the 'mfaType' setting is set and not empty
            if (isset($settings['mfaType']) && !empty($settings['mfaType'])) {
                $update_result = $wpdb->query(
                    $wpdb->prepare(
                        "UPDATE {$wpdb->prefix}bca_api_entries
                        SET default_mfa_method = %s",
                        $settings['mfaType']
                    )
                );
            } else {
                //echo 'mfaType is not set or is empty.';
            }


            // Check if the "Default MFA method for all users" is selected
            if ($settings['mfaMethod'] === 'default') {
                // Save the selected default MFA method for all users
                $settings['defaultMfa'] = isset($settings['defaultMfa']) ? sanitize_text_field($settings['defaultMfa']) : '';

                // If the default MFA method is set, update all users
                if (!empty($settings['defaultMfa'])) {
                    $update_result = $wpdb->query(
                        $wpdb->prepare(
                            "UPDATE {$wpdb->prefix}bca_api_entries
                            SET default_mfa_method = %s",
                            $settings['defaultMfa']
                        )
                    );

                    if ($update_result === false) {
                        echo 'Error updating MFA type for all users.';
                    } else {
                        // echo 'MFA type updated for all users.';
                    }
                } else {
                    echo 'Default MFA method is not set or is empty.';
                }
            } elseif ($settings['mfaMethod'] === 'role' && isset($settings['roleMfaMethods']) && is_array($settings['roleMfaMethods'])) {
                // If "role" MFA method is selected, update based on user roles
                $roleMfaMethods = $settings['roleMfaMethods'];

                // Ensure that any unselected roles default to 'totp' (TOTP via BAAR Auth App)
                global $wp_roles;
                $roles = $wp_roles->get_names();
                foreach ($roles as $role_key => $role_name) {
                    if (!isset($roleMfaMethods[$role_key])) {
                        // Set default MFA for unassigned roles to TOTP
                        $roleMfaMethods[$role_key] = 'totp';
                    }
                }

                // Fetch all user emails from the wp_bca_api_entries table
                $users = $wpdb->get_results("SELECT user_email FROM {$wpdb->prefix}bca_api_entries");

                // Loop through each user and apply MFA method based on their role
                foreach ($users as $user) {
                    // Assuming you have a function to get roles based on the email
                    $userRoles = get_user_roles_by_email($user->user_email); // Using user_email here
                    $updated = false;

                    // Loop through each role and apply corresponding MFA type if defined
                    foreach ($userRoles as $role) {
                        if (isset($roleMfaMethods[$role])) {
                            $roleMfaType = $roleMfaMethods[$role];

                            // Update the user's MFA method based on their role
                            $update_result = $wpdb->query(
                                $wpdb->prepare(
                                    "UPDATE {$wpdb->prefix}bca_api_entries
                                    SET default_mfa_method = %s
                                    WHERE user_email = %s",  // Correct field: user_email
                                    $roleMfaType, $user->user_email  // Correct field: user_email
                                )
                            );

                            // if ($update_result === false) {
                            //     echo "Error updating MFA type for user: {$user->user_email}.";
                            // } else {
                            //     echo "MFA type updated for user: {$user->user_email}.";
                            // }
                            $updated = true;
                            break;
                        }
                    }
                    // If no specific role is assigned an MFA type, use default (e.g., 'totp')
                    if (!$updated && isset($settings['defaultMfa'])) {
                        $defaultMfaType = $settings['defaultMfa'];

                        $update_result = $wpdb->query(
                            $wpdb->prepare(
                                "UPDATE {$wpdb->prefix}bca_api_entries
                                SET default_mfa_method = %s
                                WHERE user_email = %s",
                                $defaultMfaType, $user->user_email
                            )
                        );

                        if ($update_result === false) {
                            error_log("Error setting default MFA type for user: {$user->user_email}");
                        } else {
                            error_log("Default MFA type set for user: {$user->user_email}");
                        }
                    }
                }
            }
            
        }

        // Retrieve saved settings using get_option
        $settings = get_option('bca_settings', []);

        // Use isset() to check each setting before rendering or using
        // $promptSetup = isset($settings['promptSetup']) ? $settings['promptSetup'] : 'on'; // Default to 'on' if not set
        $enforceOn = isset($settings['enforceOn']) ? $settings['enforceOn'] : '';
        $userSelection = isset($settings['userSelection']) ? $settings['userSelection'] : '';
        $mfaType = isset($settings['mfaType']) ? $settings['mfaType'] : '';
        $graceTime = isset($settings['graceTime']) ? $settings['graceTime'] : '';
        $gracePeriodAction = isset($settings['gracePeriodAction']) ? $settings['gracePeriodAction'] : '';
        $notificationMethod = isset($settings['notificationMethod']) ? $settings['notificationMethod'] : '';
        $allowDisable2FA = isset($settings['allowDisable2FA']) ? $settings['allowDisable2FA'] : '';
        $redirectUser = isset($settings['redirectUser']) ? $settings['redirectUser'] : '';
        $recoveryCodes = isset($settings['recoveryCodes']) ? $settings['recoveryCodes'] : '';
        //$roles = isset($settings['roles']) && is_array($settings['roles']) ? $settings['roles'] : []; // Initialize as empty array if not set
        $roles = isset($settings['promptusersetuproles']) && is_array($settings['promptusersetuproles']) ? $settings['promptusersetuproles'] : []; // Initialize as empty array if not set
        // Include the settings template to render the form with saved values
        include BCA_PLUGIN_PATH . 'templates/settings-tab.php';
    }
}

function get_user_roles_by_email($email) {
    $user = get_user_by('email', $email); // Get the user object based on email
    if ($user) {
        return $user->roles; // Returns an array of the user's roles
    }
    return []; // Return an empty array if user is not found
}


?>
