<?php
class BCA_Mfa
{

    public static function render_tab()
    {
        global $wpdb;
        $current_user = wp_get_current_user();
        // Prepare and run the query
        $query = $wpdb->prepare("SELECT * FROM {$wpdb->prefix}bca_master");
        $result = $wpdb->get_row($query);

        // Check if the result is not empty and retrieve data
        if (!empty($result)) {
            $tenant_name = $result->tenant_name;
            $api_key = $result->api_key;
            $user_email = $current_user->user_email;
        } else {
            // Handle case when no result is returned
            $tenant_name = '';
            $api_key = '';
            $user_email = '';
        }
        // Render the MFA settings page template
        include BCA_PLUGIN_PATH . 'templates/mfa-tab.php';
    }
}

function handle_configure_authenticator() {
    
    global $wpdb;
    $current_user = wp_get_current_user();
    $user_email = $current_user->user_email;


    $license_data = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}bca_licence_detail LIMIT 1");

    $plan_type = 'free'; // Default to free if no license found
     

    if ($license_data && !empty($license_data->licence_key)) {
        $license_key = $license_data->licence_key;

       

        // 4. Validate License from Your Remote API
        $api_url = 'https://store.baar.ai/api/validate-license-features';
        $headers = [
            'X-API-KEY' => 'barrmfa-1US2NYn1PkQTRmuswd6jZIFovT4',
            'Content-Type' => 'application/json',
        ];
        $body = json_encode([
            'license_key' => $license_key,
            'site_url' => site_url(),
        ]);

        $response = wp_remote_post($api_url, [
            'method'  => 'POST',
            'headers' => $headers,
            'body'    => $body,
        ]);
       

        if (is_wp_error($response)) {
            wp_send_json_error(['message' => 'License validation failed']);
            return;
        }

        $response_body = json_decode(wp_remote_retrieve_body($response), true);

        if ($response_body['status'] == 1) {
            $plan_type = strtolower($response_body['data']['plan']);

            // Optional: You can also validate expiry here
            $expiry = $response_body['data']['expiry_date'];
            if (strtotime($expiry) < time()) {
                wp_send_json_error(['message' => 'License expired']);
                return;
            }
        }
    }

    // 5. Handle Free Plan Limitations
if ($plan_type === 'free') {
    // Check if current user already has a record with QR code
    $existing_user_with_qr = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) 
         FROM {$wpdb->prefix}bca_api_entries 
         WHERE user_email = %s AND qr_code IS NOT NULL AND qr_code != ''",
        $user_email
    ));

    if (!$existing_user_with_qr) {
        // Count total users with QR codes already generated (excluding empty/null)
        $free_user_count = $wpdb->get_var("
            SELECT COUNT(*) 
            FROM {$wpdb->prefix}bca_api_entries 
            WHERE qr_code IS NOT NULL AND qr_code != ''
        ");

        if ($free_user_count >= 5) {
            wp_send_json_error(['message' => 'Free plan limit reached (max 5 users)']);
            return;
        }
    }
}


    $query = $wpdb->prepare(
        "SELECT m.tenant_name, m.api_key, e.qr_code, e.qr_status
        FROM {$wpdb->prefix}bca_master m
        JOIN {$wpdb->prefix}bca_api_entries e ON m.tenant_name = e.tenant_name
        WHERE e.user_email = %s",
        $user_email
    );

    $result = $wpdb->get_results($query);

    if (!empty($result)) {
        $tenant = $result[0]->tenant_name;
        $api_key = $result[0]->api_key;
        $qr_code = $result[0]->qr_code;
        $qr_status = $result[0]->qr_status;
    } else {
        wp_send_json_error(['status' => 'error', 'message' => 'No data found for the logged user.']);
        return;
    }

    if ($qr_status == 'not_scanned' && !empty($result)) {
        $tenant = $result[0]->tenant_name;
        $api_key = $result[0]->api_key;
        $user_email = $current_user->user_email;

        $url = 'https://pushnotifications.baariga.com/api/v1/push-notify/generate-qr-phone';

        $headers = [
            'tanant: ' . $tenant,
            'ID: ' . $api_key,
            'Content-Type: application/json'
        ];

        $data = json_encode(['user_id' => $user_email]);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            wp_send_json_error(array('message' => 'cURL error: ' . $error));
            return;
        }

        $response_data = json_decode($response, true);

        if (isset($response_data['error'])) {
            echo 'API Error: ' . $response_data['error'];
            return;
        }

        if ($response_data && isset($response_data['code']) && !empty($response_data['code'])) {

            $update_result = $wpdb->update(
                "{$wpdb->prefix}bca_api_entries",
                [
                    'qr_code' => $response_data['code']
                ],
                ['user_email' => $user_email]

            );
            
           

            $upload_dir = BCA_PLUGIN_PATH . 'assets/images/qr-codes/';

            if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0755, true); 
            }

            $filename = $upload_dir . $current_user->user_login . '_' . $current_user->ID . '_wp.png';

            QRcode::png($response_data['code'], $filename);

            $file_url = BCA_PLUGIN_URL . 'assets/images/qr-codes/' . $current_user->user_login . '_' . $current_user->ID . '_wp.png';

            wp_send_json_success(['qr_code_data' => $file_url]);
            return;
        }
    } else {
        wp_send_json_success(['qr_code_data' => 'scanned']);
        return;
    }
    wp_die();
}

add_action('wp_ajax_configure_authenticator', 'handle_configure_authenticator');
add_action('wp_ajax_nopriv_configure_authenticator', 'handle_configure_authenticator');

function bca_verify_totp_function() {
    global $wpdb;
    
    $current_user = wp_get_current_user();
    $user_email = $current_user->user_email;

    $query = $wpdb->prepare(
        "SELECT m.tenant_name, m.api_key, e.qr_code, e.qr_status
        FROM {$wpdb->prefix}bca_master m
        JOIN {$wpdb->prefix}bca_api_entries e ON m.tenant_name = e.tenant_name
        WHERE e.user_email = %s",
        $user_email
    );

    $result = $wpdb->get_results($query);

    if (!empty($result)) {
        $tenant = $result[0]->tenant_name;
        $api_key = $result[0]->api_key;
        $qr_code = $result[0]->qr_code;
        $qr_status = $result[0]->qr_status;
    } else {
        echo "No data found for the given email.";
        return;
    }

    // Get the values passed via AJAX
    $otp_code = isset($_POST['otp_code']) ? sanitize_text_field($_POST['otp_code']) : '';

    // Check if the OTP and user email are provided
    if (empty($otp_code)) {
        wp_send_json_error(['status' => 'error', 'message' => 'TOTP is missing.']);
        return;
    }

    $tenant = $result[0]->tenant_name;
    $api_key = $result[0]->api_key;
    $user_email = $current_user->user_email;

    // Prepare the API request to validate OTP
    $api_url = 'https://pushnotifications.baariga.com/api/v1/push-notify/validate-totp';
    $headers = [
        'tanant' => $tenant,
        'ID' => $api_key,
        'Content-Type' => 'application/json',
    ];
    
    $data = [
        'userId' => $user_email,
        'totpCode' => $otp_code
    ];

    // Use wp_remote_post() to send the API request
    $response = wp_remote_post($api_url, [
        'headers' => $headers,
        'body' => json_encode($data),
    ]);

    if (is_wp_error($response)) {
        wp_send_json_error(['status' => 'error', 'message' => 'Error making the API request.']);
        return;
    }

    // Get the response body
    $response_body = wp_remote_retrieve_body($response);
    $response_data = json_decode($response_body, true);

    if ($response_data && isset($response_data['status']) && $response_data['status'] === true) {
        // OTP is valid, update the database
        $update_result = $wpdb->update(
            "{$wpdb->prefix}bca_api_entries",
            [
                'TOTP' => $otp_code, 
                'qr_status' => 'scanned',
                'totp_config' => 'completed',
            ],
            ['user_email' => $user_email]
        );


         $api_url = 'https://store.baar.ai/api/register_user';
            $headers = [
            'X-API-KEY' => 'barrmfa-1US2NYn1PkQTRmuswd6jZIFovT4',
            'Content-Type' => 'application/json',
        ];
        $body = json_encode([
            'site_url' => site_url(),
            'email' => $user_email,
            'user_name' => $current_user->user_login,

        ]);

        $response = wp_remote_post($api_url, [
            'method'  => 'POST',
            'headers' => $headers,
            'body'    => $body,
        ]);




        // Return success response
        wp_send_json_success(['status' => 'success', 'message' => 'Successfully authenticated!']);
    } else {
        // Invalid OTP, return error
        wp_send_json_error(['status' => 'error', 'message' => 'Incorrect OTP. Please try again.']);
    }
}

add_action('wp_ajax_verify_totp', 'bca_verify_totp_function'); // For logged-in users
add_action('wp_ajax_nopriv_verify_totp', 'bca_verify_totp_function'); // For non-logged-in users



// generate QR code 

// Handle the AJAX request to generate the QR code
function generate_qr_code() {
    // 1. Nonce Verification for Security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'generate_qr_nonce')) {
        wp_send_json_error(['message' => 'Invalid nonce']);
        return;
    }

    global $wpdb;

    // 2. Get Current Logged-in User
    $current_user = wp_get_current_user();
    if (!$current_user->ID) {
        wp_send_json_error(['message' => 'User is not logged in']);
        return;
    }

    $user_email = $current_user->user_email;

    // 3. Check if License Key Exists in Your Local DB
    $license_data = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}bca_licence_detail LIMIT 1");

    $plan_type = 'free'; // Default to free if no license found
     

    if ($license_data && !empty($license_data->licence_key)) {
        $license_key = $license_data->licence_key;

       

        // 4. Validate License from Your Remote API
        $api_url = 'https://store.baar.ai/api/validate-license-features';
        $headers = [
            'X-API-KEY' => 'barrmfa-1US2NYn1PkQTRmuswd6jZIFovT4',
            'Content-Type' => 'application/json',
        ];
        $body = json_encode([
            'license_key' => $license_key,
            'site_url' => site_url(),
        ]);

        $response = wp_remote_post($api_url, [
            'method'  => 'POST',
            'headers' => $headers,
            'body'    => $body,
        ]);
       

        if (is_wp_error($response)) {
            wp_send_json_error(['message' => 'License validation failed']);
            return;
        }

        $response_body = json_decode(wp_remote_retrieve_body($response), true);

        if ($response_body['status'] == 1) {
            $plan_type = strtolower($response_body['data']['plan']);

            // Optional: You can also validate expiry here
            $expiry = $response_body['data']['expiry_date'];
            if (strtotime($expiry) < time()) {
                wp_send_json_error(['message' => 'License expired']);
                return;
            }
        }
    }

    // 5. Handle Free Plan Limitations
if ($plan_type === 'free') {
    // Check if current user already has a record with QR code
    $existing_user_with_qr = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) 
         FROM {$wpdb->prefix}bca_api_entries 
         WHERE user_email = %s AND qr_code IS NOT NULL AND qr_code != ''",
        $user_email
    ));

    if (!$existing_user_with_qr) {
        // Count total users with QR codes already generated (excluding empty/null)
        $free_user_count = $wpdb->get_var("
            SELECT COUNT(*) 
            FROM {$wpdb->prefix}bca_api_entries 
            WHERE qr_code IS NOT NULL AND qr_code != ''
        ");

        if ($free_user_count >= 5) {
            wp_send_json_error(['message' => 'Free plan limit reached (max 5 users)']);
            return;
        }
    }
}

    // 6. Get Tenant and API Key Info
    $config = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}bca_master LIMIT 1");
    if (!$config) {
        wp_send_json_error(['message' => 'Tenant/API Key not configured']);
        return;
    }

    $tenant = $config->tenant_name;
    $api_key = $config->api_key;

    // 7. Call External API to Generate QR Code
    $qr_api_url = 'https://pushnotifications.baariga.com/api/v1/push-notify/generate-qr-phone';
    $qr_headers = [
        'tanant: ' . $tenant,
        'ID: ' . $api_key,
        'Content-Type: application/json',
    ];
    $qr_body = json_encode(['user_id' => $user_email]);

    $ch = curl_init($qr_api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $qr_headers);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $qr_body);
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    $verbose = fopen('php://temp', 'w+');
    curl_setopt($ch, CURLOPT_STDERR, $verbose);
    $qr_response = curl_exec($ch);
    $qr_error = curl_error($ch);
    curl_close($ch);

    if ($qr_error) {
        wp_send_json_error(['message' => 'QR generation API failed: ' . $qr_error]);
        return;
    }

    $qr_data = json_decode($qr_response, true);

    if (!isset($qr_data['code']) || empty($qr_data['code'])) {
        wp_send_json_error(['message' => 'Invalid QR code response']);
        return;
    }

    // 8. Insert or Update QR Code Entry in Local DB
    $existing_entry = $wpdb->get_row(
        $wpdb->prepare("SELECT * FROM {$wpdb->prefix}bca_api_entries WHERE user_email = %s", $user_email)
    );

    if ($existing_entry) {
        $wpdb->update(
            "{$wpdb->prefix}bca_api_entries",
            [
                'tenant_name' => $tenant,
                'username'    => $current_user->user_login,
                'qr_code'     => $qr_data['code'],
                'qr_status'   => 'not_scanned',
            ],
            ['user_email' => $user_email]
        );
    } else {
        $wpdb->insert(
            "{$wpdb->prefix}bca_api_entries",
            [
                'tenant_name' => $tenant,
                'username'    => $current_user->user_login,
                'default_mfa_method' => 'totp',
                'user_email'  => $user_email,
                'qr_code'     => $qr_data['code'],
                'qr_status'   => 'not_scanned',
                'created_at'  => current_time('mysql'),
            ]
        );
    }

    // 9. Generate QR PNG File
    $upload_dir = plugin_dir_path(__FILE__) . 'assets/images/qr-codes/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    $filename = $upload_dir . $current_user->user_login . '_' . $current_user->ID . '_wp.png';
    if (function_exists('QRcode::png')) {
        QRcode::png($qr_data['code'], $filename);
    }

     

    $file_url = plugin_dir_url(__FILE__) . 'assets/images/qr-codes/' . basename($filename);

    // 10. Return Success
    wp_send_json_success(['qr_code_data' => $file_url]);
}

// Register the AJAX action for logged-in users
add_action('wp_ajax_generate_qr_code', 'generate_qr_code');





// recovery code functionality 

// Function to generate 5 recovery codes and return the QR code URL
// Function to generate 5 recovery codes and return the QR code URL
function generate_recovery_codes_for_user($user_email) {
    global $wpdb;

    // Generate 5 unique 6-digit codes
    $codes = [];
    for ($i = 0; $i < 5; $i++) {
        $codes[] = str_pad(rand(100000, 999999), 6, '0', STR_PAD_LEFT); // 6-digit code
    }

    // Insert recovery codes into the database
    $table_name = $wpdb->prefix . 'bca_recovery_code';
    $wpdb->insert(
        $table_name,
        [
            'user_email' => $user_email,
            'code_1' => $codes[0],
            'code_2' => $codes[1],
            'code_3' => $codes[2],
            'code_4' => $codes[3],
            'code_5' => $codes[4],
            'status_1' => false,
            'status_2' => false,
            'status_3' => false,
            'status_4' => false,
            'status_5' => false,
            'recovery_completed' => false
        ]
    );

    // You can generate and return the QR Code URL here if you want

    return [
        'codes' => $codes
    ];
}


// Handle the AJAX request to generate recovery codes
function handle_generate_recovery_codes_ajax() {
    // Verify the nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'generate_recovery_codes_nonce')) {
        wp_send_json_error(['message' => 'Invalid nonce']);
    }

    // Get the current user's email
    $current_user = wp_get_current_user();
    if ($current_user->ID == 0) {
        wp_send_json_error(['message' => 'User not logged in']);
    }

    $user_email = $current_user->user_email;

    // Generate the recovery codes
    $result = generate_recovery_codes_for_user($user_email);

    // Return the response
    wp_send_json_success($result);
}

add_action('wp_ajax_generate_recovery_codes', 'handle_generate_recovery_codes_ajax');


// Function to check if previous recovery codes are verified
function are_previous_codes_verified($user_email) {
    global $wpdb;

    // Get the recovery codes for the user
    $table_name = $wpdb->prefix . 'bca_recovery_code';
    
    // Fetch the last generated recovery codes for this user
    $codes = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT * FROM $table_name WHERE user_email = %s ORDER BY id DESC LIMIT 1",
            $user_email
        )
    );

    // If no codes found, return false
    if (!$codes) {
        return false;
    }

    // Check if all 5 recovery codes are verified
    for ($i = 1; $i <= 5; $i++) {
        if ($codes->{'status_' . $i} == false) {
            return false;  // Return false if any code is not verified
        }
    }

    // All codes are verified
    return true;
}

// Function to generate new recovery codes for the user
// Ensure that the $wpdb global is declared within the function
// Function to generate new recovery codes for the user
function generate_new_recovery_codes_for_user($user_email) {
    global $wpdb;

    // Check if the user email is valid
    if (empty($user_email)) {
        return ['success' => false, 'message' => 'Invalid user email.'];
    }

    // Generate 5 unique 6-digit codes
    $codes = [];
    for ($i = 0; $i < 5; $i++) {
        $codes[] = str_pad(rand(100000, 999999), 6, '0', STR_PAD_LEFT); // 6-digit code
    }

    // The table name for recovery codes
    $table_name = $wpdb->prefix . 'bca_recovery_code';

    // Check if there's an existing entry for this user email
    $existing_entry = $wpdb->get_row(
        $wpdb->prepare("SELECT * FROM $table_name WHERE user_email = %s", $user_email)
    );

    if ($existing_entry) {
        // If an existing record is found, update it with new codes
        $result = $wpdb->update(
            $table_name,
            [
                'code_1' => $codes[0],
                'code_2' => $codes[1],
                'code_3' => $codes[2],
                'code_4' => $codes[3],
                'code_5' => $codes[4],
                'status_1' => false,
                'status_2' => false,
                'status_3' => false,
                'status_4' => false,
                'status_5' => false,
                'recovery_completed' => false
            ],
            ['user_email' => $user_email]
        );

        if ($result === false) {
            return ['success' => false, 'message' => 'Error updating recovery codes.'];
        }

        // Successfully updated
        return [
            'success' => true,
            'codes' => $codes,
            'message' => 'Successfully updated recovery codes.'
        ];
    } else {
        // If no existing record, insert new recovery codes
        $result = $wpdb->insert(
            $table_name,
            [
                'user_email' => $user_email,
                'code_1' => $codes[0],
                'code_2' => $codes[1],
                'code_3' => $codes[2],
                'code_4' => $codes[3],
                'code_5' => $codes[4],
                'status_1' => false,
                'status_2' => false,
                'status_3' => false,
                'status_4' => false,
                'status_5' => false,
                'recovery_completed' => false
            ]
        );

        if ($result === false) {
            return ['success' => false, 'message' => 'Error inserting recovery codes.'];
        }

        // Successfully inserted
        return [
            'success' => true,
            'codes' => $codes,
            'message' => 'Successfully generated new recovery codes.'
        ];
    }
}



// Handle the AJAX request to generate new recovery codes
function handle_generate_new_recovery_codes_ajax() {
    // Verify the nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'generate_recovery_codes_nonce')) {
        wp_send_json_error(['message' => 'Invalid nonce']);
    }

    // Get the current user's email
    $current_user = wp_get_current_user();
    if ($current_user->ID == 0) {
        wp_send_json_error(['message' => 'User not logged in']);
    }

    $user_email = $current_user->user_email;

    // Generate new recovery codes for the user
    $result = generate_new_recovery_codes_for_user($user_email);

    // Return the response
    wp_send_json_success($result);
}

add_action('wp_ajax_generate_new_recovery_codes', 'handle_generate_new_recovery_codes_ajax');


// Handle the AJAX request to verify the recovery code
function handle_verify_recovery_code_ajax() {
    global $wpdb;
    // Verify the nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'generate_recovery_codes_nonce')) {
        wp_send_json_error(['message' => 'Invalid nonce']);
    }

    // Get the current user's email
    $current_user = wp_get_current_user();
    if ($current_user->ID == 0) {
        wp_send_json_error(['message' => 'User not logged in']);
    }

    $user_email = $current_user->user_email;
    $recovery_code = sanitize_text_field($_POST['recovery_code']); // Get entered recovery code

    // Check if the entered recovery code is valid and hasn't been verified already
    $table_name = $wpdb->prefix . 'bca_recovery_code';
    $codes = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT * FROM $table_name WHERE user_email = %s AND 
                (code_1 = %s OR code_2 = %s OR code_3 = %s OR code_4 = %s OR code_5 = %s) AND 
                recovery_completed = false",
            $user_email, $recovery_code, $recovery_code, $recovery_code, $recovery_code, $recovery_code
        )
    );

    if ($codes) {
        // Check each code to find the matching one that is unverified
        for ($i = 1; $i <= 5; $i++) {
            $code_field = 'code_' . $i;
            $status_field = 'status_' . $i;
            
            // Check if the code matches and hasn't been verified
            if ($codes->$code_field == $recovery_code && $codes->$status_field == false) {
                // Mark this specific code as verified
                $wpdb->update(
                    $table_name,
                    [$status_field => true],
                    ['user_email' => $user_email, $code_field => $recovery_code]
                );

                wp_send_json_success(['message' => 'Code Verified Successfully!']);
            }
        }
    } else {
        wp_send_json_error(['message' => 'Invalid or already verified recovery code.']);
    }
}

add_action('wp_ajax_verify_recovery_code', 'handle_verify_recovery_code_ajax');

function download_recovery_codes_pdf() {
    global $wpdb;

    // Ensure no output has been sent before
    if (ob_get_level()) {
        ob_end_clean(); // Clear any output buffer
    }

    // Check nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'generate_recovery_codes_nonce')) {
        wp_send_json_error(['message' => 'Nonce verification failed']);
    }

    $current_user = wp_get_current_user();
    $current_user_id = $current_user->ID;
    if ($current_user->ID == 0) {
        wp_send_json_error(['message' => 'User not logged in']);
    }

    $user_email = $current_user->user_email;

    // Fetch recovery codes from the database
    $table_name = $wpdb->prefix . 'bca_recovery_code';
    $entry = $wpdb->get_row(
        $wpdb->prepare("SELECT * FROM $table_name WHERE user_email = %s", $user_email)
    );

    if (!$entry) {
        wp_send_json_error(['message' => 'No recovery codes found for this user']);
    }

    // Recovery codes list
    $codes = [
        $entry->code_1, $entry->code_2, $entry->code_3,
        $entry->code_4, $entry->code_5
    ];

    // Create PDF
    $pdf = new FPDF();
    $pdf->AddPage();
    $pdf->SetFont('Arial', 'B', 16);

    // Title
    $pdf->Cell(40, 10, 'Your recovery codes are listed below,');
    $pdf->Ln(10);

    // Title
    $pdf->Cell(40, 10, 'Please note that each code will be valid only once.');
    $pdf->Ln(10);

    // Add codes to the PDF
    foreach ($codes as $code) {
        $pdf->Cell(40, 10, $code);
        $pdf->Ln(10);
    }

    // Ensure the plugin directory exists
    // $upload_dir = BCA_PLUGIN_PATH . 'assets/generated_pdfs';
    $upload_dir = WP_CONTENT_DIR . '/uploads/generated_pdfs';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0755, true);  // Create directory if it doesn't exist
    }

    // Define the file path for saving the PDF
    $file_name = $current_user_id . '-Recovery-Codes.pdf';
    $file_path = $upload_dir . '/' . $file_name;

    // Save the PDF to the specified path
    $pdf->Output('F', $file_path);  // Save PDF to a file

    // Return the URL of the saved file for download
    // $download_url = $file_path ;
    $download_url = content_url('uploads/generated_pdfs/' . $file_name);
    
    wp_send_json_success(['download_url' => $download_url]);
}

// Hook to handle the AJAX request
add_action('wp_ajax_download_recovery_codes_pdf', 'download_recovery_codes_pdf');
add_action('wp_ajax_nopriv_download_recovery_codes_pdf', 'download_recovery_codes_pdf');


function send_recovery_codes_email() {
    global $wpdb;
    
    // Verify nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'generate_recovery_codes_nonce')) {
        wp_send_json_error(['message' => 'Nonce verification failed']);
    }

    $current_user = wp_get_current_user();
    if ($current_user->ID == 0) {
        wp_send_json_error(['message' => 'User not logged in']);
    }

    $user_email = $current_user->user_email;

    // Fetch recovery codes from the database
    $table_name = $wpdb->prefix . 'bca_recovery_code';
    $entry = $wpdb->get_row(
        $wpdb->prepare("SELECT * FROM $table_name WHERE user_email = %s", $user_email)
    );

    if (!$entry) {
        wp_send_json_error(['message' => 'No recovery codes found for this user']);
    }

    // Recovery codes list
    $codes = [
        $entry->code_1, $entry->code_2, $entry->code_3,
        $entry->code_4, $entry->code_5
    ];

    // Query the database for the "User Recovery codes email" template
    $template = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}bca_email_templates WHERE template_name = %s LIMIT 1",
            'Recovery Codes Email' // Searching for this template name
        )
    );

    if ($template) {
        // Retrieve values from the template
        $subject = $template->email_subject;
        $message = $template->email_message;
        $from_email = $template->from_email;
        $from_name = $template->from_name;
        
        // Replace placeholders in the subject and message body
        $subject = replace_email_placeholders($subject, $current_user, null, $codes);  // Pass recovery codes for {backup_codes}
        $message = replace_email_placeholders($message, $current_user, null, $codes);  // Pass recovery codes for {backup_codes}

        // Set custom email headers
        $headers = array(
            'Content-Type: text/html; charset=UTF-8',
            'From: ' . $from_name . ' <' . $from_email . '>',
            'Reply-To: ' . $from_email,
        );

        // Send the email with recovery codes
        $mail_sent = wp_mail($user_email, $subject, $message, $headers);

        if ($mail_sent) {
            wp_send_json_success(['message' => 'Recovery codes sent to your email!']);
        } else {
            wp_send_json_error(['message' => 'Failed to send recovery codes email.']);
        }
    } else {
        wp_send_json_error(['message' => 'No active email template found for User Recovery codes email.']);
    }
}


// Hook to handle the AJAX request for sending email
add_action('wp_ajax_send_recovery_codes_email', 'send_recovery_codes_email');
add_action('wp_ajax_nopriv_send_recovery_codes_email', 'send_recovery_codes_email');



// push notification logic 

add_action('wp_ajax_push_notification_auth', 'handle_push_notification_auth');

function handle_push_notification_auth() {
    // Check nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'push_notification_nonce')) {
        wp_send_json_error(['message' => 'Invalid nonce']);
    }

    // Call the API to send the push notification
    $sendResponse = sendPushNotification();

    // Ensure we received a sessionId
    if (isset($sendResponse['sessionId'])) {
        $sessionId = $sendResponse['sessionId'];

        // Loop to check the status every second (up to TTL)
        $ttl = 60;  // Time to live in seconds
        $startTime = time();  // Record the start time

        while ((time() - $startTime) < $ttl) {
            sleep(1);  // Check every 1 second

            // Check the auth response
            $authResponse = checkAuthResponse($sessionId);

            // If auth response is not 'PENDING', break the loop
            if (isset($authResponse['authResponse']) && $authResponse['authResponse'] != 'PENDING') {
                break;
            }
        }

        // Check the response
        if (isset($authResponse['authResponse'])) {
            // Case handling for success/failure responses
            switch ($authResponse['authResponse']) {
                case 'ACCEPT':
                    wp_send_json_success(['message' => 'Authentication successful!']);
                    break;
                case 'REJECT':
                    wp_send_json_error(['message' => 'Authentication rejected. Please try again.']);
                    break;
                case 'TIMEOUT':
                    wp_send_json_error(['message' => 'Timeout: Please try again.']);
                    break;
                case 'PENDING':
                    wp_send_json_error(['message' => 'Timeout: Status still PENDING after 60 seconds. Please try again.']);
                    break;
                default:
                    wp_send_json_error(['message' => 'Unknown response from server.']);
                    break;
            }
        } else {
            wp_send_json_error(['message' => 'Error: No response received from the authentication server.']);
        }

    } else {
        wp_send_json_error(['message' => 'Error: No sessionId received.']);
    }
}

// Function to send the Push Notification to get sessionId
function sendPushNotification() {
    $url = 'https://pushnotifications.baariga.com/api/v1/push-notify/send-auth-notification/oauth';

    $headers = [
        'tanant: barrconnectiga07',
        'ID: BdRYpSr8VKZHl4Kl9R2YTtSokNs7OK47XUqWeeNVMc4=BdRYpS',
        'Content-Type: application/json',
    ];

    $data = [
        "userId" => "baardemoservice@gmail.com",
        "ttl" => "60",  // Time to live in seconds
        "location" => "Kolkata, West Bengal",
        "geoLocationLat" => "31.556860",
        "geoLocationLong" => "75.904170",
        "deviceType" => "Mobile",
        "logInDeviceBrowser" => "Chrome",
        "deviceIpAddress" => "192.168.1.5",
        "deviceName" => "iPhone 13",
        "deviceOS" => "iOS",
        "logInInitiationTime" => "05-02-2025 12:00:00",
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Function to check the response of the sent notification
function checkAuthResponse($sessionId) {
    $url = 'https://pushnotifications.baariga.com/api/v1/push-notify/check-auth-response';

    $headers = [
        'tanant: barrconnectiga07',
        'ID: BdRYpSr8VKZHl4Kl9R2YTtSokNs7OK47XUqWeeNVMc4=BdRYpS',
        'Content-Type: application/json',
    ];

    $data = [
        "sessionId" => $sessionId,
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}



// Email OTP Verification code 

// Action hook to handle sending OTP email
// add_action('wp_ajax_send_otp_email', 'send_otp_email');
// add_action('wp_ajax_nopriv_send_otp_email', 'send_otp_email');

// function send_otp_email() {
//     if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'email_otp_nonce')) {
//         wp_send_json_error(array('message' => 'Nonce verification failed'));
//     }

//     if (isset($_POST['email'])) {
//         $email = sanitize_email($_POST['email']);
        
//         // Generate a random OTP (6-digit number)
//         $otp = rand(100000, 999999);

//         // Save the OTP in session for verification
//         session_start();
//         $_SESSION['otp_email'] = $email;
//         $_SESSION['otp_code'] = $otp;

//         // Query the database for the "OTP email template" where email_status = 1
//         global $wpdb;
//         $template = $wpdb->get_row(
//             $wpdb->prepare(
//                 "SELECT * FROM {$wpdb->prefix}bca_email_templates WHERE template_name = %s AND email_status = 1 LIMIT 1",
//                 '2MFA setup code email' // Change to the correct template name
//             )
//         );

//         if ($template) {
//             // Retrieve values from the template
//             $subject = $template->email_subject;
//             $message = $template->email_message;
//             $from_email = $template->from_email;
//             $from_name = $template->from_name;
        
//             // Optionally, get user info if not passed as a parameter
//             $user = wp_get_current_user(); // If you need user information (for logged-in users)
        
//             // Replace placeholders in the subject and message body
//             $subject = replace_email_placeholders($subject, $user, $otp);
//             $message = replace_email_placeholders($message, $user, $otp);
        
//             // Set custom email headers
//             $headers = array(
//                 'Content-Type: text/html; charset=UTF-8',
//                 'From: ' . $from_name . ' <' . $from_email . '>',
//                 'Reply-To: ' . $from_email, // Optionally set Reply-To header as well
//             );
        
//             // Send OTP email
//             $mail_sent = wp_mail($email, $subject, $message, $headers);
            
//             if ($mail_sent) {
//                 wp_send_json_success(array('message' => 'OTP sent successfully.'));
//             } else {
//                 wp_send_json_error(array('message' => 'Failed to send OTP.'));
//             }
//         } else {
//             wp_send_json_error(array('message' => 'No active email template found for OTP.'));
//         }    
//     } else {
//         wp_send_json_error(array('message' => 'Email address is required.'));
//     }

//     wp_die();
// }


// Action hook to handle verifying OTP
// add_action('wp_ajax_email_verify_otp', 'email_verify_otp');
// add_action('wp_ajax_nopriv_email_verify_otp', 'email_verify_otp');

// function email_verify_otp() {
//     if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'email_otp_nonce')) {
//         wp_send_json_error(array('message' => 'Nonce verification failed'));
//     }

//     if (isset($_POST['email']) && isset($_POST['otp'])) {
//         session_start();
//         $email = sanitize_email($_POST['email']);
//         $otp = sanitize_text_field($_POST['otp']);

//         // Check if the entered OTP matches the one saved in the session
//         if (isset($_SESSION['otp_code']) && $_SESSION['otp_email'] == $email && $_SESSION['otp_code'] == $otp) {
//             wp_send_json_success(array('message' => 'OTP verified successfully.'));
//         } else {
//             wp_send_json_error(array('message' => 'Invalid OTP.'));
//         }
//     }
//     wp_die();
// }


// Security Questions and answers 
function handle_security_questions_submission() {
    // Verify the nonce
    if ( ! isset($_POST['nonce']) || ! wp_verify_nonce($_POST['nonce'], 'security_questions_nonce') ) {
        wp_send_json_error(array('message' => 'Nonce verification failed.'));
        exit;
    }

    if (isset($_POST['form_data'])) {
        global $wpdb;

        // Extract data from the form
        parse_str($_POST['form_data'], $form_data);

        // Get current user email (you can modify this based on your use case)
        $user_email = wp_get_current_user()->user_email;

        // Prepare data for insertion
        $data = array(
            'user_email' => sanitize_email($user_email),
            'question_1' => sanitize_text_field($form_data['question_1']),
            'answer_1'   => sanitize_textarea_field($form_data['answer_1']),
            'question_2' => sanitize_text_field($form_data['question_2']),
            'answer_2'   => sanitize_textarea_field($form_data['answer_2']),
            'question_3' => sanitize_text_field($form_data['question_3']),
            'answer_3'   => sanitize_textarea_field($form_data['answer_3']),
            'question_4' => sanitize_text_field($form_data['question_4']),
            'answer_4'   => sanitize_textarea_field($form_data['answer_4']),
            'question_5' => sanitize_text_field($form_data['question_5']),
            'answer_5'   => sanitize_textarea_field($form_data['answer_5']),
        );

        // Check if the user already has security questions stored
        $existing_entry = $wpdb->get_var($wpdb->prepare(
            "SELECT id FROM {$wpdb->prefix}bca_user_security_questions WHERE user_email = %s",
            $user_email
        ));

        if ($existing_entry) {
            // If the user already has data, update it
            $wpdb->update(
                "{$wpdb->prefix}bca_user_security_questions",
                $data,
                array('user_email' => $user_email)
            );
            $update_result = $wpdb->update(
                "{$wpdb->prefix}bca_api_entries",
                [
                    'qr_status' => 'scanned',
                    'securityQuestion_config' => 'completed',
                ],
                ['user_email' => $user_email]
            );
        } else {
            // If the user doesn't have data, insert it
            $wpdb->insert("{$wpdb->prefix}bca_user_security_questions", $data);
            $update_result = $wpdb->update(
                "{$wpdb->prefix}bca_api_entries",
                [
                    'qr_status' => 'scanned',
                    'securityQuestion_config' => 'completed',
                ],
                ['user_email' => $user_email]
            );
        }

        // Return success response
        wp_send_json_success();
    }

    // Return error response if no data is sent
    wp_send_json_error(array('message' => 'No data received.'));
    exit;
}
add_action('wp_ajax_submit_security_questions', 'handle_security_questions_submission');


function handle_fetch_security_questions() {
    // Verify the nonce
    if ( ! isset($_POST['nonce']) || ! wp_verify_nonce($_POST['nonce'], 'security_questions_nonce') ) {
        wp_send_json_error(array('message' => 'Nonce verification failed.'));
        exit;
    }

    // Get current user email
    $user_email = wp_get_current_user()->user_email;

    // Fetch stored answers from the database
    global $wpdb;
    $results = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM {$wpdb->prefix}bca_user_security_questions WHERE user_email = %s",
        $user_email
    ));

    if ($results) {
        wp_send_json_success($results);
    } else {
        wp_send_json_error(array('message' => 'No security question data found.'));
    }
}
add_action('wp_ajax_fetch_security_questions', 'handle_fetch_security_questions');



// Handle OTP sending to the mail setting configure tab
function bca_send_email_setting_otp() {
    global $wpdb;

    // Verify the nonce
    if ( !isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'email_otp_setting_config_nonce') ) {
        wp_send_json_error(array('message' => 'Invalid nonce.'));
    }

    // First try with prefix
    $license_key = '';
    $tables_to_try = [
        "{$wpdb->prefix}bca_licence_detail",
        "wp_bca_licence_detail",
        "bca_licence_detail"
    ];
    
    foreach ($tables_to_try as $table) {
        // Check if table exists
        $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table'");
        if (!$table_exists) continue;
        
        // Try licence_key first
        $data = $wpdb->get_row("SELECT licence_key FROM $table");
        if ($data && isset($data->licence_key)) {
            $license_key = $data->licence_key;
            error_log("Found license key in $table using 'licence_key' column");
            break;
        }
        
        // Try license_key (US spelling) next
        $data = $wpdb->get_row("SELECT license_key FROM $table");
        if ($data && isset($data->license_key)) {
            $license_key = $data->license_key;
            error_log("Found license key in $table using 'license_key' column");
            break;
        }
    }
    
    error_log('License key found: ' . ($license_key ? 'Yes, length: ' . strlen($license_key) : 'No'));

    // Prepare a transient key to cache license response
    $transient_key = 'bca_license_info_' . md5($license_key);
    
    // Clear the cached transient to force a fresh check
    delete_transient($transient_key);
    $license_info = false;

    if (!$license_key) {
        // Try to retrieve from options as a fallback
        $license_key = get_option('bca_licence_key', '');
    }

    if (!$license_key) {
        wp_send_json_error([
            'message' => 'License key not found in database. Please check your license activation.',
            'debug_info' => [
                'tables_checked' => $tables_to_try,
                'options_checked' => ['bca_licence_key']
            ]
        ]);
        return;
    }
    
    // Log license key length for debugging (don't log the actual key)
    error_log('Using license key with length: ' . strlen($license_key));
    
    // Call the external API to validate the license
    $response = wp_remote_post('https://store.baar.ai/api/validate-license-features', [
        'headers' => ['Content-Type' => 'application/json'],
        'body'    => json_encode(['license_key' => $license_key]),
        'timeout' => 15, // Increased timeout
    ]);

    if (is_wp_error($response)) {
        error_log('License API Error: ' . $response->get_error_message());
        wp_send_json_error([
            'message' => 'Unable to validate license: ' . $response->get_error_message(),
            'debug_info' => ['error_code' => $response->get_error_code()]
        ]);
        return;
    }

    $response_code = wp_remote_retrieve_response_code($response);
    $response_body = wp_remote_retrieve_body($response);
    error_log('License API Response Code: ' . $response_code);
    error_log('License API Response: ' . substr($response_body, 0, 100) . '...');
    
    $body = json_decode($response_body, true);

    if (!empty($body['status']) && $body['status'] == 1) {
        $license_info = $body['data'];
        error_log('License valid. Plan: ' . ($license_info['plan'] ?? 'unknown'));
        set_transient($transient_key, $license_info, HOUR_IN_SECONDS);
    } else {
        error_log('License invalid. Response: ' . json_encode($body));
        wp_send_json_error([
            'message' => 'Invalid license or API response: ' . ($body['message'] ?? 'Unknown error'),
            'debug_info' => [
                'response_code' => $response_code,
                'api_status' => $body['status'] ?? 'missing'
            ]
        ]);
        return;
    }

    // Add debugging to see what's being received
    error_log('License plan: ' . ($license_info['plan'] ?? 'none'));

    // Case-insensitive comparison for plan check
    $plan = strtolower($license_info['plan'] ?? '');
    if ($plan !== 'standard' && $plan !== 'premium') {
        wp_send_json_error(['message' => 'Upgrade to Standard or Premium plan to use this feature. Current plan: ' . ($license_info['plan'] ?? 'Unknown')]);
    }

    // Continue only if email is valid
    if (isset($_POST['email']) && is_email($_POST['email'])) {
        $email = sanitize_email($_POST['email']);

        // Generate and store OTP
        $otp = rand(100000, 999999);
        update_user_meta(get_current_user_id(), '_email_otp', $otp);

        // Send email
        $subject = 'Your OTP for Email Verification';
        $message = 'Your OTP is ' . $otp;
        $headers = array('Content-Type: text/html; charset=UTF-8');

        $mail_sent = wp_mail($email, $subject, $message, $headers);

        if ($mail_sent) {
            wp_send_json_success(['message' => 'OTP sent successfully.']);
        } else {
            wp_send_json_error(['message' => 'Failed to send OTP.']);
        }
    } else {
        wp_send_json_error(['message' => 'Invalid email address.']);
    }
}

add_action('wp_ajax_bca_send_email_setting_otp', 'bca_send_email_setting_otp');
add_action('wp_ajax_nopriv_bca_send_email_setting_otp', 'bca_send_email_setting_otp');


//verify the email otp
function bca_verify_email_setting_otp() {
    global $wpdb;
    $current_user = wp_get_current_user();
    $user_email = $current_user->user_email;
    // Verify the nonce
    if ( !isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'email_otp_setting_config_nonce') ) {
        wp_send_json_error(array('message' => 'Invalid nonce.'));
    }

    // Check if OTP is provided
    if (isset($_POST['otp'])) {
        $otp = sanitize_text_field($_POST['otp']);
        
        // Get the stored OTP from user meta
        $stored_otp = get_user_meta(get_current_user_id(), '_email_otp', true);
        
        // Check if OTP matches
        if ($otp == $stored_otp) {
            $update_result = $wpdb->update(
                "{$wpdb->prefix}bca_api_entries",
                [
                    'email_otp' => $otp, 
                    'qr_status' => 'scanned',
                    'user_status' => 'login',
                    'auth_type' => 'OTP via Email',
                    'otpEmail_config' => 'completed',
                ],
                ['user_email' => $user_email]
            );
            // OTP is correct, perform any action you want here (e.g., save MFA config)
            wp_send_json_success(array('message' => 'OTP verified successfully.'));
        } else {
            wp_send_json_error(array('message' => 'Incorrect OTP.'));
        }
    } else {
        wp_send_json_error(array('message' => 'OTP not provided.'));
    }
}
add_action('wp_ajax_bca_verify_email_setting_otp', 'bca_verify_email_setting_otp');
add_action('wp_ajax_nopriv_bca_verify_email_setting_otp', 'bca_verify_email_setting_otp');

// Function to resend OTP
function bca_resend_email_setting_otp() {
    // Make sure you validate nonce for security
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'email_otp_setting_config_nonce')) {
        wp_send_json_error(['message' => 'Invalid nonce']);
    }

    // Check if the email is valid
    if (isset($_POST['email']) && is_email($_POST['email'])) {
        $email = sanitize_email($_POST['email']);
        
        // Send OTP logic (e.g., generate OTP, send email)
        $otp_sent = bca_send_email_setting_otp($email); // Your function to send the OTP

        if ($otp_sent) {
            wp_send_json_success();
        } else {
            wp_send_json_error(['message' => 'Unable to resend OTP']);
        }
    } else {
        wp_send_json_error(['message' => 'Invalid email address']);
    }
}

add_action('wp_ajax_bca_resend_email_setting_otp', 'bca_resend_email_setting_otp');
add_action('wp_ajax_nopriv_bca_resend_email_setting_otp', 'bca_resend_email_setting_otp'); // For non-logged-in users

