<?php
if (!defined('ABSPATH')) exit;

class BCA_License_Check {

    public static function validate_license($license_key) {
        $api_url = 'https://store.baar.ai/api/validate-license';
        $headers = [
            'X-API-KEY' => 'barrmfa-1US2NYn1PkQTRmuswd6jZIFovT4',
            'Content-Type' => 'application/json',
        ];

        $body = json_encode([
            'license_key' => $license_key,
            'site_url' => site_url(),
        ]);

        $response = wp_remote_post($api_url, [
            'method' => 'POST',
            'headers' => $headers,
            'body' => $body,
        ]);

        if (is_wp_error($response)) {
            return ['status' => 0, 'message' => 'API request failed.'];
        }

        $body = wp_remote_retrieve_body($response);
        return json_decode($body, true);
    }

    public static function get_cached_license_info() {
        // Disable caching for testing
        // $cached = get_transient('bca_license_info');
        // if ($cached !== false) return $cached;

        global $wpdb;
        $license_data = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT licence_key FROM {$wpdb->prefix}bca_licence_detail WHERE site_url = %s",
                get_site_url()
            )
        );

        if (!$license_data || empty($license_data->licence_key)) {
            return false;
        }

        $license_key = $license_data->licence_key;
        $response = self::validate_license($license_key);

        // Commenting cache for testing
        // set_transient('bca_license_info', $response, 12 * HOUR_IN_SECONDS);

        return $response;
    }

    public static function show_license_notice() {
        if (!current_user_can('manage_options')) return;

        $info = self::get_cached_license_info();
        
        // Handle case where license info is not available - do not show any notice
        if (!$info) {
            return; // Simply return without showing any notice
        }

        // Handle expired license case
        if ($info['status'] === false && isset($info['message']) && strpos($info['message'], 'expired') !== false) {
            echo '<div class="notice notice-error" style="border-left-color:#dc3232;">
                    <p><strong>Your BAAR MFA license has expired.</strong><br>
                    Please <a href="https://store.baar.ai/subscriptions" target="_blank" style="color:#dc3232; text-decoration:underline;">renew your license</a> to continue using premium updates and support.</p>
                  </div>';
            return;
        }

        // Handle other validation failures
        if ($info['status'] != 1 && $info['status'] !== true) {
            echo '<div class="notice notice-error is-dismissible">
                    <p><strong>License validation failed.</strong> Please check your license key.</p>
                  </div>';
            return;
        }

        // Handle valid license with expiry date check
        if (empty($info['data']['expiry_date'])) {
            return; // No expiry date to check
        }

        $expiry = strtotime($info['data']['expiry_date']);
        $now = current_time('timestamp');
        $days_left = floor(($expiry - $now) / DAY_IN_SECONDS);

        if ($days_left < 0) {
            echo '<div class="notice notice-error" style="border-left-color:#dc3232;">
                    <p><strong>Your BAAR MFA license has expired.</strong><br>
                    Please <a href="https://store.baar.ai/subscriptions" target="_blank" style="color:#dc3232; text-decoration:underline;">renew your license</a> to continue using premium updates and support.</p>
                  </div>';
        } elseif ($days_left <= 15) {
            echo '<div class="notice notice-warning" style="border-left-color:#ffb900;">
                    <p><strong>Your BAAR MFA license will expire in ' . $days_left . ' day' . ($days_left !== 1 ? 's' : '') . '.</strong><br>
                    Please <a href="https://store.baar.ai/subscriptions" target="_blank" style="color:#ffb900; text-decoration:underline;">renew your license</a> to avoid interruption.</p>
                  </div>';
        }
    }
}