<?php
class BCA_EmailSetting {
    public static function render_tab() {
        if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bca_emailSetting'])) {
            // Verify nonce
            if (!isset($_POST['bca_emailSetting_nonce']) || !wp_verify_nonce($_POST['bca_emailSetting_nonce'], 'bca_save_emailSetting')) {
                echo '<div class="alert alert-danger">Nonce verification failed. Please try again.</div>';
                return;
            }

            // Save MFA
            update_option('bca_emailSetting', $mfa);
            echo '<div class="alert alert-success">Email Setting saved successfully.</div>';
        }

        $mfa = get_option('bca_emailSetting', []);
        include BCA_PLUGIN_PATH . 'templates/email-tab.php';
    }
}

//functions for otp

function verify_otp() {
    if (isset($_POST['otp'])) {
        $otp = intval($_POST['otp']);
        
        if (isset($_SESSION['otp']) && $_SESSION['otp'] == $otp && (time() - $_SESSION['otp_time']) <= 300) {
            // OTP is correct and not expired
            wp_send_json_success();
        } else {
            wp_send_json_error(['message' => 'Incorrect OTP or OTP expired']);
        }
    } else {
        wp_send_json_error(['message' => 'OTP is required']);
    }
}
add_action('wp_ajax_verify_otp', 'verify_otp');
add_action('wp_ajax_nopriv_verify_otp', 'verify_otp');

function resend_otp() {
    if (isset($_POST['email'])) {
        $email = sanitize_email($_POST['email']);
        // Regenerate and resend OTP
        return send_otp_to_email();
    }
}
add_action('wp_ajax_resend_otp', 'resend_otp');
add_action('wp_ajax_nopriv_resend_otp', 'resend_otp');


// Email tempaltes save the data
function save_single_email_template() {
    global $wpdb;

    // Check if required fields are empty
    if (empty($_POST['email_template_name']) || empty($_POST['email_template_subject']) || empty($_POST['email_template_message']) || empty($_POST['from_name'])) {
        wp_send_json_error(['message' => 'Missing required template data.']);
    }
    
    $email_template_name = sanitize_text_field($_POST['email_template_name']);
    // $email_template_status = sanitize_text_field($_POST['email_template_status']);
    $email_template_status = isset($_POST['email_template_status']) ? (int) $_POST['email_template_status'] : 0; // Ensure it's 0 or 1
    $email_template_subject = sanitize_text_field($_POST['email_template_subject']);
    $email_template_message = wp_kses_post($_POST['email_template_message']);
    // $from_email = sanitize_email($_POST['from_email']);
    $from_name = sanitize_text_field($_POST['from_name']);
    
    // Check if a template with the same name already exists
    $existing_template = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}bca_email_templates WHERE template_name = %s",
            $email_template_name
        )
    );

    $data = array(
        'template_name' => $email_template_name,
        'email_subject' => $email_template_subject,
        'email_message' => $email_template_message,
        'email_status' => (int) $email_template_status,
        // 'from_email' => $from_email,
        'from_name' => $from_name,
    );

    // If the template exists, update it, otherwise insert it as a new template
    if ($existing_template) {
        // Update the existing template
        $updated = $wpdb->update(
            $wpdb->prefix . 'bca_email_templates', 
            $data, 
            array('template_name' => $email_template_name), 
            array('%s', '%s', '%s', '%d', '%s'), 
            array('%s')
        );

        if ($updated === false) {
            error_log('Failed to update template: ' . $email_template_name);
            wp_send_json_error(['message' => 'Failed to update template.']);
        }
        
        wp_send_json_success(['message' => 'Template updated successfully.']);
    } else {
        // Insert the new template
        $inserted = $wpdb->insert($wpdb->prefix . 'bca_email_templates', $data);

        if ($inserted === false) {
            error_log('Failed to insert template: ' . $email_template_name);
            wp_send_json_error(['message' => 'Failed to save template.']);
        }

        wp_send_json_success(['message' => 'Template saved successfully.']);
    }
}
add_action('wp_ajax_save_single_email_template', 'save_single_email_template');


// Function to send test email based on selected template
function send_test_email() {
    if (isset($_POST['template_name']) || isset($_POST['from_test_email']) || isset($_POST['from_test_name']) ) {
        $template_name = sanitize_text_field($_POST['template_name']);
        $from_test_email = sanitize_email($_POST['from_test_email']);
        $from_test_name = sanitize_text_field($_POST['from_test_name']);

        // Get template details from the database based on the selected template
        global $wpdb;
        $template = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT * FROM {$wpdb->prefix}bca_email_templates WHERE template_name = %s",
                $template_name
            )
        );

        if ($template) {
            $subject = $template->email_subject;
            $message = strip_tags($template->email_message);
            // Replace placeholders in the subject and message body
            $subject = replace_email_placeholders($subject, $current_user, null, $codes);  // Pass recovery codes for {backup_codes}
            $message = replace_email_placeholders($message, $current_user, null, $codes);  // Pass recovery codes for {backup_codes}

            // Use the WP Mail SMTP filters to set dynamic From Name and From Email
            add_filter('wp_mail_from', function($email) use ($from_test_email) {
                return $from_test_email;  // Set the dynamic From Email
            });

            add_filter('wp_mail_from_name', function($name) use ($from_test_name) {
                return $from_test_name;  // Set the dynamic From Name
            });

            // Enhanced headers (Make sure From is set to dynamic values)
            $headers = array(
                'From' => $from_test_name . ' <' . $from_test_email . '>',
                'Content-Type' => 'text/plain; charset=UTF-8',
                'Reply-To' => $from_test_email,
            );
            // Enhanced headers
            // $headers = array(
            //     'From' => $from_name . ' <' . $from_email . '>',
            //     'Content-Type' => 'text/html; charset=UTF-8',
            //     'Reply-To' => $from_email,
            // );

            // Send the test email using wp_mail()
            $email_sent = wp_mail($from_test_email, $subject, $message, $headers);

            // Remove the filters after the email is sent
            remove_filter('wp_mail_from', 'wp_mail_from');
            remove_filter('wp_mail_from_name', 'wp_mail_from_name');

            if ($email_sent) {
                wp_send_json_success(['message' => 'Test email sent successfully!']);
            } else {
                wp_send_json_error(['message' => 'Failed to send test email.']);
            }
        } else {
            wp_send_json_error(['message' => 'Template not found.']);
        }
    } else {
        wp_send_json_error(['message' => 'Invalid data.']);
    }
}
add_action('wp_ajax_send_test_email', 'send_test_email');

// Function to fetch email templates from the database
add_action('wp_ajax_get_email_templates', 'get_email_templates_callback');

function get_email_templates_callback() {
    global $wpdb;

    // Query to fetch only templates with 
    $results = $wpdb->get_results("SELECT template_name FROM {$wpdb->prefix}bca_email_templates");

    // Check if there are any templates
    if ($results) {
        wp_send_json_success(array(
            'templates' => $results  // Return the templates
        ));
    } else {
        wp_send_json_error(array(
            'message' => 'No active templates found.'
        ));
    }
}


