<?php
class BCA_Brand_Account
{

    public static function render_tab()
    {
        // Render the MFA settings page template
        include BCA_PLUGIN_PATH . 'templates/brand-setting-tab.php';
    }
}

function save_brand_details() {
    global $wpdb;

    // Verify Nonce
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'brand_submission_nonce')) {
        wp_send_json_error("Security check failed.");
    }

    // Validate Brand Name
    if (!isset($_POST['brand_name']) || empty($_POST['brand_name'])) {
        wp_send_json_error("Brand name is required.");
    }

    // Get License Key
    $license_data = $wpdb->get_row("SELECT licence_key FROM {$wpdb->prefix}bca_licence_detail");
    $license_key = $license_data->licence_key ?? '';

    if (!$license_key) {
        wp_send_json_error("License key not found. Please activate your license.");
    }

    // Direct API call without using transient cache
    $response = wp_remote_post('https://store.baar.ai/api/validate-license', [
        'headers' => ['Content-Type' => 'application/json'],
        'body'    => json_encode(['license_key' => $license_key]),
        'timeout' => 10
    ]);

    if (is_wp_error($response)) {
        wp_send_json_error("License validation failed. Please try again.");
    }

    $response_body = wp_remote_retrieve_body($response);
    $license_info = json_decode($response_body, true);

    // Check if license is valid
    if (!$license_info || !isset($license_info['status']) || $license_info['status'] != 1) {
        wp_send_json_error("Invalid license. Please check your license key.");
    }

    // Debug - Log the plan value to check what's coming from API
    error_log('Plan from API: ' . print_r($license_info['data']['plan'], true));

    // Case-insensitive check for 'premium' plan
    if (!isset($license_info['data']['plan']) || 
        strtolower($license_info['data']['plan']) != 'premium') {
        wp_send_json_error("This feature is only available for Premium plan users. Please upgrade your plan to access it.");
    }

    // Sanitize brand name
    $brand_name = sanitize_text_field($_POST['brand_name']);
    $table_name = $wpdb->prefix . "bca_brand_details";

    // Check existing brand
    $existing_brand = $wpdb->get_row("SELECT * FROM $table_name LIMIT 1");

    // Handle File Upload
    if (isset($_FILES['brand_logo']) && $_FILES['brand_logo']['error'] === UPLOAD_ERR_OK) {
        $upload_dir = plugin_dir_path(__FILE__) . 'assets/images/brand-image/';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }

        $file_name = time() . '_' . basename($_FILES['brand_logo']['name']);
        $target_file = $upload_dir . $file_name;

        if (move_uploaded_file($_FILES['brand_logo']['tmp_name'], $target_file)) {
            $brand_logo = 'assets/images/brand-image/' . $file_name;
        } else {
            wp_send_json_error("Failed to move uploaded file.");
        }
    } else {
        $brand_logo = $existing_brand ? $existing_brand->brand_logo : '';
    }

    // Insert or update
    if ($existing_brand) {
        $wpdb->update($table_name,
            ['brand_name' => $brand_name, 'brand_logo' => $brand_logo],
            ['id' => $existing_brand->id]
        );
        wp_send_json_success("Brand details updated successfully!");
    } else {
        $wpdb->insert($table_name,
            ['brand_name' => $brand_name, 'brand_logo' => $brand_logo]
        );
        wp_send_json_success("Brand details saved successfully!");
    }
}

add_action('wp_ajax_save_brand', 'save_brand_details');
add_action('wp_ajax_nopriv_save_brand', 'save_brand_details');


function get_brand_data() {
    global $wpdb;
    $table_name = $wpdb->prefix . "bca_brand_details";
    $brand = $wpdb->get_row("SELECT * FROM $table_name LIMIT 1");

    if ($brand) {
        wp_send_json_success([
            'id' => $brand->id,
            'brand_name' => $brand->brand_name,
            'brand_logo' => plugin_dir_url(__FILE__) . $brand->brand_logo
        ]);
    } else {
        wp_send_json_error("No brand found.");
    }
}
add_action('wp_ajax_get_brand_data', 'get_brand_data');
add_action('wp_ajax_nopriv_get_brand_data', 'get_brand_data');


