<?php
class BCA_Account
{

    public static function render_tab()
    {
        // Render the MFA settings page template
        include BCA_PLUGIN_PATH . 'templates/account-tab.php';
    }
}

function check_license_status() {
    global $wpdb;

    // Query to check if a license is activated
    $license_data = $wpdb->get_row(
        $wpdb->prepare(
            "SELECT licence_key FROM {$wpdb->prefix}bca_licence_detail WHERE site_url = %s", 
            get_site_url() // Use the current site URL
        )
    );

    if ($license_data) {
        // License exists, return the license key
        wp_send_json_success(array('license_key' => $license_data->licence_key));
    } else {
        // No license found
        wp_send_json_error(array('message' => 'No license found.'));
    }
}

add_action('wp_ajax_check_license_status', 'check_license_status');
add_action('wp_ajax_nopriv_check_license_status', 'check_license_status'); // For non-logged-in users




function verify_and_activate_license() {
    if (isset($_POST['license_key']) && !empty($_POST['license_key'])) {
        $license_key = sanitize_text_field($_POST['license_key']);
        
        // API Request to validate the license key
        $response = validate_license($license_key);
        
        if ($response['status'] === 1) {
            // If license is valid, save the details in the database
            $data = $response['data'];
            global $wpdb;
            
            // Check if the license key already exists in the database
            $bca_licence_detail = $wpdb->prefix . 'bca_licence_detail';
            $existing_license = $wpdb->get_row(
                $wpdb->prepare("SELECT * FROM {$wpdb->prefix}bca_licence_detail WHERE site_url = %s", site_url())
            );
            
            
            if ($existing_license) {
                // Update the existing license record
                $wpdb->update(
                    $bca_licence_detail,
                    array(
                    
                        'licence_key' => $license_key,
                        'user_email' => $data['user_email'],
                        'api_customer_id' => $data['customer_id'],
                        'plan_name' => $data['plan'],
                        'licence_expiry_date' => $data['expiry_date'],
                        'licence_status' => 'active',
                        'max_sites' => $data['max_sites'],
                        'updated_at' => current_time('mysql')
                    ),
                    array('id' => $existing_license->id)
                );
            } else {
                // Insert a new record if no existing license is found
                $wpdb->insert(
                    $bca_licence_detail,
                    array(
                        'user_email' => $data['user_email'],
                        'licence_key' => $license_key,
                        'api_customer_id' => $data['customer_id'],
                        'plan_name' => $data['plan'],
                        'licence_expiry_date' => $data['expiry_date'],
                        'licence_status' => 'active',
                        'site_url' => site_url(),
                        'max_sites' => $data['max_sites'],
                        'created_at' => current_time('mysql')
                    )
                );
            }

            // Send success response
            // Send success response
$response = wp_remote_post('https://store.baar.ai/api/baar-mfa/manage-site', array(
    'method'    => 'POST',
    'headers'   => array(
        'Content-Type' => 'application/json',
        'X-API-KEY'    => 'barrmfa-1US2NYn1PkQTRmuswd6jZIFovT4',
    ),
    'body'      => json_encode(array(
        'license_key' => $license_key,
        'site_url'    => site_url(),
        'action'      => 'activate',
    )),
));

// Optional: Handle the response if needed
if (is_wp_error($response)) {
    $error_message = $response->get_error_message();
    wp_send_json_error(array('message' => 'License activated but failed to notify server: ' . $error_message));
}

            wp_send_json_success(array('message' => 'Your key is activated successfully.'));

        } else {
            // If license is invalid, return error message
            wp_send_json_error(array('message' => 'Failed to activate license. ' . $response['message']));
        }
    } else {
        // If license key is empty, return error
        wp_send_json_error(array('message' => 'Please enter a valid license key.'));
    }
}

// Function to call external API for license validation
function validate_license($license_key) {
    $api_url = 'https://store.baar.ai/api/validate-license';
    $headers = array(
        'X-API-KEY' => 'barrmfa-1US2NYn1PkQTRmuswd6jZIFovT4',
        'Content-Type' => 'application/json',
    );

    $body = json_encode(array(
        'license_key' => $license_key,
        'site_url'=> site_url(),
    ));

    // Perform the API request
    $response = wp_remote_post($api_url, array(
        'method'    => 'POST',
        'headers'   => $headers,
        'body'      => $body,
    ));

    if (is_wp_error($response)) {
        return array('status' => 0, 'message' => 'API request failed.');
    }

    // Decode the response body
    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    return $data;
}

// Add AJAX action for logged-in users
add_action('wp_ajax_verify_and_activate_license', 'verify_and_activate_license');