<?php
/**
 * Plugin Name: BAAR MFA
 * Description: A plugin for managing authentication settings including MFA, Email, and Pro Version.
 * Version: v.1.0.0
 * Author: BAAR MFA
 * License: GPL-2.0-or-later
 */

if (!defined('ABSPATH')) {
    exit;
}

// Define constants
define('BCA_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('BCA_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include required files
require_once BCA_PLUGIN_PATH . 'includes/class-settings.php';
require_once BCA_PLUGIN_PATH . 'includes/class-license-check.php';
require_once BCA_PLUGIN_PATH . 'includes/class-brand-setting.php';
require_once BCA_PLUGIN_PATH . 'includes/class-mfa.php';
require_once BCA_PLUGIN_PATH . 'includes/class-email.php';
require_once BCA_PLUGIN_PATH . 'includes/class-pro.php';
require_once BCA_PLUGIN_PATH . 'includes/class-account.php';
require_once BCA_PLUGIN_PATH . 'includes/class-faq.php';
require_once BCA_PLUGIN_PATH . 'includes/api-handler.php'; 
require_once BCA_PLUGIN_PATH . 'includes/class-report.php';
require_once BCA_PLUGIN_PATH . 'assets/qr-code/phpqrcode/qrlib.php';
require_once BCA_PLUGIN_PATH . 'includes/login-verification.php';
require_once BCA_PLUGIN_PATH . 'non-admin/non-admin.php';
require_once BCA_PLUGIN_PATH . 'assets/fpdf/fpdf.php';



// Enqueue assets only for plugin pages
add_action('admin_enqueue_scripts', 'bca_enqueue_assets');
add_action('admin_notices', ['BCA_License_Check', 'show_license_notice']);

function bca_enqueue_assets($hook) {
    if (isset($_GET['page']) && $_GET['page'] === 'baar-connect-auth' || (isset($_GET['page']) && $_GET['page'] === 'baar-connect-mfa')) {
        wp_enqueue_script('jquery');  

        wp_enqueue_script('qrcode-js', 'https://cdn.jsdelivr.net/npm/qrcode/build/qrcode.min.js', array('jquery'), null, true);
        wp_enqueue_script( 'bootstrap-js', 'https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js', array('jquery'), null, true );

        wp_enqueue_style('bca-bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css', [], '5.3.0');
        wp_enqueue_script('bca-bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', ['jquery'], '5.3.0', true);
        
        wp_enqueue_script('qrcode-js', 'https://cdn.jsdelivr.net/npm/qrcode/build/qrcode.min.js', [], null, true);
        wp_enqueue_style('bca-custom-style', plugin_dir_url(__FILE__) . 'assets/css/style.css', [], '1.0.0');
        wp_enqueue_script('bca-custom-script', plugin_dir_url(__FILE__) . 'assets/js/script.js', ['jquery'], '1.0.0', true);

        wp_enqueue_style( 'select2-css', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css' );
        wp_enqueue_script( 'select2-js', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js', array( 'jquery' ), null, true );

        wp_enqueue_script('select2', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js', array('jquery'), null, true);
        wp_enqueue_style('select2-css', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css');

        wp_enqueue_style('quill-css', 'https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.snow.css', array(), '2.0.3', 'all');
        wp_enqueue_script('quill-js', 'https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.js', array(), '2.0.3', true);
    

        wp_enqueue_script('bca-tooltip-script', plugin_dir_url(__FILE__) . 'assets/js/tooltip.js', array('jquery', 'bootstrap-js'), null, true);
        // Enqueue your custom JS
        wp_enqueue_script( 'my-plugin-ajax', plugin_dir_url( __FILE__ ) . 'assets/js/ajax.js', array('jquery'), null, true );

        // Localize the script for AJAX
        wp_localize_script( 'my-plugin-ajax', 'myPluginAjax', array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
            'nonce'    => wp_create_nonce('generate_recovery_codes_nonce'), 
            'nonce_brand' => wp_create_nonce('brand_submission_nonce'),
            'nonce_security' => wp_create_nonce('security_questions_nonce'),
            'nonce_push' => wp_create_nonce('push_notification_nonce'),
            'nonce_emailotp'  => wp_create_nonce('email_otp_nonce'), 
            'reset_mfa_nonce' => wp_create_nonce('reset_mfa_nonce'), 
            'generate_qr_nonce' => wp_create_nonce('generate_qr_nonce'),
            'nonce_contact_form' => wp_create_nonce('contact_form_nonce'), 
            'toggle_status_nonce' => wp_create_nonce('toggle_account_status_nonce'),
            'nonce_emailotp_setting_config'  => wp_create_nonce('email_otp_setting_config_nonce'),
        ));
        
    }
}


// Create custom tables on plugin activation
register_activation_hook(__FILE__, 'bca_activate_plugin');
function bca_activate_plugin() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();

    // Master table
    $bca_master = $wpdb->prefix . 'bca_master';
    $sql_bca_master = "CREATE TABLE IF NOT EXISTS $bca_master (
        id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        tenant_name VARCHAR(255) NOT NULL,
        company_email VARCHAR(255) NOT NULL,
        username VARCHAR(255) NOT NULL,
        api_key VARCHAR(255) NOT NULL,
        external_source BOOLEAN DEFAULT FALSE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        modified_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) $charset_collate;";

    // API Entries table
    $bca_api_entries = $wpdb->prefix . 'bca_api_entries';
    $sql_bca_api_entries = "CREATE TABLE IF NOT EXISTS $bca_api_entries (
        id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        tenant_name VARCHAR(255) NOT NULL,
        user_email VARCHAR(255) NOT NULL,
        username VARCHAR(255) NOT NULL,
        default_mfa_method VARCHAR(100) NOT NULL DEFAULT 'totp',
        external_source BOOLEAN DEFAULT FALSE,
        qr_code TEXT DEFAULT NULL,
        qr_status VARCHAR(50) DEFAULT 'not_scanned',
        TOTP INT(6) DEFAULT NULL,
        email_otp INT(6) DEFAULT NULL,
        phone_otp INT(6) DEFAULT NULL,
        auth_type VARCHAR(50) DEFAULT NULL,
        verify VARCHAR(50) DEFAULT NULL,
        force_user VARCHAR(100) DEFAULT NULL, 
        user_status VARCHAR(50) DEFAULT NULL,
        totp_config VARCHAR(100) DEFAULT NULL,
        otpEmail_config VARCHAR(100) DEFAULT NULL,
        pushnotification_config VARCHAR(100) DEFAULT NULL,
        securityQuestion_config VARCHAR(100) DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        modified_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) $charset_collate;";

    $bca_recovery_code = $wpdb->prefix . 'bca_recovery_code';
    $sql_bca_recovery_code = "CREATE TABLE IF NOT EXISTS $bca_recovery_code (
        id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        user_email VARCHAR(100) NOT NULL,
        code_1 VARCHAR(6) NOT NULL,
        code_2 VARCHAR(6) NOT NULL,
        code_3 VARCHAR(6) NOT NULL,
        code_4 VARCHAR(6) NOT NULL,
        code_5 VARCHAR(6) NOT NULL,
        status_1 BOOLEAN DEFAULT FALSE,  
        status_2 BOOLEAN DEFAULT FALSE,  
        status_3 BOOLEAN DEFAULT FALSE,  
        status_4 BOOLEAN DEFAULT FALSE,  
        status_5 BOOLEAN DEFAULT FALSE,  
        recovery_completed BOOLEAN DEFAULT FALSE,
        UNIQUE KEY user_email (user_email)
    ) $charset_collate;";

    $bca_licence_detail = $wpdb->prefix . 'bca_licence_detail';
    $sql_bca_licence_detail = "CREATE TABLE IF NOT EXISTS $bca_licence_detail (
        id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        user_email VARCHAR(100) NOT NULL,
        licence_key VARCHAR(255) NOT NULL,
        api_customer_id INT(11) NOT NULL,
        plan_name VARCHAR(50) NOT NULL,
        licence_expiry_date DATE NOT NULL,
        licence_status VARCHAR(20) NOT NULL,
        site_url VARCHAR(255) NOT NULL,
        max_sites INT(11) NOT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        UNIQUE KEY licence_key (licence_key)
    ) $charset_collate;";


    $bca_brand_details = $wpdb->prefix . 'bca_brand_details';
    $sql_bca_brand_details = "CREATE TABLE IF NOT EXISTS $bca_brand_details (
        id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        brand_name VARCHAR(255) NOT NULL,
        brand_logo VARCHAR(255) NOT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    ) $charset_collate;";



    $bca_email_templates = $wpdb->prefix . 'bca_email_templates';
    $sql_bca_email_templates = "CREATE TABLE IF NOT EXISTS $bca_email_templates (
        id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        template_name VARCHAR(250) NOT NULL,
        email_subject VARCHAR(250) NOT NULL,
        email_message TEXT NOT NULL,  
        from_email VARCHAR(250) NOT NULL,  
        from_name VARCHAR(250) NOT NULL,  
        email_status BOOLEAN DEFAULT FALSE,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP
    ) $charset_collate;";

    // Security Questions table
    $bca_security_questions = $wpdb->prefix . 'bca_user_security_questions';
    $sql_bca_security_questions = "CREATE TABLE IF NOT EXISTS $bca_security_questions (
        id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        user_email VARCHAR(100) NOT NULL,
        question_1 VARCHAR(255) NOT NULL,
        answer_1 TEXT NOT NULL,
        question_2 VARCHAR(255) NOT NULL,
        answer_2 TEXT NOT NULL,
        question_3 VARCHAR(255) NOT NULL,
        answer_3 TEXT NOT NULL,
        question_4 VARCHAR(255) NOT NULL,
        answer_4 TEXT NOT NULL,
        question_5 VARCHAR(255) NOT NULL,
        answer_5 TEXT NOT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        UNIQUE KEY user_email (user_email)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql_bca_master);
    dbDelta($sql_bca_api_entries);
    dbDelta($sql_bca_recovery_code);
    dbDelta($sql_bca_email_templates);
    dbDelta($sql_bca_security_questions);
    dbDelta($sql_bca_licence_detail);
    dbDelta($sql_bca_brand_details);

    // Add debug output
    $bca_api_entries_exist = $wpdb->get_var("SHOW TABLES LIKE '$bca_api_entries'") == $bca_api_entries;
    if (!$bca_api_entries_exist) {
        error_log("Failed to create table: $bca_api_entries_exist");
    }

    $bca_recovery_code_exist = $wpdb->get_var("SHOW TABLES LIKE '$bca_recovery_code'") == $bca_recovery_code;
    if (!$bca_recovery_code_exist) {
        error_log("Failed to create table: $bca_recovery_code_exist");
    }

    // Set default plugin settings in WordPress options table
    $default_settings = array(
        'promptSetup' => 'on'
    );

    // Get current value of 'bca_settings'
    $current_settings = get_option('bca_settings');
    if ($current_settings === false) {
        add_option('bca_settings', $default_settings);
    } else {
        if (!isset($current_settings['promptSetup'])) {
            $current_settings['promptSetup'] = 'on';
        }
        update_option('bca_settings', $current_settings);
    }

    if (function_exists('bca_create_tenant_on_activation')) {
        bca_create_tenant_on_activation();
    }
}

// Handle deactivation
register_deactivation_hook(__FILE__, 'bca_deactivate_plugin');
function bca_deactivate_plugin() {
    
}

// Handle uninstall (delete plugin data)
register_uninstall_hook(__FILE__, 'bca_uninstall_plugin');
function bca_uninstall_plugin() {
    global $wpdb;

    // Drop tables
    $bca_api_entries_table = $wpdb->prefix . 'bca_api_entries';
    $wpdb->query("DROP TABLE IF EXISTS $bca_api_entries_table");

    $bca_email_templates_table = $wpdb->prefix . 'bca_email_templates';
    $wpdb->query("DROP TABLE IF EXISTS $bca_email_templates_table");

    $bca_user_security_questions_table = $wpdb->prefix . 'bca_user_security_questions';
    $wpdb->query("DROP TABLE IF EXISTS $bca_user_security_questions_table");

    $bca_recovery_code_table = $wpdb->prefix . 'bca_recovery_code';
    $wpdb->query("DROP TABLE IF EXISTS $bca_recovery_code_table");

    $bca_licence_detail_table = $wpdb->prefix . 'bca_licence_detail';
    $wpdb->query("DROP TABLE IF EXISTS $bca_licence_detail_table");

    $bca_brand_details_table = $wpdb->prefix . 'bca_brand_details';
    $wpdb->query("DROP TABLE IF EXISTS $bca_brand_details_table");

    // Delete usermeta records with key '_setup_later_date'
    $wpdb->delete(
        $wpdb->prefix . 'usermeta',
        array( 'meta_key' => '_setup_later_date' ),
        array( '%s' )
    );

    // Delete the 'bca_settings' option from wp_options
    if ( get_option( 'bca_settings' ) !== false ) {
        delete_option( 'bca_settings' );
        // Option successfully deleted
        error_log( 'bca_settings option deleted.' );
    } else {
        // Option did not exist
        error_log( 'bca_settings option not found.' );
    }
}


// Add Admin Menu
add_action('admin_menu', 'bca_admin_menu');
function bca_admin_menu() {
    add_menu_page(
        'BAAR MFA',
        'BAAR MFA',
        'manage_options',
        'baar-connect-auth',
        'bca_render_admin_page',
        'dashicons-lock',
        80
    );
}

// Function to create tenant on plugin activation
function bca_create_tenant_on_activation() {
    $site_name = get_bloginfo('name');  
    // Remove any special characters and spaces
    $company_name = preg_replace('/[^a-zA-Z0-9]/', '', $site_name);
    // $company_email = wp_get_current_user()->user_email;  
    $company_email = get_option('admin_email');

    if (empty($company_email)) {
        return;
    }

    $response = bca_create_tenant($company_name, $company_email);

    if (is_wp_error($response)) {
        error_log('Error creating tenant: ' . $response->get_error_message());
    } else {
        error_log('Tenant created successfully: ' . $company_name);
    }
}


function bca_render_admin_page() {
    $active_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'settings';

    echo '<div class="wrap container">
            <div class="auth-icon me-3 d-flex align-items-center bca-main-title-div">
            <img src="' . esc_url(plugin_dir_url(__FILE__) . '/assets/images/logo.webp') . '" alt="BAAR-IGA" width="32" height="32" />
            <h1 class="bca-main-title">BAAR MFA</h1>
            </div>

            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a class="nav-link ' . ($active_tab === 'settings' ? 'active' : '') . '" href="?page=baar-connect-auth&tab=settings">Settings</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link ' . ($active_tab === 'mfa' ? 'active' : '') . '" href="?page=baar-connect-auth&tab=mfa">MFA</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link ' . ($active_tab === 'email' ? 'active' : '') . '" href="?page=baar-connect-auth&tab=email">Email Settings</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link ' . ($active_tab === 'report' ? 'active' : '') . '" href="?page=baar-connect-auth&tab=report">Report</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link ' . ($active_tab === 'pro' ? 'active' : '') . '" href="?page=baar-connect-auth&tab=pro">Upgrade</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link ' . ($active_tab === 'account' ? 'active' : '') . '" href="?page=baar-connect-auth&tab=account">Account</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link ' . ($active_tab === 'brand' ? 'active' : '') . '" href="?page=baar-connect-auth&tab=brand">Brand Setting</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link ' . ($active_tab === 'faq' ? 'active' : '') . '" href="?page=baar-connect-auth&tab=faq">FAQ & Support</a>
                </li>
            </ul>';

    switch ($active_tab) {
        case 'mfa':
            BCA_MFA::render_tab();
            break;
        case 'email':
            BCA_EmailSetting::render_tab();
            break;
        case 'report':
            BCA_Report::render_tab();
            break;
        case 'pro':
            BCA_Pro::render_tab();
            break;
        case 'account':
            BCA_Account::render_tab();
            break;
        case 'brand':
            BCA_Brand_Account::render_tab();
            break;
        case 'faq':
            BCA_FAQ::render_tab();
            break;
        case 'settings':
        default:
            BCA_Settings::render_tab();
            break;
    }

    echo '</div>';
}

?>
