jQuery(document).ready(function ($) {
    console.log("Baar Connect Auth script loaded.");
});

jQuery(document).ready(function() {
    jQuery('#userInput').select2();
    jQuery('#roleInput').select2();
});

// start Function to toggle enabling/disabling checkboxes based on the radio selection
function toggleRecoveryOptions() {
    const recoveryCodesRadio = document.getElementById('recoveryCodes');
    const generateRecoveryCodesRadio = document.getElementById('generateRecoveryCodes');
    const recoveryOptionsDiv = document.getElementById('recoveryOptions');

    if (generateRecoveryCodesRadio.checked) {
        recoveryOptionsDiv.style.display = 'block'; // Show checkboxes
    } else {
        recoveryOptionsDiv.style.display = 'none'; // Hide checkboxes
    }
}


// start Function to toggle enabling/disabling the grace period input based on radio selection
function toggleGracePeriodInput() {
    const enforceLoginRadio = document.getElementById('enforceLogin');
    const enforceGraceRadio = document.getElementById('enforceGrace');
    const gracePeriodInput = document.getElementById('gracePeriodDays');

    if (enforceGraceRadio.checked) {
        gracePeriodInput.disabled = false; // Enable the input
    } else {
        gracePeriodInput.disabled = true; // Disable the input
    }
}

// Function to restrict the input to only two digits
function validateGracePeriodInput(event) {
    const input = event.target;
    // Ensure the input is only two digits (numeric values)
    input.value = input.value.replace(/[^0-9]/g, '').slice(0, 2);
}

// Initial call to set the correct state of the input field when the page loads
document.addEventListener('DOMContentLoaded', function () {
    toggleGracePeriodInput(); // Check the initial radio selection
});


// Who Should Be Prompted for MFA Setup based on the radio selection
jQuery(document).ready(function ($) {
    var selectedValue = $('input[name="bca_settings[userSelection]"]:checked').val();
    if (selectedValue == 'specificUser') {
        $('#multiselect-promptusersetuproles').css("pointer-events", "");
        $('input[name="bca_settings[promptusersetuproles][]"]').removeAttr('disabled');
    } else {
        $('#multiselect-promptusersetuproles').css("pointer-events", "none");
        $('input[name="bca_settings[promptusersetuproles][]"]').attr('disabled', 'disabled');
    }
    $('input[name="bca_settings[userSelection]"]').click(function () {
        var value = $(this).attr("value");
        if (value == 'specificUser') {
            $('#multiselect-promptusersetuproles').css("pointer-events", "");
            $('input[name="bca_settings[promptusersetuproles][]"]').removeAttr('disabled');
        } else {
            $('#multiselect-promptusersetuproles').css("pointer-events", "none");
            $('input[name="bca_settings[promptusersetuproles][]"]').attr('disabled', 'disabled');
        }
    });
});

// start Function to toggle the state of checkboxes based on selected radio button
function toggleUserRoleCheckboxes() {
    const allUsersPromptRadio = document.getElementById('allUsersPrompt');
    const userRoles = document.getElementById('userRoles');
    const checkboxes = userRoles.querySelectorAll('input[type="checkbox"]');

    if (allUsersPromptRadio.checked) {
        checkboxes.forEach(checkbox => {
            checkbox.checked = false;
            checkbox.disabled = true;
        });
    } else {
        checkboxes.forEach(checkbox => {
            checkbox.disabled = false;
        });
    }
}

document.addEventListener('DOMContentLoaded', function () {
    toggleUserRoleCheckboxes(); 
});


// Who Needs to Set Up MFA based on the selected radio button
jQuery(document).ready(function($) {
    var selectedValue = $('input[name="bca_settings[enforceOn]"]:checked').val();
    if (selectedValue == 'selectedUsers') {
        $('.multiselect-users').css("pointer-events", "");
        $('#multiselect-selectedRoles').css("pointer-events", "");
        $('input[name="bca_settings[selectedUsers][]"]').removeAttr('disabled');
        $('input[name="bca_settings[selectedRoles][]"]').removeAttr('disabled');
    } else {
        $('.multiselect-users').css("pointer-events", "none");
        $('#multiselect-selectedRoles').css("pointer-events", "none");
        $('input[name="bca_settings[selectedUsers][]"]').attr('disabled', 'disabled');
        $('input[name="bca_settings[selectedRoles][]"]').attr('disabled', 'disabled');
    }
    $('input[name="bca_settings[enforceOn]"]').click( function() {
        var value = $(this).attr("value");
        if (value == 'selectedUsers') {
            $('.multiselect-users').css( "pointer-events", "" );
            $('#multiselect-selectedRoles').css("pointer-events", "");
            $('input[name="bca_settings[selectedUsers][]"]').removeAttr('disabled');
            $('input[name="bca_settings[selectedRoles][]"]').removeAttr('disabled');
        } else {
            $('.multiselect-users').css( "pointer-events", "none" );
            $('#multiselect-selectedRoles').css("pointer-events", "none");
            $('input[name="bca_settings[selectedUsers][]"]').attr('disabled', 'disabled');
            $('input[name="bca_settings[selectedRoles][]"]').attr('disabled', 'disabled');
        }
    });     
});

// start Function to toggle the state of user and role input fields based on the selected radio button
function toggleUserRoleInputs() {
    const allUsersRadio = document.getElementById('allUsers');
    const selectedUsersRadio = document.getElementById('selectedUsers');
    const noEnforceRadio = document.getElementById('noEnforce');
    const userInput = document.getElementById('userInput');
    const roleInput = document.getElementById('roleInput');

    if (allUsersRadio.checked || noEnforceRadio.checked) {
        
        userInput.disabled = true;
        roleInput.disabled = true;
        userInput.value = ''; 
        roleInput.value = '';  
    } else if (selectedUsersRadio.checked) {
        userInput.disabled = false;
        roleInput.disabled = false; 
    }
}

document.addEventListener('DOMContentLoaded', function () {
    toggleUserRoleInputs(); 
});

// Redirect Users After MFA Setup based on the selected radio button
jQuery(document).ready(function ($) {
    var selectedValue = $('input[name="bca_settings[redirectUser]"]:checked').val();
    if (selectedValue == 'redirectYes') {
        $('input[name="bca_settings[redirectAfterMFA]"]').removeAttr('disabled');
    } else {
        $('input[name="bca_settings[redirectAfterMFA]"]').attr('disabled', 'disabled');
    }
    $('input[name="bca_settings[redirectUser]"]').click(function () {
        var value = $(this).attr("value");
        if (value == 'redirectYes') {
            $('input[name="bca_settings[redirectAfterMFA]"]').removeAttr('disabled');
        } else {
            $('input[name="bca_settings[redirectAfterMFA]"]').attr('disabled', 'disabled');
        }
    });
});

// Require MFA Setup based on the selected radio button
jQuery(document).ready(function ($) {
    var selectedValue = $('input[name="bca_settings[enforceSetup]"]:checked').val();
    if (selectedValue == 'canComplete') {
        $('input[name="bca_settings[gracePeriodDays]"]').removeAttr('disabled');
    } else {
        $('input[name="bca_settings[gracePeriodDays]"]').attr('disabled', 'disabled');
    }
    $('input[name="bca_settings[enforceSetup]"]').click(function () {
        var value = $(this).attr("value");
        if (value == 'canComplete') {
            $('input[name="bca_settings[gracePeriodDays]"]').removeAttr('disabled');
        } else {
            $('input[name="bca_settings[gracePeriodDays]"]').attr('disabled', 'disabled');
        }
    });
});

// mfa tab card active 
function activateCard(cardId) {
    // Remove the active class from all cards
    const cards = document.querySelectorAll('.card');
    cards.forEach(card => {
        card.classList.remove('active-card');
    });

    // Add the active class to the clicked card
    const activeCard = document.getElementById(cardId);
    activeCard.classList.add('active-card');
}


// faq and support tab 
// jQuery(document).ready(function($) {
//     $('#supportcontactForm').submit(function(e) {
//         e.preventDefault(); // Prevent the form from submitting normally
//         var formData = $(this).serialize(); // Serialize form data

//         // Show the loader inside the button and disable the submit button
//         $('#loader').show();
//         $('.submit-btn').prop('disabled', true); // Disable submit button
//         $('.submit-btn span').text('Submitting...'); // Change button text to 'Submitting...'

//         $.ajax({
//             type: 'POST',
//             url: myPluginAjax.ajax_url, // Use the localized URL
//             data: {
//                 action: 'baar_content_auth_send_mail', // The action hook
//                 form_data: formData // The serialized form data
//             },
//             success: function(response) {
//                 // Hide the loader and enable the submit button
//                 $('#loader').hide();
//                 $('.submit-btn').prop('disabled', false); // Enable submit button
//                 $('.submit-btn span').text('Submit'); // Reset button text to 'Submit'

//                 if (response.status === 'success') {
//                     document.getElementById('confirmationMessage').style.display = 'block';
//                     document.getElementById('supportcontactForm').style.display = 'none';
//                     $('#supportcontactForm')[0].reset(); // Optionally reset the form
//                 } else {
//                     $('#confirmationMessage').text(response.message).show();
//                 }
//             },
//             error: function() {
//                 // Hide the loader and enable the submit button
//                 $('#loader').hide();
//                 $('.submit-btn').prop('disabled', false); // Enable submit button
//                 $('.submit-btn span').text('Submit'); // Reset button text to 'Submit'
//                 $('#confirmationMessage').text('There was an error submitting the form. Please try again.').show();
//             }
//         });
//     });
// });


// Pro version tab
// For the first price section (base_st)
function updatePrice(noOfSitesId, basePriceId, priceId) {
    jQuery(noOfSitesId).change(function() {
        console.log("It's working");
        var selectedSites = jQuery(this).val();
        var basePriceText = jQuery(basePriceId).text();
        var basePrice = parseFloat(basePriceText.replace('$', '').trim());
        if (selectedSites) {
            jQuery(basePriceId).parent().hide();
            jQuery(priceId).parent().show();
            var totalPrice = selectedSites * basePrice;
        }
        jQuery(priceId).text('$' + totalPrice.toFixed(2));
    });
}
// For the first price section (base_st)
updatePrice('#no_of_sites_st', '#priceAmountbase_st', '#priceAmount_st');
updatePrice('#no_of_sites_pre', '#priceAmountbase_pre', '#priceAmount_pre');
updatePrice('#no_of_sites_ent', '#priceAmountbase_ent', '#priceAmount_ent');






// Account tab 
document.getElementById('accountTabForm').addEventListener('submit', function(e) {
    e.preventDefault();
    // Add your form submission logic here
    alert('Form submitted successfully!');
});

