jQuery(document).ready(function($) {
    $('#baarIgaAuth').on('click', function(e) {
        e.preventDefault();

        $('#qrCodeContainer1').html('<div>Loading...</div>');
        $.ajax({
            url: myPluginAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'configure_authenticator',
            },
            success: function(response) {
                console.log(response); 
            
                if (response.success) {
                    if (response.data.qr_code_data) {
                        var qrCodeData = response.data.qr_code_data;
            
                        console.log('QR Code Data:', qrCodeData); 

                        if (qrCodeData === 'scanned') {
                            $('#qrCodeContainer').hide(); // This hides the entire QR code container
                            $('#qrCodeGenerateContainer').show();
                        } else {
                            // Otherwise, display the QR code
                            $('#qrCodeGenerateContainer').hide();
                            $('#qrCodeContainer1').empty();
                            var imgTag = $('<img />', {
                                src: qrCodeData, 
                                alt: 'QR Code',
                                width: '200', 
                                height: '200' 
                            });
            
                            $('#qrCodeContainer1').append(imgTag);
                        }
            
                    } else {
                        $('#qrCodeContainer1').html('<div>No QR code data received.</div>');
                    }
                } else {
                    $('#qrCodeContainer1').html('<div>' + response.data.message + '</div>');
                }
            },
            error: function() {
                $('#qrCodeContainer1').html('<div>Something went wrong. Please try again later.</div>');
            }
        });
    });
});


// TOTP verification 
jQuery(document).ready(function($) {
    $('#verify-otp-form').on('submit', function(e) {
        e.preventDefault();

        var otpCode = $('#otp_code').val(); 

        // Make the AJAX request
        $.ajax({
            url: myPluginAjax.ajax_url,
            method: 'POST',
            data: {
                action: 'verify_totp', // The action we'll use in PHP to handle this request
                otp_code: otpCode // Passing the OTP correctly
            },
            beforeSend: function() {
                $('#totp-response-message').text('Verifying...');
            },
            success: function(response) {
                console.log('AJAX Response:', response); // Ensure we have the correct response structure

                // Check for successful authentication and correct OTP
                if (response.success && response.data.status === 'success') {
                    $('#totp-response-message').html('<div class="alert alert-success">Successfully authenticated!</div>');
                } else if (response.success && response.data.status === 'error') {
                    // If status is error but success flag is true
                    $('#totp-response-message').html('<div class="alert alert-danger">Incorrect TOTP. Please try again.</div>');
                } else {
                    // In case something unexpected happens
                    $('#totp-response-message').html('<div class="alert alert-danger">An unexpected error occurred. Please try again later.</div>');
                }
            },
            error: function() {
                $('#totp-response-message').html('<div class="alert alert-danger">Something went wrong. Please try again later.</div>');
            }
        });
    });
});



//functions for OTP verfication throught Email
document.addEventListener('DOMContentLoaded', function () {
    // Send OTP Button
    document.getElementById('sendOtpButton').addEventListener('click', function () {
        var email = document.getElementById('email').value;

        // Send OTP to the email using AJAX
        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'send_otp',
                email: email
            },
            success: function (response) {
                if (response.success) {
                    // Show OTP Modal
                    alert('OTP sent successfully');
                    $('#otpModal').modal('show');
                } else {
                    console.log('Error: ', response);
                    alert('Error: ' + response.data.message);
                }
            }
        });
    });

    // OTP Form Submission
    document.getElementById('otpForm').addEventListener('submit', function (e) {
        e.preventDefault();

        var otpInput = document.getElementById('otpInput').value;

        // Validate OTP
        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'verify_otp',
                otp: otpInput
            },
            success: function (response) {
                if (response.success) {
                    alert('OTP Verified!');
                    $('#otpModal').modal('hide');
                } else {
                    document.getElementById('otpErrorMessage').style.display = 'block';
                }
            }
        });
    });

    // Resend OTP
    document.getElementById('resendOtp').addEventListener('click', function () {
        var email = document.getElementById('email').value;
        
        // Resend OTP
        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'resend_otp',
                email: email
            },
            success: function (response) {
                if (response.success) {
                    alert('OTP Sent Again!');
                } else {
                    alert(response.message);
                }
            }
        });
    });
});

const collapseButtons = document.querySelectorAll('[data-bs-toggle="collapse"]');
  
  collapseButtons.forEach(button => {
    button.addEventListener('click', function() {
      // Get the target modal (collapse)
      const targetCollapse = document.querySelector(this.getAttribute('data-bs-target'));

      // Close all other modals (collapses) except the one being clicked
      document.querySelectorAll('.collapse').forEach(collapse => {
        if (collapse !== targetCollapse) {
          const collapseInstance = bootstrap.Collapse.getInstance(collapse);
          if (collapseInstance) collapseInstance.hide();
        }
      });

      // Toggle the current target modal
      const collapseInstance = bootstrap.Collapse.getInstance(targetCollapse);
      if (collapseInstance) {
        collapseInstance.toggle();
      } else {
        new bootstrap.Collapse(targetCollapse).show();
      }
    });
  });


// Generate QR code 

jQuery(document).ready(function($) {
    $('#qrCodeGenerateContainerBtn').on('click', function(e) {
        e.preventDefault();

        // Show the <p> tag and set the text to "Generating QR code for you..."
        $('#statusMessage').show().text('Generating QR code for you...').css('color', 'black'); // Default color

        // Send an AJAX request
        $.ajax({
            url: myPluginAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'generate_qr_code', // Action hook for PHP
                nonce: myPluginAjax.generate_qr_nonce, // Send the nonce to validate on server side
            },
            success: function(response) {
                if (response.success) {
                    // Show success message in the <p> tag, color green, font size 17px
                    $('#statusMessage').text('Successfully generated QR code.')
                        .css('color', 'green') // Success color
                        .css('font-size', '17px');

                    // Refresh the page after 2 seconds
                    setTimeout(function() {
                        location.reload(); // Refresh the page
                    }, 2000);
                } else {
                    // Show error message in the <p> tag, color red, font size 17px
                    $('#statusMessage').text('Error: ' + response.data.message)
                        .css('color', 'red') // Error color
                        .css('font-size', '17px');
                }
            },
            error: function() {
                // Show error message in the <p> tag, color red, font size 17px
                $('#statusMessage').text('An error occurred while generating the QR Code.')
                    .css('color', 'red') // Error color
                    .css('font-size', '17px');
            }
        });
    });
});

  

//   recovery code ajx 

jQuery(document).ready(function($) {
    // Recovery code generation
    $('#generate-recovery-codes').on('click', function(e) {
        e.preventDefault();

        var nonce = myPluginAjax.nonce;  // Get the nonce value from localized script

        // AJAX call to check if previous codes are verified and generate new ones
        $.ajax({
            url: myPluginAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'generate_new_recovery_codes',
                nonce: nonce
            },
            success: function(response) {
                if (response.success) {
                    // Display the generated codes
                    $('#recovery-codes-output').html('<p class="text-success" style="font-weight: 500; font-size: 17px; color: green;">Successfully generated recovery codes:</p>') + 
                        // response.data.codes.map(function(code) {
                        //     return '<li>' + code + '</li>';
                        // }).join('') + '</ul>');

                        setTimeout(function() {
                            location.reload(); // Refresh the page
                        }, 2000);
                    
                    // Optionally display a QR Code here as well
                    $('#qr-code-container').html('<img src="' + response.data.qr_code_url + '" alt="QR Code">');
                } else {
                    alert(response.data.message);  // Display the error message
                }
            },
            error: function() {
                alert('An error occurred');
            }
        });
    });

    // Code verification
    $('#verify-recovery-code-form').on('submit', function(e) {
        e.preventDefault();
        
        var nonce = myPluginAjax.nonce;  // Get the nonce value from localized script
        var recoveryCode = $('#recovery-code').val(); // Get entered code

        // AJAX call to verify the recovery code
        $.ajax({
            url: myPluginAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'verify_recovery_code',   // New action for verification
                nonce: nonce,
                recovery_code: recoveryCode
            },
            success: function(response) {
                if (response.success) {
                    $('#verify-response').html('<p>Code Verified Successfully!</p>');
                } else {
                    $('#verify-response').html('<p>' + response.data.message + '</p>');
                }
            },
            error: function() {
                alert('An error occurred');
            }
        });
    });

    // Download PDF functionality
    $('#download-recovery-codes').on('click', function(e) {
        e.preventDefault();
        var nonce = myPluginAjax.nonce;  // Get the nonce value from localized script

        // Make AJAX request to generate the PDF and download it
        $.ajax({
            url: myPluginAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'download_recovery_codes_pdf',  // Action for PDF download
                nonce: nonce
            },
            success: function(response) {
                if (response.success) {
                    window.open(response.data.download_url, '_blank');
                    window.open(response.data.download_url, '_blank');
                } else {
                    alert(response.data.message);  // Show error message if any
                }
            },
            error: function() {
                alert('An error occurred while generating the PDF.');
            }
        });
    });

    // Send recovery codes via email functionality
    $('#send-recovery-codes-email').on('click', function(e) {
        e.preventDefault();

        var nonce = myPluginAjax.nonce;  // Get the nonce value from localized script

        // Make AJAX request to send the recovery codes via email
        $.ajax({
            url: myPluginAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'send_recovery_codes_email',  // Action for sending email
                nonce: nonce
            },
            success: function(response) {
                if (response.success) {
                    alert('Recovery codes sent to your email!');
                } else {
                    alert(response.data.message);  // Show error message if any
                }
            },
            error: function() {
                alert('An error occurred while sending the email.');
            }
        });
    });
});


jQuery(document).ready(function($) {
    // Push Notification Authentication
    $('#push-notification-auth').on('click', function(e) {
        e.preventDefault();

        var noncePush  = myPluginAjax.nonce_push;  // Get the nonce value from localized script

        // AJAX call to initiate push notification and check auth response
        $.ajax({
            url: myPluginAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'push_notification_auth',  // Custom action name
                nonce: noncePush
            },
            success: function(response) {
                console.log('AJAX Response:', response);

                // Check for success or error
                var outputDiv = $('#push-notification-output');

                if (response.success) {
                    // Green message for ACCEPT
                    outputDiv.html('<p style="color: green;">' + response.data.message + '</p>');
                } else {
                    // Red message for REJECT and TIMEOUT
                    outputDiv.html('<p style="color: red;">' + response.data.message + '</p>');
                }
            },
            error: function() {
                alert('An error occurred');
            }
        });
    });
});



// Email OTP Verification code 
// jQuery(document).ready(function($) {
//     // Send OTP email
//     $('#testEmailButton').on('click', function() {
//         var email = $('#testEmail').val();
        
//         if (email) {
//             var nonce = myPluginAjax.nonce_emailotp;  // Get the correct nonce value for OTP

//             // Send the email via AJAX
//             $.ajax({
//                 url: myPluginAjax.ajax_url,
//                 type: 'POST',
//                 data: {
//                     action: 'send_otp_email',  // Custom action for sending OTP
//                     nonce: nonce,
//                     email: email,
//                 },
//                 success: function(response) {
//                     if (response.success) {
//                         $('#otpContainer').show();
//                         alert('OTP sent to your email. Please check your inbox.');
//                     } else {
//                         alert('There was an error sending the OTP. Please try again.');
//                     }
//                 },
//                 error: function() {
//                     alert('An error occurred.');
//                 }
//             });
//         } else {
//             alert('Please enter a valid email.');
//         }
//     });

//     // Verify OTP
//     $('#verifyOtpButton').on('click', function() {
//         var otp = $('#otp').val();
//         var email = $('#testEmail').val();
//         var nonce = myPluginAjax.nonce_emailotp;  // Get the correct nonce value for OTP verification

//         if (otp) {
//             // Verify the OTP via AJAX
//             $.ajax({
//                 url: myPluginAjax.ajax_url,
//                 type: 'POST',
//                 data: {
//                     action: 'email_verify_otp',  // Custom action for verifying OTP
//                     nonce: nonce,
//                     email: email,
//                     otp: otp,
//                 },
//                 success: function(response) {
//                     if (response.success) {
//                         alert('OTP verified successfully!');
//                     } else {
//                         alert('Invalid OTP. Please try again.');
//                     }
//                 },
//                 error: function() {
//                     alert('An error occurred.');
//                 }
//             });
//         } else {
//             alert('Please enter the OTP.');
//         }
//     });
// });



// Security querion 

jQuery(document).ready(function($) {
    $('#security-questions-form').on('submit', function(e) {
        e.preventDefault();  // Prevent the form from submitting normally (this should prevent GET)

        var nonceSecurity = myPluginAjax.nonce_security;  // Get the nonce value from localized script

        var formData = $(this).serialize();  // Serialize the form data

        // Perform the AJAX request
        $.ajax({
            url: myPluginAjax.ajax_url,  // WordPress AJAX URL
            method: 'POST',  // Make sure the method is POST
            data: {
                action: 'submit_security_questions',  // Custom action name
                nonce: nonceSecurity,  // Send the nonce for security validation
                form_data: formData  // Send the serialized form data
            },
            success: function(response) {
                // Handle the response from the PHP function
                console.log(response);
                if(response.success) {
                    $('#security-questions-form').before('<div class="alert alert-success mt-3" id="successMessage">Security questions saved successfully!</div>');
                    
                    setTimeout(function() {
                        location.reload(); // Refresh the page after 2 seconds
                    }, 2000);
                } else {
                    $('#security-questions-form').before('<div class="alert alert-danger mt-3" id="errorMessage">There was an error saving your security questions. Please try again.</div>');
                }
            },
            error: function(xhr, status, error) {
                $('#security-questions-form').before('<div class="alert alert-danger mt-3" id="errorMessage">An error occurred: ' + error + '</div>');
            }
        });
    });
});


jQuery(document).ready(function($) {
    // Fetch existing answers when the page loads
    $.ajax({
        url: myPluginAjax.ajax_url,  // WordPress AJAX URL
        method: 'POST',
        data: {
            action: 'fetch_security_questions',  // New AJAX action to fetch data
            nonce: myPluginAjax.nonce_security  // Nonce for security
        },
        success: function(response) {
            if (response.success) {
                // Pre-fill the form with saved data
                var data = response.data;
                $('#answer_1').val(data.answer_1);
                $('#answer_2').val(data.answer_2);
                $('#answer_3').val(data.answer_3);
                $('#answer_4').val(data.answer_4);
                $('#answer_5').val(data.answer_5);
            } else {
                console.log('No data found or an error occurred.');
            }
        },
        error: function(xhr, status, error) {
            console.log('An error occurred: ' + error);
        }
    });
});


// Email setting tab
jQuery(document).ready(function($) {
    $('#email_template_Settings_Form').on('submit', function(e) {
        e.preventDefault();
        
        // var fromEmail = $('input[name="from_email"]').val();
        var fromName = $('input[name="from_name"]').val();

        $('.email_template_name').each(function(index, elem) {
            var templateName = $(elem).text().trim();
            var subject = $('input[name="email_template_subject"]').eq(index).val(); 
            var message = $('#editor' + (index + 1)).html();
            console.log('Sending data for template: ', templateName, formData); 
            
            // var status = $('input[name="email_template_status"]:eq(' + index + ')').is(':checked') ? 1 : 0; // Get template status
            var formData = {
                email_template_name: templateName,
                email_template_subject: subject,
                email_template_message: message,
                // from_email: fromEmail, 
                from_name: fromName, 
                action: 'save_single_email_template'
            };
            console.log(formData);
            $.ajax({
                url: myPluginAjax.ajax_url,  
                type: 'POST',
                data: formData,
                success: function(response) {
                    if (response.success) {
                        // Display success message in the #EmailMessage div
                        $("#EmailMessage").html('<div class="alert alert-success">Template saved successfully!</div>');
                        
                        $('html, body').animate({
                            scrollTop: $("#EmailMessage").offset().top
                        }, 100);  // 1000 is the speed of the scroll (1 second)

                    } else {
                        $("#EmailMessage").html('<div class="alert alert-danger">Failed to save the Template.</div>');
                        
                        $('html, body').animate({
                            scrollTop: $("#EmailMessage").offset().top
                        }, 100);  // 1000 is the speed of the scroll (1 second)
                    }
                },
                error: function(error) {
                    // console.error('AJAX error:', error);
                    $("#EmailMessage").html('<div class="alert alert-danger">An error occurred while saving the template.</div>');
                    
                    $('html, body').animate({
                        scrollTop: $("#EmailMessage").offset().top
                    }, 100);  // 1000 is the speed of the scroll (1 second)
                }
            });
        });
    });
});


jQuery(document).ready(function($) {
    // Show/hide the test email section when the "Send test email" button is clicked
    $('#sendTestEmailBtn').on('click', function() {
        $('#testEmailSection').collapse('toggle'); // Toggle visibility of the test email section
    });

    // Fetch the template names from the server
    $.ajax({
        url: myPluginAjax.ajax_url,  // Use the ajax_url provided by WordPress
        type: 'POST',
        data: {
            action: 'get_email_templates'  // This should match the action defined in the PHP
        },
        success: function(response) {
            if (response.success) {
                // Populate the dropdown with the fetched template names
                var templates = response.data.templates;
                templates.forEach(function(template) {
                    // Add each template as an option to the dropdown
                    $('#templateSelect').append(new Option(template.template_name, template.template_name));
                });
            } else {
                console.error('Error fetching templates: ' + response.data.message);
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX error:', error);
            alert('An error occurred while fetching email templates.');
        }
    });

    // Handle sending the test email when the "Send Test Email" button is clicked
    $('#sendTestEmail').on('click', function() {
        var selectedTemplate = $('#templateSelect').val();
        var fromEmail = $('#fromEmail').val();
        var fromName = $('#fromName').val();

        var formData = {
            template_name: selectedTemplate,
            from_test_email: fromEmail,
            from_test_name: fromName,
            action: 'send_test_email'  
        };

        // Send the request to the server to send the test email
        $.ajax({
            url: myPluginAjax.ajax_url,
            type: 'POST',
            data: formData,
            success: function(response) {
                if (response.success) {
                    alert('Test email sent successfully!');
                } else {
                    alert('Failed to send test email: ' + response.data.message);
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX error:', error);
                alert('An error occurred while sending the test email.');
            }
        });
    });
});


// Handle OTP sending to the mail setting configure tab

jQuery(document).ready(function($) {
    $('#sendOtpButton').click(function() {
        var email = $('#email').val();
        var nonceEmailOtp = myPluginAjax.nonce_emailotp_setting_config;
        $('#otpMessage').text('Sending OTP...').css('color', 'black');
        
        // Send the AJAX request to send the OTP
        $.ajax({
            type: 'POST',
            url: myPluginAjax.ajax_url,
            data: {
                action: 'bca_send_email_setting_otp',
                email: email,
                nonce: nonceEmailOtp 
            },
            success: function(response) {
                if (response.success) {
                    // OTP successfully resent, show confirmation message
                    $('#otpMessage').text('OTP sent successfully! Email delivery depends on your SMTP setup.').css('color', 'green');
                } else {
                    // Handle errors, e.g., if OTP could not be resent
                    $('#otpMessage').text(response.data.message).css('color', 'red');
                }
            },
            error: function() {
                $('#otpMessage').text('An error occurred while resending the OTP.').css('color', 'red');
            }
        });
    });
});

jQuery(document).ready(function($) {
    // When the resend OTP link is clicked
    $('#resendOtp').click(function(e) {
        e.preventDefault();  // Prevent the default link behavior
        
        var email = $('#email').val();  // Get the email address (or other identifier)
        var nonceEmailOtp = myPluginAjax.nonce_emailotp_setting_config;

         // Change the modal header to "Sending OTP"
         $('#otpMessage').text('Sending OTP...').css('color', 'black');

        // Send AJAX request to resend the OTP
        $.ajax({
            type: 'POST',
            url: myPluginAjax.ajax_url,
            data: {
                action: 'bca_resend_email_setting_otp',  // Action for the resend OTP
                email: email,
                nonce: nonceEmailOtp
            },
            success: function(response) {
                if (response.success) {
                    // OTP successfully resent, show confirmation message
                    $('#otpMessage').text('OTP has been resent successfully!').css('color', 'green');
                    
                } else {
                    // Handle errors, e.g., if OTP could not be resent
                    $('#otpMessage').text(response.data.message).css('color', 'red');
                    
                }
            },
            error: function() {
                $('#otpMessage').text('An error occurred while resending the OTP.').css('color', 'red');     
            }
        });
    });

    // Submit OTP to verify
    $('#otpModal form').submit(function(e) {
        e.preventDefault();  // Prevent the default form submission
        
        var otp = $('#otpInput').val();
        var nonceEmailOtp = myPluginAjax.nonce_emailotp_setting_config;  

        // Send the AJAX request to verify the OTP
        $.ajax({
            type: 'POST',
            url: myPluginAjax.ajax_url,
            data: {
                action: 'bca_verify_email_setting_otp',
                otp: otp,
                nonce: nonceEmailOtp 
            },
            success: function(response) {
                if (response.success) {
                    // OTP is verified successfully
                    $('#otpModalLabel').text('OTP Verified! Your email is successfully configured.');

                    // Close the modal after a brief delay
                    setTimeout(function() {
                        $('#otpModal').modal('hide');  // Close the modal
                    }, 2000);  // Close after 2 seconds (adjust time as needed)
                } else {
                    // Show error message if OTP is incorrect
                    $('#otpErrorMessage').text('Incorrect OTP. Please enter the correct OTP.').show();
                }
            },
            error: function() {
                alert('An error occurred while verifying the OTP.');
            }
        });
    });
});



// license_key validation 

jQuery(document).ready(function($) {
    // On page load, check if the license is already activated
    // $.ajax({
    //     url: ajaxurl, // WordPress AJAX URL
    //     method: 'POST',
    //     data: {
    //         action: 'check_license_status', // Custom action to check license status
    //     },
    //     success: function(response) {
    //         if (response.success) {
    //             // License is activated, update the input field and show the success message
    //             $('#license_key').val(response.data.license_key).prop('readonly', true); // Populate and disable the input field
    //             $('#activation_message').text('Your key is activated successfully.').css('color', 'green'); // Show success message
    //             // $('#activate_license_btn').hide(); // Hide the activation button
    //         } else {
    //             // License not activated, show form and allow activation
    //             $('#activation_message').text('Please enter your license key to activate.').css('color', 'black');
    //         }
    //     },
    //     error: function() {
    //         $('#activation_message').text('An error occurred while checking the license status.').css('color', 'red');
    //     }
    // });

    // Handle the activation button click (same as before)
    $('#activate_license_btn').on('click', function() {
        var license_key = $('#license_key').val();
        if (license_key == '') {
            $('#activation_message').text('Please enter a valid license key.');
            return;
        }

        // Send the AJAX request to WordPress to activate the license
        $.ajax({
            url: ajaxurl, // WordPress AJAX URL
            method: 'POST',
            data: {
                action: 'verify_and_activate_license', // Custom action
                license_key: license_key, // Send the license key
            },
            success: function(response) {
                if (response.success) {
                    $('#activation_message').text('Your key is activated successfully.').css('color', 'green');
                    setTimeout(function() {
                        location.reload(); // Refresh the page after 2 seconds
                    }, 2000);
                } else {
                    $('#activation_message').text('Failed to activate license. ' + response.data.message).css('color', 'red');
                }
            },
            error: function() {
                $('#activation_message').text('An error occurred while verifying the license.').css('color', 'red');
            }
        });
    });
});



// Brand details upload 

jQuery(document).ready(function ($) {
    // Fetch brand data when the page loads
    function fetchBrandData() {
        $.ajax({
            url: myPluginAjax.ajax_url,
            type: "POST",
            data: { action: "get_brand_data" },
            success: function (response) {
                if (response.success) {
                    $("#brand_name").val(response.data.brand_name);
                    $("#brand_id").val(response.data.id);

                    if (response.data.brand_logo) {
                        var imageUrl = response.data.brand_logo;
                        $("#brandImagePreview").attr("src", imageUrl).show();
                        $("#brandImageLink").attr("href", imageUrl).show();
                    }
                }
            }
        });
    }

    fetchBrandData(); // Load brand data on page load

    // Image Preview Before Upload
    $("#brand_logo").change(function () {
        var reader = new FileReader();
        reader.onload = function (e) {
            $("#brandImagePreview").attr("src", e.target.result).show();
            $("#brandImageLink").attr("href", e.target.result).show();
        };
        reader.readAsDataURL(this.files[0]);
    });

    // Submit Form Data
    $("#submitBrand").click(function (e) {
        e.preventDefault();

        var formData = new FormData($("#brandForm")[0]);
        formData.append("action", "save_brand"); // WP AJAX Action
        formData.append("nonce", myPluginAjax.nonce_brand); // Add nonce

        $.ajax({
            url: myPluginAjax.ajax_url,
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                if (response.success) {
                    $("#brandMessage").html('<div class="alert alert-success">' + response.data + '</div>');
                    fetchBrandData(); // Refresh the displayed brand data
                    setTimeout(function () {
                        location.reload();
                    }, 2000);
                } else {
                    $("#brandMessage").html('<div class="alert alert-danger">' + response.data + '</div>');
                }
            },
            error: function () {
                $("#brandMessage").html('<div class="alert alert-danger">AJAX request failed.</div>');
            },
        });
    });
});
